/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.languages.database;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.languages.database.DatabaseItem;
import org.netbeans.api.languages.database.DatabaseUsage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseDefinition
extends DatabaseItem {
    private String name;
    private String type;
    private List<DatabaseUsage> usages;
    private URL sourceFileUrl;

    public DatabaseDefinition(String string, String string2, int n, int n2) {
        super(n, n2);
        this.name = string;
        this.type = string2;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public void addUsage(DatabaseUsage databaseUsage) {
        if (this.usages == null) {
            this.usages = new ArrayList<DatabaseUsage>();
        }
        this.usages.add(databaseUsage);
    }

    public List<DatabaseUsage> getUsages() {
        if (this.usages == null) {
            return Collections.emptyList();
        }
        return this.usages;
    }

    public void setSourceFileUrl(URL uRL) {
        this.sourceFileUrl = uRL;
    }

    public URL getSourceFileUrl() {
        return this.sourceFileUrl;
    }

    public String toString() {
        return "Definition " + this.getName() + " (" + this.getType() + ")";
    }

    public static DatabaseDefinition load(DataInputStream dataInputStream) throws IOException {
        return new DatabaseDefinition(dataInputStream.readUTF(), dataInputStream.readUTF(), dataInputStream.readInt(), dataInputStream.readInt());
    }

    public void save(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeUTF(this.name);
        dataOutputStream.writeUTF(this.type);
        dataOutputStream.writeInt(this.getOffset());
        dataOutputStream.writeInt(this.getEndOffset());
    }
}

