/*
 * Decompiled with CFR 0.152.
 */
package mondrian.xmla.test;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import mondrian.olap.Util;

public class XmlaTestServletRequestWrapper
extends HttpServletRequestWrapper {
    private HttpServletRequest originalRequest;
    private ServletInputStream servletInStream;

    public XmlaTestServletRequestWrapper(HttpServletRequest req) {
        super(req);
        this.originalRequest = req;
        this.init();
    }

    private void init() {
        String soapRequest = this.originalRequest.getParameter("SOAPRequest");
        if (soapRequest == null || soapRequest.length() == 0) {
            try {
                ServletInputStream inputStream = this.originalRequest.getInputStream();
                soapRequest = Util.readFully(new InputStreamReader((InputStream)inputStream), 2048);
            }
            catch (IOException e) {
                throw Util.newInternal(e, "error reading body of soap request");
            }
            if (soapRequest == null || soapRequest.length() == 0) {
                throw new RuntimeException("SOAPRequest not set");
            }
        }
        if (soapRequest.indexOf("<?") == 0) {
            soapRequest = soapRequest.substring(soapRequest.indexOf("?>") + 2);
        }
        String request = "<?xml version=\"1.0\"?>\r\n<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n<SOAP-ENV:Header/>\r\n<SOAP-ENV:Body>\r\n" + soapRequest + "</SOAP-ENV:Body>\r\n</SOAP-ENV:Envelope>\r\n";
        this.servletInStream = new XmlaTestServletInputStream(request);
    }

    public String getContentType() {
        return "text/xml";
    }

    public ServletInputStream getInputStream() {
        return this.servletInStream;
    }

    private static class XmlaTestServletInputStream
    extends ServletInputStream {
        private ByteArrayInputStream bais;

        XmlaTestServletInputStream(String source) {
            this.bais = new ByteArrayInputStream(source.getBytes());
        }

        public int readLine(byte[] arg0, int arg1, int arg2) throws IOException {
            return this.bais.read(arg0, arg1, arg2);
        }

        public int available() throws IOException {
            return this.bais.available();
        }

        public void close() throws IOException {
            this.bais.close();
        }

        public synchronized void mark(int readlimit) {
            this.bais.mark(readlimit);
        }

        public boolean markSupported() {
            return this.bais.markSupported();
        }

        public int read() throws IOException {
            return this.bais.read();
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.bais.read(b, off, len);
        }

        public int read(byte[] b) throws IOException {
            return this.bais.read(b);
        }

        public synchronized void reset() throws IOException {
            this.bais.reset();
        }

        public long skip(long n) throws IOException {
            return this.bais.skip(n);
        }
    }
}

