/*
 * Decompiled with CFR 0.152.
 */
package mondrian.util;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import junit.framework.TestCase;
import mondrian.olap.Util;
import mondrian.util.Format;

public class FormatTest
extends TestCase {
    private final Format.FormatLocale localeFra = Format.createLocale('.', ',', "-", "#", "FF", "#,##0.00FF", new String[]{"", "Dim", "Lun", "Mar", "Mer", "Jeu", "Ven", "Sam"}, new String[]{"", "Dimanche", "Lundi", "Mardi", "Mercredi", "Jeudi", "Vendredi", "Samedi"}, new String[]{"Jan", "Fev", "Mar", "Avr", "Mai", "Jui", "Jui", "Aou", "Sep", "Oct", "Nov", "Dec", ""}, new String[]{"Janvier", "Fevrier", "Mars", "Avril", "Mai", "Juin", "Juillet", "Aout", "Septembre", "Octobre", "Novembre", "Decembre", ""}, Locale.FRENCH);
    private final Format.FormatLocale localeDe = Format.createLocale(Locale.GERMAN);
    final Double d = new Double(3141592.653589793);
    final Date date = FormatTest.makeCalendar(1969, 4, 29, 20, 9, 6);
    final Date date2 = FormatTest.makeCalendar(2010, 9, 7, 6, 5, 4);

    public void testNumbers() {
        this.checkNumbersInLocale(null);
    }

    public void testFrenchNumbers() {
        this.checkNumbersInLocale(this.localeFra);
    }

    private void checkNumbersInLocale(Format.FormatLocale locale) {
        this.checkNumbers(locale, "", "6", "-6", "0", "0.6", "");
        this.checkNumbers(locale, "0", "6", "-6", "0", "1", "");
        this.checkNumbers(locale, "0.00", "6.00", "-6.00", "0.00", "0.60", "");
        this.checkNumbers(locale, "#,##0", "6", "-6", "0", "1", "");
        this.checkNumbers(locale, "#,##0.00;;;Nil", "6.00", "-6.00", "0.00", "0.60", "Nil");
        this.checkNumbers(locale, "$#,##0;($#,##0)", "$6", "($6)", "$0", "$1", "");
        this.checkNumbers(locale, "$#,##0.00;($#,##0.00)", "$6.00", "($6.00)", "$0.00", "$0.60", "");
        this.checkNumbers(locale, "0%", "600%", "-600%", "0%", "60%", "");
        this.checkNumbers(locale, "0.00%", "600.00%", "-600.00%", "0.00%", "60.00%", "");
        this.checkNumbers(locale, "0.00E+00", "6.00E+00", "-6.00E+00", "0.00E+00", "6.00E-01", "");
        this.checkNumbers(locale, "0.00E-00", "6.00E00", "-6.00E00", "0.00E00", "6.00E-01", "");
        this.checkNumbers(locale, "$#,##0;;\\Z\\e\\r\\o", "$6", "$-6", "Zero", "$1", "");
        this.checkNumbers(locale, "#,##0.0 USD", "6.0 USD", "-6.0 USD", "0.0 USD", "0.6 USD", "");
        this.checkNumbers(locale, "General Number", "6", "-6", "0", "0.6", "");
        this.checkNumbers(locale, "Currency", "$6.00", "($6.00)", "$0.00", "$0.60", "");
        this.checkNumbers(locale, "Fixed", "6", "-6", "0", "1", "");
        this.checkNumbers(locale, "Standard", "6", "-6", "0", "1", "");
        this.checkNumbers(locale, "Percent", "600.00%", "-600.00%", "0.00%", "60.00%", "");
        this.checkNumbers(locale, "Scientific", "6.00e+00", "-6.00e+00", "0.00e+00", "6.00e-01", "");
        this.checkNumbers(locale, "True/False", "True", "True", "False", "True", "False");
        this.checkNumbers(locale, "On/Off", "On", "On", "Off", "On", "Off");
        this.checkNumbers(locale, "Yes/No", "Yes", "Yes", "No", "Yes", "No");
    }

    private void checkNumbers(Format.FormatLocale locale, String format, String result6, String resultNeg6, String result0, String resultPoint6, String resultEmpty) {
        this.checkNumber(locale, format, new Double(6.0), result6);
        this.checkNumber(locale, format, new Double(-6.0), resultNeg6);
        this.checkNumber(locale, format, new Double(0.0), result0);
        this.checkNumber(locale, format, new Double(0.6), resultPoint6);
        this.checkNumber(locale, format, null, resultEmpty);
        this.checkNumber(locale, format, 6L, result6);
        this.checkNumber(locale, format, -6L, resultNeg6);
        this.checkNumber(locale, format, 0L, result0);
    }

    private void checkNumber(Format.FormatLocale locale, String format, Number number, String expectedResult) {
        if (locale == this.localeFra) {
            expectedResult = FormatTest.convertToFrench(expectedResult, format);
        }
        this.checkFormat(locale, number, format, expectedResult);
    }

    private static String convertToFrench(String result, String format) {
        if (result.startsWith("(") && result.endsWith(")")) {
            result = result.substring(1, result.length() - 1);
            return "(" + FormatTest.convertToFrench(result, format) + ")";
        }
        result = result.replace('.', '!');
        result = result.replace(',', '.');
        result = result.replace('!', ',');
        if (format.equals("Currency") && result.startsWith("$")) {
            result = result.substring(1) + "FF";
        }
        return result;
    }

    public void testTrickyNumbers() {
        this.checkFormat(null, new Double(40.385), "##0.0#", "40.39");
        this.checkFormat(null, new Double(40.386), "##0.0#", "40.39");
        this.checkFormat(null, new Double(40.384), "##0.0#", "40.38");
        this.checkFormat(null, new Double(40.385), "##0.#", "40.4");
        this.checkFormat(null, new Double(40.38), "##0.0#", "40.38");
        this.checkFormat(null, new Double(-40.38), "##0.0#", "-40.38");
        this.checkFormat(null, new Double(0.040385), "#0.###", "0.04");
        this.checkFormat(null, new Double(0.040385), "#0.000", "0.040");
        this.checkFormat(null, new Double(0.040385), "#0.####", "0.0404");
        this.checkFormat(null, new Double(0.040385), "00.####", "00.0404");
        this.checkFormat(null, new Double(0.040385), ".00#", ".04");
        this.checkFormat(null, new Double(0.040785), ".00#", ".041");
        this.checkFormat(null, new Double(99.9999), "##.####", "99.9999");
        this.checkFormat(null, new Double(99.9999), "##.###", "100");
        this.checkFormat(null, new Double(99.9999), "##.00#", "100.00");
        this.checkFormat(null, new Double(9.9E-4), "#.00", ".00");
        this.checkFormat(null, new Double(9.9E-4), "#.00#", ".001");
        this.checkFormat(null, new Double(12.34), "#.000##", "12.340");
        this.checkFormat(null, new Double(1234567.89), "Standard", "1,234,568");
        this.checkFormat(null, new Double(0.0), "$#,##0;;\\Z\\e\\r\\o", "Zero");
    }

    public void testSmallNegativeNumbers() {
        this.checkFormat(null, new Double(-0.006), "#.0", ".0");
        this.checkFormat(null, new Double(-0.006), "#.00", "-.01");
        this.checkFormat(null, new Double(-0.0500001), "#.0", "-.1");
        this.checkFormat(null, new Double(-0.0499999), "#.0", ".0");
        this.checkFormat(null, new Double(-6.0E-5), "#.0%", ".0%");
        this.checkFormat(null, new Double(-6.0E-4), "#.0%", "-.1%");
        this.checkFormat(null, new Double(-4.0E-4), "#.0%", ".0%");
        this.checkFormat(null, new Double(-5.0E-4), "#.0%", "-.1%");
        this.checkFormat(null, new Double(-5.000001E-4), "#.0%", "-.1%");
        this.checkFormat(null, new Double(-6.0E-5), "#.00%", "-.01%");
        this.checkFormat(null, new Double(-4.0E-5), "#.00%", ".00%");
        this.checkFormat(null, new Double(-6.0E-5), "00000.00%", "-00000.01%");
        this.checkFormat(null, new Double(-4.0E-5), "00000.00%", "00000.00%");
        this.checkFormat(null, new Double(-0.001), "0.##;(0.##);Nil", "Nil");
        this.checkFormat(null, new Double(-0.01), "0.##;(0.##);Nil", "(0.01)");
        this.checkFormat(null, new Double(-0.01), "0.##;(0.#);Nil", "Nil");
    }

    public void testNegativeZero() {
        this.checkFormat(null, new Double(-0.0), "#0.000", "0.000");
        this.checkFormat(null, new Double(-0.0), "#0", "0");
        this.checkFormat(null, new Double(-0.0), "#0.0", "0.0");
    }

    public void testNumberRoundingBug() {
        this.checkFormat(null, new Double(0.5), "0", "1");
        this.checkFormat(null, new Double(-1.5), "0", "-2");
        this.checkFormat(null, new Double(-0.5), "0", "-1");
        this.checkFormat(null, new Double(-0.99999999), "0.0", "-1.0");
        this.checkFormat(null, new Double(-0.45), "#.0", "-.5");
        this.checkFormat(null, new Double(-0.45), "0", "0");
        this.checkFormat(null, new Double(-0.49999), "0", "0");
        this.checkFormat(null, new Double(-0.49999), "0.0", "-0.5");
        this.checkFormat(null, new Double(0.49999), "0", "0");
        this.checkFormat(null, new Double(0.49999), "#.0", ".5");
    }

    public void testCurrencyBug() {
        this.checkFormat(this.localeFra, this.d, "#.##0-00 FF", "3141592,654-3141592,654 FF");
    }

    private static Date makeCalendar(int year, int month, int date, int hourOfDay, int minute, int second) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month - 1, date, hourOfDay, minute, second);
        return calendar.getTime();
    }

    public void testDates() {
        this.checkDate("dd-mmm-yy", "29-Apr-69", "29-Avr-69", "29-Apr-69");
        this.checkDate("h:mm:ss AM/PM", "8:09:06 PM", "8#09#06 PM", "8:09:06 PM");
        this.checkDate("hh:mm", "20:09", "20#09", "20:09");
        this.checkDate("Long Date", "Tuesday, April 29, 1969", "Mardi, Avril 29, 1969", "Dienstag, April 29, 1969");
        this.checkDate("Medium Date", "29-Apr-69", "29-Avr-69", "29-Apr-69");
        this.checkDate("Short Date", "4/29/69", "4-29-69", "4.29.69");
        this.checkDate("Long Time", "8:09:06 PM", "8#09#06 PM", "8:09:06 PM");
        this.checkDate("Medium Time", "8:09 PM", "8#09 PM", "8:09 PM");
        this.checkDate("Short Time", "20:09", "20#09", "20:09");
    }

    private void checkDate(String format, String en, String fr, String de) {
        this.checkFormat(null, this.date, format, en);
        this.checkFormat(this.localeFra, this.date, format, fr);
        this.checkFormat(this.localeDe, this.date, format, de);
    }

    public void testAllTokens() {
        for (int i = 0; i < Format.tokens.length; ++i) {
            Format.Token fe = Format.tokens[i];
            Object o = fe.isNumeric() ? this.d : (fe.isDate() ? this.date : (fe.isString() ? "mondrian" : this.d));
            this.checkFormat(null, o, fe.token);
        }
    }

    public void testTrickyDates() {
        this.checkFormat(null, this.date2, "mm/##/yy", "09/##/10");
        this.checkFormat(null, this.date2, "mm/dd/yy", "09/07/10");
        this.checkFormat(null, this.date2, "mm/d/yy", "09/7/10");
        this.checkFormat(null, this.date2, "mm/dd/yy", "09/07/10");
        this.checkFormat(null, this.date2, "MMM/dd/yyyy", "Sep/07/2010");
        this.checkFormat(null, this.date2, "mmm/dd/yyyy", "Sep/07/2010");
        this.checkFormat(null, this.date2, "MMMM/dd/yyyy", "September/07/2010");
        this.checkFormat(null, this.date2, "mmmm/dd/yyyy", "September/07/2010");
        this.checkFormat(null, this.date2, "hh/mm/ss", "06/05/04");
        this.checkFormat(null, this.date2, "Long Date", "Tuesday, September 07, 2010");
        this.checkFormat(null, new Double(1.2), "\u08a4#", "$1");
    }

    public void testFrenchLocale() {
        Format.FormatLocale fr = Format.createLocale(Locale.FRANCE);
        FormatTest.assertEquals((String)"#,##0.00 \u20ac", (String)fr.currencyFormat);
        FormatTest.assertEquals((String)"\u20ac", (String)fr.currencySymbol);
        FormatTest.assertEquals((String)"/", (String)fr.dateSeparator);
        FormatTest.assertEquals((String)"[, dimanche, lundi, mardi, mercredi, jeudi, vendredi, samedi]", (String)Arrays.asList(fr.daysOfWeekLong).toString());
        FormatTest.assertEquals((String)"[, dim., lun., mar., mer., jeu., ven., sam.]", (String)Arrays.asList(fr.daysOfWeekShort).toString());
        FormatTest.assertEquals((String)"[janvier, f\u00e9vrier, mars, avril, mai, juin, juillet, ao\u00fbt, septembre, octobre, novembre, d\u00e9cembre, ]", (String)Arrays.asList(fr.monthsLong).toString());
        FormatTest.assertEquals((String)"[janv., f\u00e9vr., mars, avr., mai, juin, juil., ao\u00fbt, sept., oct., nov., d\u00e9c., ]", (String)Arrays.asList(fr.monthsShort).toString());
        FormatTest.assertEquals((char)',', (char)fr.decimalPlaceholder);
        FormatTest.assertEquals((char)'\u00a0', (char)fr.thousandSeparator);
        FormatTest.assertEquals((String)":", (String)fr.timeSeparator);
    }

    private void checkFormat(Format.FormatLocale locale, Object o, String formatString) {
        Format format = new Format(formatString, locale);
        String actualResult = format.format(o);
        Util.discard((Object)actualResult);
    }

    private void checkFormat(Format.FormatLocale locale, Object o, String formatString, String expectedResult) {
        Format format = new Format(formatString, locale);
        String actualResult = format.format(o);
        FormatTest.assertEquals((String)expectedResult, (String)actualResult);
    }

    public void testCache() {
        StringBuilder buf = new StringBuilder(2010);
        buf.append("0.");
        for (int i = 0; i < 2000; ++i) {
            Format format = Format.get(buf.toString(), null);
            String s = format.format(i);
            FormatTest.assertEquals((String)(i + ""), (String)s);
            buf.append("#");
        }
    }
}

