/*
 * Decompiled with CFR 0.152.
 */
package mondrian.util;

import java.util.ArrayList;
import mondrian.test.FoodMartTestCase;
import mondrian.util.FilteredIterableList;

public class FilteredIterableTest
extends FoodMartTestCase {
    public FilteredIterableTest() {
    }

    public FilteredIterableTest(String name) {
        super(name);
    }

    public void testEmptyList() throws Exception {
        ArrayList<Integer> base = new ArrayList<Integer>();
        for (int i = 0; i < 10; ++i) {
            base.add(i);
        }
        FilteredIterableList empty = new FilteredIterableList(base, new FilteredIterableList.Filter<Integer>(){

            @Override
            public boolean accept(Integer i) {
                return false;
            }
        });
        for (Integer x : empty) {
            FilteredIterableTest.fail((String)"All elements should have been filtered");
        }
    }

    public void testGetter() throws Exception {
        ArrayList<Integer> base = new ArrayList<Integer>();
        for (int i = 0; i < 10; ++i) {
            base.add(i);
        }
        FilteredIterableList empty = new FilteredIterableList(base, new FilteredIterableList.Filter<Integer>(){

            @Override
            public boolean accept(Integer i) {
                return i < 2;
            }
        });
        for (int i = 0; i < 2; ++i) {
            FilteredIterableTest.assertEquals((Object)new Integer(i), empty.get(i));
        }
    }

    public void test2Elements() throws Exception {
        ArrayList<Integer> base = new ArrayList<Integer>();
        for (int i = 0; i < 2; ++i) {
            base.add(i);
        }
        FilteredIterableList identical = new FilteredIterableList(base, new FilteredIterableList.Filter<Integer>(){

            @Override
            public boolean accept(Integer i) {
                return true;
            }
        });
        FilteredIterableTest.assertFalse((boolean)identical.isEmpty());
        FilteredIterableTest.assertNotNull(identical.get(0));
        int k = 0;
        for (Integer i : identical) {
            FilteredIterableTest.assertEquals((Object)i, identical.get(k));
            ++k;
        }
    }
}

