/*
 * Decompiled with CFR 0.152.
 */
package mondrian.util;

import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoordinateIterator
implements Iterator<int[]> {
    private final int[] dimensions;
    private final int[] current;
    private boolean hasNext;

    public CoordinateIterator(int[] dimensions) {
        this.dimensions = dimensions;
        this.current = new int[dimensions.length];
        this.hasNext = true;
        for (int dimension : dimensions) {
            if (dimension > 0) continue;
            this.hasNext = false;
            break;
        }
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public int[] next() {
        int[] result = (int[])this.current.clone();
        this.moveToNext();
        return result;
    }

    private void moveToNext() {
        int offset = this.dimensions.length;
        while (offset > 0) {
            int n = --offset;
            this.current[n] = this.current[n] + 1;
            int k = this.current[n];
            if (k < this.dimensions[offset]) {
                return;
            }
            this.current[offset] = 0;
        }
        this.hasNext = false;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

