/*
 * Decompiled with CFR 0.152.
 */
package mondrian.test;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import mondrian.olap.Util;
import mondrian.test.BasicQueryTest;
import mondrian.test.ChooseRunnable;

class TestCaseForker {
    BasicQueryTest testCase;
    long timeoutMs;
    Thread[] threads;
    List<Throwable> failures = new ArrayList<Throwable>();
    ChooseRunnable chooseRunnable;

    public TestCaseForker(BasicQueryTest testCase, long timeoutMs, int threadCount, ChooseRunnable chooseRunnable) {
        this.testCase = testCase;
        this.timeoutMs = timeoutMs;
        this.threads = new Thread[threadCount];
        this.chooseRunnable = chooseRunnable;
    }

    public void run() {
        ThreadGroup threadGroup = null;
        for (int i = 0; i < this.threads.length; ++i) {
            final int threadIndex = i;
            this.threads[i] = new Thread(threadGroup, "thread #" + threadIndex){

                public void run() {
                    try {
                        TestCaseForker.this.chooseRunnable.run(threadIndex);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        TestCaseForker.this.failures.add(e);
                    }
                }
            };
        }
        for (Thread thread : this.threads) {
            thread.start();
        }
        for (Thread thread : this.threads) {
            try {
                thread.join(this.timeoutMs);
            }
            catch (InterruptedException e) {
                this.failures.add(Util.newInternal(e, "Interrupted after " + this.timeoutMs + "ms"));
                break;
            }
        }
        if (this.failures.size() > 0) {
            for (Throwable throwable : this.failures) {
                throwable.printStackTrace();
            }
            TestCase.fail((String)(this.failures.size() + " threads failed"));
        }
    }
}

