/*
 * Decompiled with CFR 0.152.
 */
package mondrian.test;

import java.io.InputStream;
import mondrian.olap.Result;
import mondrian.olap.Util;
import mondrian.rolap.RolapConnectionProperties;
import mondrian.spi.impl.FilterDynamicSchemaProcessor;
import mondrian.test.FoodMartTestCase;
import mondrian.test.TestContext;

public class NamedSetTest
extends FoodMartTestCase {
    public NamedSetTest() {
    }

    public NamedSetTest(String name) {
        super(name);
    }

    public void testNamedSet() {
        this.assertQueryReturns("WITH\n    SET [Top Sellers]\nAS \n    'TopCount([Warehouse].[Warehouse Name].MEMBERS, 10, \n        [Measures].[Warehouse Sales])'\nSELECT \n    {[Measures].[Warehouse Sales]} ON COLUMNS,\n        {[Top Sellers]} ON ROWS\nFROM \n    [Warehouse]\nWHERE \n    [Time].[Year].[1997]", NamedSetTest.fold("Axis #0:\n{[Time].[1997]}\nAxis #1:\n{[Measures].[Warehouse Sales]}\nAxis #2:\n{[Warehouse].[All Warehouses].[USA].[OR].[Salem].[Treehouse Distribution]}\n{[Warehouse].[All Warehouses].[USA].[WA].[Tacoma].[Jorge Garcia, Inc.]}\n{[Warehouse].[All Warehouses].[USA].[CA].[Los Angeles].[Artesia Warehousing, Inc.]}\n{[Warehouse].[All Warehouses].[USA].[CA].[San Diego].[Jorgensen Service Storage]}\n{[Warehouse].[All Warehouses].[USA].[WA].[Bremerton].[Destination, Inc.]}\n{[Warehouse].[All Warehouses].[USA].[WA].[Seattle].[Quality Warehousing and Trucking]}\n{[Warehouse].[All Warehouses].[USA].[WA].[Spokane].[Jones International]}\n{[Warehouse].[All Warehouses].[USA].[WA].[Yakima].[Maddock Stored Foods]}\n{[Warehouse].[All Warehouses].[USA].[CA].[Beverly Hills].[Big  Quality Warehouse]}\n{[Warehouse].[All Warehouses].[USA].[OR].[Portland].[Quality Distribution, Inc.]}\nRow #0: 31,116.375\nRow #1: 30,743.772\nRow #2: 22,907.959\nRow #3: 22,869.79\nRow #4: 22,187.418\nRow #5: 22,046.942\nRow #6: 10,879.674\nRow #7: 10,212.201\nRow #8: 10,156.496\nRow #9: 7,718.678\n"));
    }

    public void testNamedSetOnMember() {
        switch (this.getTestContext().getDialect().getDatabaseProduct()) {
            case INFOBRIGHT: {
                return;
            }
        }
        this.assertQueryReturns("WITH\n    MEMBER [Measures].[Profit]\nAS '[Measures].[Warehouse Sales] - [Measures].[Warehouse Cost] '\n    SET [Top Performers]\nAS \n    'TopCount([Warehouse].[Warehouse Name].MEMBERS, 5, \n        [Measures].[Profit])'\nSELECT \n    {[Measures].[Profit]} ON COLUMNS,\n        {[Top Performers]} ON ROWS\nFROM \n    [Warehouse]\nWHERE \n    [Time].[Year].[1997].[Q2]", NamedSetTest.fold("Axis #0:\n{[Time].[1997].[Q2]}\nAxis #1:\n{[Measures].[Profit]}\nAxis #2:\n{[Warehouse].[All Warehouses].[USA].[WA].[Bremerton].[Destination, Inc.]}\n{[Warehouse].[All Warehouses].[USA].[CA].[San Diego].[Jorgensen Service Storage]}\n{[Warehouse].[All Warehouses].[USA].[OR].[Salem].[Treehouse Distribution]}\n{[Warehouse].[All Warehouses].[USA].[CA].[Los Angeles].[Artesia Warehousing, Inc.]}\n{[Warehouse].[All Warehouses].[USA].[WA].[Seattle].[Quality Warehousing and Trucking]}\nRow #0: 4,516.756\nRow #1: 4,189.36\nRow #2: 4,169.318\nRow #3: 3,848.647\nRow #4: 3,708.717\n"));
    }

    public void testNamedSetAsList() {
        this.assertQueryReturns("WITH SET [ChardonnayChablis] AS\n   '{[Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Wine].[Good].[Good Chardonnay],\n   [Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Wine].[Pearl].[Pearl Chardonnay],\n   [Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Wine].[Portsmouth].[Portsmouth Chardonnay],\n   [Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Wine].[Top Measure].[Top Measure Chardonnay],\n   [Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Wine].[Walrus].[Walrus Chardonnay],\n   [Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Wine].[Good].[Good Chablis Wine],\n   [Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Wine].[Pearl].[Pearl Chablis Wine],\n   [Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Wine].[Portsmouth].[Portsmouth Chablis Wine],\n   [Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Wine].[Top Measure].[Top Measure Chablis Wine],\n   [Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Wine].[Walrus].[Walrus Chablis Wine]}'\nSELECT\n   [ChardonnayChablis] ON COLUMNS,\n   {Measures.[Unit Sales]} ON ROWS\nFROM Sales", NamedSetTest.fold("Axis #0:\n{}\nAxis #1:\n{[Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Wine].[Good].[Good Chardonnay]}\n{[Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Wine].[Pearl].[Pearl Chardonnay]}\n{[Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Wine].[Portsmouth].[Portsmouth Chardonnay]}\n{[Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Wine].[Top Measure].[Top Measure Chardonnay]}\n{[Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Wine].[Walrus].[Walrus Chardonnay]}\n{[Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Wine].[Good].[Good Chablis Wine]}\n{[Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Wine].[Pearl].[Pearl Chablis Wine]}\n{[Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Wine].[Portsmouth].[Portsmouth Chablis Wine]}\n{[Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Wine].[Top Measure].[Top Measure Chablis Wine]}\n{[Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Wine].[Walrus].[Walrus Chablis Wine]}\nAxis #2:\n{[Measures].[Unit Sales]}\nRow #0: 192\nRow #0: 189\nRow #0: 170\nRow #0: 164\nRow #0: 173\nRow #0: 163\nRow #0: 209\nRow #0: 136\nRow #0: 140\nRow #0: 185\n"));
    }

    public void testIntrinsic() {
        this.assertQueryReturns("WITH SET [ChardonnayChablis] AS\n   'Filter([Product].Members, (InStr(1, [Product].CurrentMember.Name, \"chardonnay\") <> 0) OR (InStr(1, [Product].CurrentMember.Name, \"chablis\") <> 0))'\nSELECT\n   [ChardonnayChablis] ON COLUMNS,\n   {Measures.[Unit Sales]} ON ROWS\nFROM Sales", NamedSetTest.fold("Axis #0:\n{}\nAxis #1:\nAxis #2:\n{[Measures].[Unit Sales]}\n"));
        this.assertQueryReturns("WITH SET [BeerMilk] AS\n   'Filter([Product].Members, (InStr(1, [Product].CurrentMember.Name, \"Beer\") <> 0) OR (InStr(1, LCase([Product].CurrentMember.Name), \"milk\") <> 0))'\nSELECT\n   [BeerMilk] ON COLUMNS,\n   {Measures.[Unit Sales]} ON ROWS\nFROM Sales", NamedSetTest.fold("Axis #0:\n{}\nAxis #1:\n{[Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine]}\n{[Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer]}\n{[Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Good].[Good Imported Beer]}\n{[Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Good].[Good Light Beer]}\n{[Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Pearl].[Pearl Imported Beer]}\n{[Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Pearl].[Pearl Light Beer]}\n{[Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Portsmouth].[Portsmouth Imported Beer]}\n{[Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Portsmouth].[Portsmouth Light Beer]}\n{[Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Top Measure].[Top Measure Imported Beer]}\n{[Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Top Measure].[Top Measure Light Beer]}\n{[Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Walrus].[Walrus Imported Beer]}\n{[Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Walrus].[Walrus Light Beer]}\n{[Product].[All Products].[Drink].[Dairy].[Dairy].[Milk]}\n{[Product].[All Products].[Drink].[Dairy].[Dairy].[Milk].[Booker].[Booker 1% Milk]}\n{[Product].[All Products].[Drink].[Dairy].[Dairy].[Milk].[Booker].[Booker 2% Milk]}\n{[Product].[All Products].[Drink].[Dairy].[Dairy].[Milk].[Booker].[Booker Buttermilk]}\n{[Product].[All Products].[Drink].[Dairy].[Dairy].[Milk].[Booker].[Booker Chocolate Milk]}\n{[Product].[All Products].[Drink].[Dairy].[Dairy].[Milk].[Booker].[Booker Whole Milk]}\n{[Product].[All Products].[Drink].[Dairy].[Dairy].[Milk].[Carlson].[Carlson 1% Milk]}\n{[Product].[All Products].[Drink].[Dairy].[Dairy].[Milk].[Carlson].[Carlson 2% Milk]}\n{[Product].[All Products].[Drink].[Dairy].[Dairy].[Milk].[Carlson].[Carlson Buttermilk]}\n{[Product].[All Products].[Drink].[Dairy].[Dairy].[Milk].[Carlson].[Carlson Chocolate Milk]}\n{[Product].[All Products].[Drink].[Dairy].[Dairy].[Milk].[Carlson].[Carlson Whole Milk]}\n{[Product].[All Products].[Drink].[Dairy].[Dairy].[Milk].[Club].[Club 1% Milk]}\n{[Product].[All Products].[Drink].[Dairy].[Dairy].[Milk].[Club].[Club 2% Milk]}\n{[Product].[All Products].[Drink].[Dairy].[Dairy].[Milk].[Club].[Club Buttermilk]}\n{[Product].[All Products].[Drink].[Dairy].[Dairy].[Milk].[Club].[Club Chocolate Milk]}\n{[Product].[All Products].[Drink].[Dairy].[Dairy].[Milk].[Club].[Club Whole Milk]}\n{[Product].[All Products].[Drink].[Dairy].[Dairy].[Milk].[Even Better].[Even Better 1% Milk]}\n{[Product].[All Products].[Drink].[Dairy].[Dairy].[Milk].[Even Better].[Even Better 2% Milk]}\n{[Product].[All Products].[Drink].[Dairy].[Dairy].[Milk].[Even Better].[Even Better Buttermilk]}\n{[Product].[All Products].[Drink].[Dairy].[Dairy].[Milk].[Even Better].[Even Better Chocolate Milk]}\n{[Product].[All Products].[Drink].[Dairy].[Dairy].[Milk].[Even Better].[Even Better Whole Milk]}\n{[Product].[All Products].[Drink].[Dairy].[Dairy].[Milk].[Gorilla].[Gorilla 1% Milk]}\n{[Product].[All Products].[Drink].[Dairy].[Dairy].[Milk].[Gorilla].[Gorilla 2% Milk]}\n{[Product].[All Products].[Drink].[Dairy].[Dairy].[Milk].[Gorilla].[Gorilla Buttermilk]}\n{[Product].[All Products].[Drink].[Dairy].[Dairy].[Milk].[Gorilla].[Gorilla Chocolate Milk]}\n{[Product].[All Products].[Drink].[Dairy].[Dairy].[Milk].[Gorilla].[Gorilla Whole Milk]}\n{[Product].[All Products].[Food].[Snacks].[Candy].[Chocolate Candy].[Atomic].[Atomic Malted Milk Balls]}\n{[Product].[All Products].[Food].[Snacks].[Candy].[Chocolate Candy].[Choice].[Choice Malted Milk Balls]}\n{[Product].[All Products].[Food].[Snacks].[Candy].[Chocolate Candy].[Gulf Coast].[Gulf Coast Malted Milk Balls]}\n{[Product].[All Products].[Food].[Snacks].[Candy].[Chocolate Candy].[Musial].[Musial Malted Milk Balls]}\n{[Product].[All Products].[Food].[Snacks].[Candy].[Chocolate Candy].[Thresher].[Thresher Malted Milk Balls]}\nAxis #2:\n{[Measures].[Unit Sales]}\nRow #0: 6,838\nRow #0: 1,683\nRow #0: 154\nRow #0: 115\nRow #0: 175\nRow #0: 210\nRow #0: 187\nRow #0: 175\nRow #0: 145\nRow #0: 161\nRow #0: 174\nRow #0: 187\nRow #0: 4,186\nRow #0: 189\nRow #0: 177\nRow #0: 110\nRow #0: 133\nRow #0: 163\nRow #0: 212\nRow #0: 131\nRow #0: 175\nRow #0: 175\nRow #0: 234\nRow #0: 155\nRow #0: 145\nRow #0: 140\nRow #0: 159\nRow #0: 168\nRow #0: 190\nRow #0: 177\nRow #0: 227\nRow #0: 197\nRow #0: 168\nRow #0: 160\nRow #0: 133\nRow #0: 174\nRow #0: 151\nRow #0: 143\nRow #0: 188\nRow #0: 176\nRow #0: 192\nRow #0: 157\nRow #0: 164\n"));
    }

    public void testNamedSetCrossJoin() {
        this.assertQueryReturns("WITH\n    SET [Store Types by Country]\nAS\n    'CROSSJOIN({[Store].[Store Country].MEMBERS},\n               {[Store Type].[Store Type].MEMBERS})'\nSELECT\n    {[Measures].[Units Ordered]} ON COLUMNS,\n    NON EMPTY {[Store Types by Country]} ON ROWS\nFROM\n    [Warehouse]\nWHERE\n    [Time].[1997].[Q2]", NamedSetTest.fold("Axis #0:\n{[Time].[1997].[Q2]}\nAxis #1:\n{[Measures].[Units Ordered]}\nAxis #2:\n{[Store].[All Stores].[USA], [Store Type].[All Store Types].[Deluxe Supermarket]}\n{[Store].[All Stores].[USA], [Store Type].[All Store Types].[Mid-Size Grocery]}\n{[Store].[All Stores].[USA], [Store Type].[All Store Types].[Supermarket]}\nRow #0: 16843.0\nRow #1: 2295.0\nRow #2: 34856.0\n"));
    }

    public void _testXxx() {
        this.assertQueryReturns("WITH MEMBER [Store Type].[All Store Type].[oNormal] AS 'Aggregate(Filter([Customers].[Name].Members, [Customers].CurrentMember.Properties(\"Member Card\") = \"Normal\") * {[Store Type].[All Store Type]})'\nMEMBER [Store Type].[All Store Type].[oBronze] AS 'Aggregate(Filter([Customers].[Name].Members, [Customers].CurrentMember.Properties(\"Member Card\") = \"Bronze\") * {[Store Type].[All Store Type]})'\nMEMBER [Store Type].[All Store Type].[oGolden] AS 'Aggregate(Filter([Customers].[Name].Members, [Customers].CurrentMember.Properties(\"Member Card\") = \"Golden\") * {[Store Type].[All Store Type]})'\nMEMBER [Store Type].[All Store Type].[oSilver] AS 'Aggregate(Filter([Customers].[Name].Members, [Customers].CurrentMember.Properties(\"Member Card\") = \"Silver\") * {[Store Type].[All Store Type]})'\nSET CardTypes AS '{[oNormal], [oBronze], [oGolden], [oSilver]}'\nSELECT {[Unit Sales]} ON COLUMNS, CardTypes ON ROWS\nFROM Sales", "xxxx");
    }

    public void testNamedSetUsedInCrossJoin() {
        this.assertQueryReturns("WITH\n  SET [TopMedia] AS 'TopCount([Promotion Media].children, 5, [Measures].[Store Sales])' \nSELECT {[Time].[1997].[Q1], [Time].[1997].[Q2]} ON COLUMNS,\n {CrossJoin([TopMedia], [Product].children)} ON ROWS\nFROM [Sales]", NamedSetTest.fold("Axis #0:\n{}\nAxis #1:\n{[Time].[1997].[Q1]}\n{[Time].[1997].[Q2]}\nAxis #2:\n{[Promotion Media].[All Media].[No Media], [Product].[All Products].[Drink]}\n{[Promotion Media].[All Media].[No Media], [Product].[All Products].[Food]}\n{[Promotion Media].[All Media].[No Media], [Product].[All Products].[Non-Consumable]}\n{[Promotion Media].[All Media].[Daily Paper, Radio, TV], [Product].[All Products].[Drink]}\n{[Promotion Media].[All Media].[Daily Paper, Radio, TV], [Product].[All Products].[Food]}\n{[Promotion Media].[All Media].[Daily Paper, Radio, TV], [Product].[All Products].[Non-Consumable]}\n{[Promotion Media].[All Media].[Daily Paper], [Product].[All Products].[Drink]}\n{[Promotion Media].[All Media].[Daily Paper], [Product].[All Products].[Food]}\n{[Promotion Media].[All Media].[Daily Paper], [Product].[All Products].[Non-Consumable]}\n{[Promotion Media].[All Media].[Product Attachment], [Product].[All Products].[Drink]}\n{[Promotion Media].[All Media].[Product Attachment], [Product].[All Products].[Food]}\n{[Promotion Media].[All Media].[Product Attachment], [Product].[All Products].[Non-Consumable]}\n{[Promotion Media].[All Media].[Cash Register Handout], [Product].[All Products].[Drink]}\n{[Promotion Media].[All Media].[Cash Register Handout], [Product].[All Products].[Food]}\n{[Promotion Media].[All Media].[Cash Register Handout], [Product].[All Products].[Non-Consumable]}\nRow #0: 3,970\nRow #0: 4,287\nRow #1: 32,939\nRow #1: 33,238\nRow #2: 8,650\nRow #2: 9,057\nRow #3: 142\nRow #3: 364\nRow #4: 975\nRow #4: 2,523\nRow #5: 250\nRow #5: 603\nRow #6: 464\nRow #6: 66\nRow #7: 3,173\nRow #7: 464\nRow #8: 862\nRow #8: 121\nRow #9: 171\nRow #9: 106\nRow #10: 1,344\nRow #10: 814\nRow #11: 362\nRow #11: 165\nRow #12: \nRow #12: 92\nRow #13: \nRow #13: 933\nRow #14: \nRow #14: 229\n"));
    }

    public void testAggOnCalcMember() {
        this.assertQueryReturns("WITH\n  SET [TopMedia] AS 'TopCount([Promotion Media].children, 5, [Measures].[Store Sales])' \n  MEMBER [Measures].[California sales for Top Media] AS 'Sum([TopMedia], ([Store].[USA].[CA], [Measures].[Store Sales]))'\nSELECT {[Time].[1997].[Q1], [Time].[1997].[Q2]} ON COLUMNS,\n {[Product].children} ON ROWS\nFROM [Sales]\nWHERE [Measures].[California sales for Top Media]", NamedSetTest.fold("Axis #0:\n{[Measures].[California sales for Top Media]}\nAxis #1:\n{[Time].[1997].[Q1]}\n{[Time].[1997].[Q2]}\nAxis #2:\n{[Product].[All Products].[Drink]}\n{[Product].[All Products].[Food]}\n{[Product].[All Products].[Non-Consumable]}\nRow #0: 2,725.85\nRow #0: 2,715.56\nRow #1: 21,200.84\nRow #1: 23,263.72\nRow #2: 5,598.71\nRow #2: 6,111.74\n"));
    }

    public void testContextSensitiveNamedSet() {
        this.assertQueryReturns("SELECT {[Measures].[Unit Sales]} ON COLUMNS,\nOrder([Promotion Media].Children, [Measures].[Unit Sales], DESC) ON ROWS\nFROM [Sales]\nWHERE [Time].[1997]", NamedSetTest.fold("Axis #0:\n{[Time].[1997]}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Promotion Media].[All Media].[No Media]}\n{[Promotion Media].[All Media].[Daily Paper, Radio, TV]}\n{[Promotion Media].[All Media].[Daily Paper]}\n{[Promotion Media].[All Media].[Product Attachment]}\n{[Promotion Media].[All Media].[Daily Paper, Radio]}\n{[Promotion Media].[All Media].[Cash Register Handout]}\n{[Promotion Media].[All Media].[Sunday Paper, Radio]}\n{[Promotion Media].[All Media].[Street Handout]}\n{[Promotion Media].[All Media].[Sunday Paper]}\n{[Promotion Media].[All Media].[Bulk Mail]}\n{[Promotion Media].[All Media].[In-Store Coupon]}\n{[Promotion Media].[All Media].[TV]}\n{[Promotion Media].[All Media].[Sunday Paper, Radio, TV]}\n{[Promotion Media].[All Media].[Radio]}\nRow #0: 195,448\nRow #1: 9,513\nRow #2: 7,738\nRow #3: 7,544\nRow #4: 6,891\nRow #5: 6,697\nRow #6: 5,945\nRow #7: 5,753\nRow #8: 4,339\nRow #9: 4,320\nRow #10: 3,798\nRow #11: 3,607\nRow #12: 2,726\nRow #13: 2,454\n"));
        this.assertQueryReturns("SELECT {[Measures].[Unit Sales]} ON COLUMNS,\nOrder([Promotion Media].Children, [Measures].[Unit Sales], DESC) ON ROWS\nFROM [Sales]\nWHERE [Time].[1997].[Q2]", NamedSetTest.fold("Axis #0:\n{[Time].[1997].[Q2]}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Promotion Media].[All Media].[No Media]}\n{[Promotion Media].[All Media].[Daily Paper, Radio, TV]}\n{[Promotion Media].[All Media].[Daily Paper, Radio]}\n{[Promotion Media].[All Media].[Sunday Paper, Radio]}\n{[Promotion Media].[All Media].[TV]}\n{[Promotion Media].[All Media].[Cash Register Handout]}\n{[Promotion Media].[All Media].[Sunday Paper, Radio, TV]}\n{[Promotion Media].[All Media].[Product Attachment]}\n{[Promotion Media].[All Media].[Sunday Paper]}\n{[Promotion Media].[All Media].[Bulk Mail]}\n{[Promotion Media].[All Media].[Daily Paper]}\n{[Promotion Media].[All Media].[Street Handout]}\n{[Promotion Media].[All Media].[Radio]}\n{[Promotion Media].[All Media].[In-Store Coupon]}\nRow #0: 46,582\nRow #1: 3,490\nRow #2: 2,704\nRow #3: 2,327\nRow #4: 1,344\nRow #5: 1,254\nRow #6: 1,108\nRow #7: 1,085\nRow #8: 784\nRow #9: 733\nRow #10: 651\nRow #11: 473\nRow #12: 40\nRow #13: 35\n"));
        this.assertQueryReturns("WITH\n  SET [Bottom Media] AS 'BottomCount([Promotion Media].children, 1, [Measures].[Unit Sales])' \n  MEMBER [Measures].[Unit Sales for Bottom Media] AS 'Sum([Bottom Media], [Measures].[Unit Sales])'\nSELECT {[Measures].[Unit Sales for Bottom Media]} ON COLUMNS,\n {[Time].[1997], [Time].[1997].[Q2]} ON ROWS\nFROM [Sales]", NamedSetTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales for Bottom Media]}\nAxis #2:\n{[Time].[1997]}\n{[Time].[1997].[Q2]}\nRow #0: 2,454\nRow #1: 40\n"));
        this.assertQueryReturns("WITH\n  SET [TopMedia] AS 'TopCount([Promotion Media].children, 3, [Measures].[Store Sales])' \n  MEMBER [Measures].[California sales for Top Media] AS 'Sum([TopMedia], [Measures].[Store Sales])'\nSELECT \n  CrossJoin({[Store], [Store].[USA].[CA]},\n    {[Time].[1997].[Q1], [Time].[1997].[Q2]}) ON COLUMNS,\n {[Product], [Product].children} ON ROWS\nFROM [Sales]\nWHERE [Measures].[California sales for Top Media]", NamedSetTest.fold("Axis #0:\n{[Measures].[California sales for Top Media]}\nAxis #1:\n{[Store].[All Stores], [Time].[1997].[Q1]}\n{[Store].[All Stores], [Time].[1997].[Q2]}\n{[Store].[All Stores].[USA].[CA], [Time].[1997].[Q1]}\n{[Store].[All Stores].[USA].[CA], [Time].[1997].[Q2]}\nAxis #2:\n{[Product].[All Products]}\n{[Product].[All Products].[Drink]}\n{[Product].[All Products].[Food]}\n{[Product].[All Products].[Non-Consumable]}\nRow #0: 108,249.52\nRow #0: 107,649.93\nRow #0: 29,482.53\nRow #0: 28,953.02\nRow #1: 8,930.95\nRow #1: 9,551.93\nRow #1: 2,721.23\nRow #1: 2,444.78\nRow #2: 78,375.66\nRow #2: 77,219.13\nRow #2: 21,165.50\nRow #2: 20,924.43\nRow #3: 20,942.91\nRow #3: 20,878.87\nRow #3: 5,595.80\nRow #3: 5,583.81\n"));
    }

    public void testOrderedNamedSet() {
        this.assertQueryReturns("WITH SET [SET1] AS\n'ORDER ({[Education Level].[Education Level].Members}, [Gender].[All Gender].[F], ASC)'\nMEMBER [Gender].[RANK1] AS 'rank([Education Level].currentmember, [SET1])'\nselect\n{[Gender].[All Gender].[F], [Gender].[RANK1]} on columns,\n{[Education Level].[Education Level].Members} on rows\nfrom Sales\nwhere ([Measures].[Store Sales])", NamedSetTest.fold("Axis #0:\n{[Measures].[Store Sales]}\nAxis #1:\n{[Gender].[All Gender].[F]}\n{[Gender].[RANK1]}\nAxis #2:\n{[Education Level].[All Education Levels].[Bachelors Degree]}\n{[Education Level].[All Education Levels].[Graduate Degree]}\n{[Education Level].[All Education Levels].[High School Degree]}\n{[Education Level].[All Education Levels].[Partial College]}\n{[Education Level].[All Education Levels].[Partial High School]}\nRow #0: 72,119.26\nRow #0: 3\nRow #1: 17,641.64\nRow #1: 1\nRow #2: 81,112.23\nRow #2: 4\nRow #3: 27,175.97\nRow #3: 2\nRow #4: 82,177.11\nRow #4: 5\n"));
        this.assertQueryReturns("WITH SET [SET1] AS\n'ORDER ({[Education Level].[Education Level].Members}, [Gender].[All Gender].[F], ASC)'\nMEMBER [Gender].[RANK1] AS 'rank([Education Level].currentmember, [SET1])'\nselect\n{[Gender].[All Gender].[F], [Gender].[RANK1]} on columns,\n{[Education Level].[Education Level].Members} on rows\nfrom Sales\nwhere ([Measures].[Profit])", NamedSetTest.fold("Axis #0:\n{[Measures].[Profit]}\nAxis #1:\n{[Gender].[All Gender].[F]}\n{[Gender].[RANK1]}\nAxis #2:\n{[Education Level].[All Education Levels].[Bachelors Degree]}\n{[Education Level].[All Education Levels].[Graduate Degree]}\n{[Education Level].[All Education Levels].[High School Degree]}\n{[Education Level].[All Education Levels].[Partial College]}\n{[Education Level].[All Education Levels].[Partial High School]}\nRow #0: $43,382.33\nRow #0: $0.00\nRow #1: $10,599.59\nRow #1: $0.00\nRow #2: $48,766.50\nRow #2: $0.00\nRow #3: $16,306.05\nRow #3: $0.00\nRow #4: $49,394.27\nRow #4: $0.00\n"));
        this.assertQueryReturns("WITH SET [SET1] AS\n'ORDER ({[Education Level].[Education Level].Members}, [Gender].[All Gender].[F], ASC)'\nMEMBER [Gender].[RANK1] AS 'rank([Education Level].currentmember, [SET1])', \n  SOLVE_ORDER = 10\nselect\n{[Gender].[All Gender].[F], [Gender].[RANK1]} on columns,\n{[Education Level].[Education Level].Members} on rows\nfrom Sales\nwhere ([Measures].[Profit])", NamedSetTest.fold("Axis #0:\n{[Measures].[Profit]}\nAxis #1:\n{[Gender].[All Gender].[F]}\n{[Gender].[RANK1]}\nAxis #2:\n{[Education Level].[All Education Levels].[Bachelors Degree]}\n{[Education Level].[All Education Levels].[Graduate Degree]}\n{[Education Level].[All Education Levels].[High School Degree]}\n{[Education Level].[All Education Levels].[Partial College]}\n{[Education Level].[All Education Levels].[Partial High School]}\nRow #0: $43,382.33\nRow #0: 3\nRow #1: $10,599.59\nRow #1: 1\nRow #2: $48,766.50\nRow #2: 4\nRow #3: $16,306.05\nRow #3: 2\nRow #4: $49,394.27\nRow #4: 5\n"));
    }

    public void testGenerate() {
        this.assertQueryReturns("with \n  member [Measures].[DateName] as \n    'Generate({[Time].[1997].[Q1], [Time].[1997].[Q2]}, [Time].CurrentMember.Name) '\nselect {[Measures].[DateName]} on columns,\n {[Time].[1997].[Q1], [Time].[1997].[Q2]} on rows\nfrom [Sales]", NamedSetTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[DateName]}\nAxis #2:\n{[Time].[1997].[Q1]}\n{[Time].[1997].[Q2]}\nRow #0: Q1Q2\nRow #1: Q1Q2\n"));
        this.assertQueryReturns("with \n  member [Measures].[DateName] as \n    'Generate({[Time].[1997].[Q1], [Time].[1997].[Q2]}, [Time].CurrentMember.Name, \" and \") '\nselect {[Measures].[DateName]} on columns,\n {[Time].[1997].[Q1], [Time].[1997].[Q2]} on rows\nfrom [Sales]", NamedSetTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[DateName]}\nAxis #2:\n{[Time].[1997].[Q1]}\n{[Time].[1997].[Q2]}\nRow #0: Q1 and Q2\nRow #1: Q1 and Q2\n"));
    }

    public void testNamedSetAgainstCube() {
        TestContext tc = new TestContext(){

            public Util.PropertyList getFoodMartConnectionProperties() {
                Util.PropertyList properties = super.getFoodMartConnectionProperties();
                properties.put(RolapConnectionProperties.DynamicSchemaProcessor.name(), NamedSetsInCubeProcessor.class.getName());
                properties.put(RolapConnectionProperties.UseSchemaPool.name(), "false");
                return properties;
            }
        };
        tc.assertQueryReturns("SELECT {[Measures].[Unit Sales]} ON COLUMNS,\n {[CA Cities]} ON ROWS\nFROM [Sales]", NamedSetTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Store].[All Stores].[USA].[CA].[Alameda]}\n{[Store].[All Stores].[USA].[CA].[Beverly Hills]}\n{[Store].[All Stores].[USA].[CA].[Los Angeles]}\n{[Store].[All Stores].[USA].[CA].[San Diego]}\n{[Store].[All Stores].[USA].[CA].[San Francisco]}\nRow #0: \nRow #1: 21,333\nRow #2: 25,663\nRow #3: 25,635\nRow #4: 2,117\n"));
        tc.assertQueryReturns("SELECT {[Measures].[Unit Sales]} ON COLUMNS,\n {[Top CA Cities]} ON ROWS\nFROM [Sales]", NamedSetTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Store].[All Stores].[USA].[CA].[Los Angeles]}\n{[Store].[All Stores].[USA].[CA].[San Diego]}\nRow #0: 25,663\nRow #1: 25,635\n"));
        tc.assertQueryReturns("WITH SET [CA Cities] AS '{[Store].[USA].[OR].[Portland]}' SELECT {[Measures].[Unit Sales]} ON COLUMNS,\n {[CA Cities]} ON ROWS\nFROM [Sales]", NamedSetTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Store].[All Stores].[USA].[OR].[Portland]}\nRow #0: 26,079\n"));
        tc.assertQueryReturns("WITH SET [CA Cities] AS '{[Store].[USA].[OR].[Portland]}' SELECT {[Measures].[Unit Sales]} ON COLUMNS,\n {[Top CA Cities]} ON ROWS\nFROM [Sales]", NamedSetTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Store].[All Stores].[USA].[CA].[Los Angeles]}\n{[Store].[All Stores].[USA].[CA].[San Diego]}\nRow #0: 25,663\nRow #1: 25,635\n"));
    }

    public void testNamedSetAgainstSchema() {
        TestContext tc = new TestContext(){

            public Util.PropertyList getFoodMartConnectionProperties() {
                Util.PropertyList properties = super.getFoodMartConnectionProperties();
                properties.put(RolapConnectionProperties.DynamicSchemaProcessor.name(), NamedSetsInCubeAndSchemaProcessor.class.getName());
                properties.put(RolapConnectionProperties.UseSchemaPool.name(), "false");
                return properties;
            }
        };
        tc.assertQueryReturns("SELECT {[Measures].[Store Sales]} on columns,\n Intersect([Top CA Cities], [Top USA Stores]) on rows\nFROM [Sales]", NamedSetTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Store Sales]}\nAxis #2:\n{[Store].[All Stores].[USA].[CA].[Los Angeles]}\nRow #0: 54,545.28\n"));
        tc.assertThrows("SELECT {[Measures].[Store Sales]} on columns,\n Intersect([Top CA Cities], [Top Ukrainian Cities]) on rows\nFROM [Sales]", "MDX object '[Top Ukrainian Cities]' not found in cube 'Sales'");
    }

    public void testBadNamedSet() {
        TestContext tc = TestContext.create(null, null, null, "<NamedSet name=\"Bad\" formula=\"{[Store].[USA].[WA].Children}}\"/>", null, null);
        tc.assertThrows("SELECT {[Measures].[Store Sales]} on columns,\n {[Bad]} on rows\nFROM [Sales]", "Named set 'Bad' has bad formula");
    }

    public void testNamedSetMustBeSet() {
        String queryString = "with set [Foo] as ' [Store].CurrentMember  'select {[Foo]} on columns from [Sales]";
        String pattern = "Set expression '[Foo]' must be a set";
        this.assertThrows(queryString, pattern);
        queryString = "with set [Foo] as ' [Store] 'select {[Foo]} on columns from [Sales]";
        this.assertThrows(queryString, pattern);
        queryString = "with set [Foo] as ' [Store].[Store Country] 'select {[Foo]} on columns from [Sales]";
        this.assertThrows(queryString, pattern);
        queryString = "with set [Foo] as ' [Sales] 'select {[Foo]} on columns from [Sales]";
        this.assertThrows(queryString, "MDX object '[Sales]' not found in cube 'Sales'");
        queryString = "with set [Foo] as ' \"foobar\" 'select {[Foo]} on columns from [Sales]";
        this.assertThrows(queryString, pattern);
        queryString = "with set [Foo] as ' -1.45 'select {[Foo]} on columns from [Sales]";
        this.assertThrows(queryString, pattern);
        queryString = "with set [Foo] as ' ([Gender].[M], [Marital Status].[S]) 'select {[Foo]} on columns from [Sales]";
        this.assertThrows(queryString, pattern);
        queryString = "with set [Foo] as ' CrossJoin([Gender].members, [Marital Status].members) 'select {[Foo]} on columns from [Sales]";
        Result result = this.executeQuery(queryString);
        Util.discard((Object)result);
        queryString = "with set [Foo] as ' [Gender].members 'select {[Foo]} on columns from [Sales]";
        result = this.executeQuery(queryString);
        Util.discard((Object)result);
    }

    public void testNamedSetsMixedWithCalcMembers() {
        TestContext tc = new TestContext(){

            public Util.PropertyList getFoodMartConnectionProperties() {
                Util.PropertyList properties = super.getFoodMartConnectionProperties();
                properties.put(RolapConnectionProperties.DynamicSchemaProcessor.name(), MixedNamedSetSchemaProcessor.class.getName());
                properties.put(RolapConnectionProperties.UseSchemaPool.name(), "false");
                return properties;
            }
        };
        tc.assertQueryReturns(NamedSetTest.fold("select {\n    [Measures].[Unit Sales],\n    [Measures].[CA City Sales]} on columns,\n  Crossjoin(\n    [Time].[1997].Children,\n    [Top Products In CA]) on rows\nfrom [Sales]\nwhere [Marital Status].[S]"), NamedSetTest.fold("Axis #0:\n{[Marital Status].[All Marital Status].[S]}\nAxis #1:\n{[Measures].[Unit Sales]}\n{[Measures].[CA City Sales]}\nAxis #2:\n{[Time].[1997].[Q1], [Product].[All Products].[Food].[Produce]}\n{[Time].[1997].[Q1], [Product].[All Products].[Food].[Snack Foods]}\n{[Time].[1997].[Q1], [Product].[All Products].[Non-Consumable].[Household]}\n{[Time].[1997].[Q2], [Product].[All Products].[Food].[Produce]}\n{[Time].[1997].[Q2], [Product].[All Products].[Food].[Snack Foods]}\n{[Time].[1997].[Q2], [Product].[All Products].[Non-Consumable].[Household]}\n{[Time].[1997].[Q3], [Product].[All Products].[Food].[Produce]}\n{[Time].[1997].[Q3], [Product].[All Products].[Food].[Snack Foods]}\n{[Time].[1997].[Q3], [Product].[All Products].[Non-Consumable].[Household]}\n{[Time].[1997].[Q4], [Product].[All Products].[Food].[Produce]}\n{[Time].[1997].[Q4], [Product].[All Products].[Food].[Snack Foods]}\n{[Time].[1997].[Q4], [Product].[All Products].[Non-Consumable].[Household]}\nRow #0: 4,872\nRow #0: $1,218.0\nRow #1: 3,746\nRow #1: $840.0\nRow #2: 3,425\nRow #2: $817.0\nRow #3: 4,633\nRow #3: $1,320.0\nRow #4: 3,588\nRow #4: $1,058.0\nRow #5: 3,149\nRow #5: $938.0\nRow #6: 4,651\nRow #6: $1,353.0\nRow #7: 3,895\nRow #7: $1,134.0\nRow #8: 3,395\nRow #8: $1,029.0\nRow #9: 5,160\nRow #9: $1,550.0\nRow #10: 4,160\nRow #10: $1,301.0\nRow #11: 3,808\nRow #11: $1,166.0\n"));
    }

    public void testNamedSetAndUnion() {
        this.assertQueryReturns(NamedSetTest.fold("with set [Set Education Level] as\n   '{([Education Level].[All Education Levels].[Bachelors Degree]),\n     ([Education Level].[All Education Levels].[Graduate Degree])}'\nselect\n   {[Measures].[Unit Sales],\n    [Measures].[Store Cost],\n    [Measures].[Store Sales]} ON COLUMNS,\n   UNION(\n      CROSSJOIN(\n         {[Time].[1997].[Q1]},\n          [Set Education Level]), \n      {([Time].[1997].[Q1],\n        [Education Level].[All Education Levels].[Graduate Degree])}) ON ROWS\nfrom [Sales]"), NamedSetTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\n{[Measures].[Store Cost]}\n{[Measures].[Store Sales]}\nAxis #2:\n{[Time].[1997].[Q1], [Education Level].[All Education Levels].[Bachelors Degree]}\n{[Time].[1997].[Q1], [Education Level].[All Education Levels].[Graduate Degree]}\nRow #0: 17,066\nRow #0: 14,234.10\nRow #0: 35,699.43\nRow #1: 3,637\nRow #1: 3,030.82\nRow #1: 7,583.71\n"));
    }

    public void testNamedSetDependencies() {
        TestContext tc = new TestContext(){

            public Util.PropertyList getFoodMartConnectionProperties() {
                Util.PropertyList properties = super.getFoodMartConnectionProperties();
                properties.put(RolapConnectionProperties.DynamicSchemaProcessor.name(), NamedSetsInCubeProcessor.class.getName());
                properties.put(RolapConnectionProperties.UseSchemaPool.name(), "false");
                return properties;
            }
        };
        tc.assertSetExprDependsOn("[Top CA Cities]", "{}");
    }

    public void testHierarchizeNamedSetImmutable() {
        this.assertQueryReturns("with set necj as\nNonEmptyCrossJoin([Customers].[Name].members,[Store].[Store Name].members)\nselect\n{[Measures].[Unit Sales]} on columns,\nTail(hierarchize(necj),5) on rows\nfrom sales", NamedSetTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Customers].[All Customers].[USA].[WA].[Yakima].[Tracy Meyer], [Store].[All Stores].[USA].[WA].[Yakima].[Store 23]}\n{[Customers].[All Customers].[USA].[WA].[Yakima].[Vanessa Thompson], [Store].[All Stores].[USA].[WA].[Yakima].[Store 23]}\n{[Customers].[All Customers].[USA].[WA].[Yakima].[Velma Lykes], [Store].[All Stores].[USA].[WA].[Yakima].[Store 23]}\n{[Customers].[All Customers].[USA].[WA].[Yakima].[William Battaglia], [Store].[All Stores].[USA].[WA].[Yakima].[Store 23]}\n{[Customers].[All Customers].[USA].[WA].[Yakima].[Wilma Fink], [Store].[All Stores].[USA].[WA].[Yakima].[Store 23]}\nRow #0: 44\nRow #1: 128\nRow #2: 55\nRow #3: 149\nRow #4: 89\n"));
    }

    public void testCurrentAndCurrentOrdinal() {
        this.assertQueryReturns("with set [Gender Marital Status] as\n [Gender].members * [Marital Status].members\nmember [Measures].[GMS Ordinal] as\n [Gender Marital Status].CurrentOrdinal\nmember [Measures].[GMS Name]\n as TupleToStr([Gender Marital Status].Current)\nselect {\n  [Measures].[Unit Sales],\n  [Measures].[GMS Ordinal],\n  [Measures].[GMS Name]} on 0,\n {[Gender Marital Status]} on 1\nfrom [Sales]", NamedSetTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\n{[Measures].[GMS Ordinal]}\n{[Measures].[GMS Name]}\nAxis #2:\n{[Gender].[All Gender], [Marital Status].[All Marital Status]}\n{[Gender].[All Gender], [Marital Status].[All Marital Status].[M]}\n{[Gender].[All Gender], [Marital Status].[All Marital Status].[S]}\n{[Gender].[All Gender].[F], [Marital Status].[All Marital Status]}\n{[Gender].[All Gender].[F], [Marital Status].[All Marital Status].[M]}\n{[Gender].[All Gender].[F], [Marital Status].[All Marital Status].[S]}\n{[Gender].[All Gender].[M], [Marital Status].[All Marital Status]}\n{[Gender].[All Gender].[M], [Marital Status].[All Marital Status].[M]}\n{[Gender].[All Gender].[M], [Marital Status].[All Marital Status].[S]}\nRow #0: 266,773\nRow #0: 8\nRow #0: ([Gender].[All Gender].[M], [Marital Status].[All Marital Status].[S])\nRow #1: 131,796\nRow #1: 8\nRow #1: ([Gender].[All Gender].[M], [Marital Status].[All Marital Status].[S])\nRow #2: 134,977\nRow #2: 8\nRow #2: ([Gender].[All Gender].[M], [Marital Status].[All Marital Status].[S])\nRow #3: 131,558\nRow #3: 8\nRow #3: ([Gender].[All Gender].[M], [Marital Status].[All Marital Status].[S])\nRow #4: 65,336\nRow #4: 8\nRow #4: ([Gender].[All Gender].[M], [Marital Status].[All Marital Status].[S])\nRow #5: 66,222\nRow #5: 8\nRow #5: ([Gender].[All Gender].[M], [Marital Status].[All Marital Status].[S])\nRow #6: 135,215\nRow #6: 8\nRow #6: ([Gender].[All Gender].[M], [Marital Status].[All Marital Status].[S])\nRow #7: 66,460\nRow #7: 8\nRow #7: ([Gender].[All Gender].[M], [Marital Status].[All Marital Status].[S])\nRow #8: 68,755\nRow #8: 8\nRow #8: ([Gender].[All Gender].[M], [Marital Status].[All Marital Status].[S])\n"));
    }

    public static class MixedNamedSetSchemaProcessor
    extends FilterDynamicSchemaProcessor {
        protected String filter(String schemaUrl, Util.PropertyList connectInfo, InputStream stream) throws Exception {
            String s = super.filter(schemaUrl, connectInfo, stream);
            int i = s.indexOf("</Cube>");
            s = FoodMartTestCase.fold(s.substring(0, i) + "\n" + "  <CalculatedMember\n" + "      name=\"CA City Sales\"\n" + "      dimension=\"Measures\"\n" + "      visible=\"false\"\n" + "      formula=\"Aggregate([CA Cities], [Measures].[Unit Sales])\">\n" + "    <CalculatedMemberProperty name=\"FORMAT_STRING\" value=\"$#,##0.0\"/>\n" + "  </CalculatedMember>\n" + "<NamedSet name=\"Top Products In CA\">\n" + "  <Formula>TopCount([Product].[Product Department].MEMBERS, 3, ([Time].[1997].[Q3], [Measures].[CA City Sales]))</Formula>\n" + "</NamedSet>\n" + "<NamedSet name=\"CA Cities\" formula=\"{[Store].[USA].[CA].Children}\"/>\n" + s.substring(i));
            return s;
        }
    }

    public static class NamedSetsInCubeAndSchemaProcessor
    extends FilterDynamicSchemaProcessor {
        protected String filter(String schemaUrl, Util.PropertyList connectInfo, InputStream stream) throws Exception {
            String s = super.filter(schemaUrl, connectInfo, stream);
            int i = s.indexOf("</Cube>");
            if ((i = (s = s.substring(0, i) + "\n" + "<NamedSet name=\"CA Cities\" formula=\"{[Store].[USA].[CA].Children}\"/>\n" + "<NamedSet name=\"Top CA Cities\">\n" + "  <Formula>TopCount([CA Cities], 2, [Measures].[Unit Sales])</Formula>\n" + "</NamedSet>\n" + s.substring(i)).indexOf("<Role")) < 0) {
                i = s.indexOf("</Schema>");
            }
            s = FoodMartTestCase.fold(s.substring(0, i) + "\n" + "<NamedSet name=\"CA Cities\" formula=\"{[Store].[USA].[WA].Children}\"/>\n" + "<NamedSet name=\"Top USA Stores\">\n" + "  <Formula>TopCount(Descendants([Store].[USA]), 7)</Formula>\n" + "</NamedSet>\n" + s.substring(i));
            return s;
        }
    }

    public static class NamedSetsInCubeProcessor
    extends FilterDynamicSchemaProcessor {
        public String filter(String schemaUrl, Util.PropertyList connectInfo, InputStream stream) throws Exception {
            String s = super.filter(schemaUrl, connectInfo, stream);
            int i = s.indexOf("</Cube>");
            return s.substring(0, i) + "\n" + "<NamedSet name=\"CA Cities\" formula=\"{[Store].[USA].[CA].Children}\"/>\n" + "<NamedSet name=\"Top CA Cities\">\n" + "  <Formula>TopCount([CA Cities], 2, [Measures].[Unit Sales])</Formula>\n" + "</NamedSet>\n" + s.substring(i);
        }
    }
}

