/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import mondrian.rolap.BitKey;
import mondrian.rolap.RolapStar;
import mondrian.rolap.StarPredicate;
import mondrian.rolap.agg.CellRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregationKey {
    private final RolapStar star;
    private final BitKey constrainedColumnsBitKey;
    private final Map<BitKey, StarPredicate> compoundPredicateMap;

    public AggregationKey(CellRequest request) {
        this.constrainedColumnsBitKey = request.getConstrainedColumnsBitKey();
        this.star = request.getMeasure().getStar();
        this.compoundPredicateMap = request.getCompoundPredicateMap();
    }

    public int hashCode() {
        int retCode = this.constrainedColumnsBitKey.hashCode() ^ this.star.hashCode();
        if (this.compoundPredicateMap != null) {
            for (BitKey bitKey : this.compoundPredicateMap.keySet()) {
                retCode ^= bitKey.hashCode();
            }
        }
        return retCode;
    }

    public boolean hasSameCompoundPredicate(AggregationKey otherKey) {
        boolean isEqual = false;
        if (this.compoundPredicateMap.size() == otherKey.compoundPredicateMap.size()) {
            isEqual = true;
            for (BitKey bitKey : this.compoundPredicateMap.keySet()) {
                StarPredicate thisPred = this.compoundPredicateMap.get(bitKey);
                StarPredicate otherPred = otherKey.compoundPredicateMap.get(bitKey);
                if (thisPred != null && otherPred != null && thisPred.equalConstraint(otherPred)) continue;
                isEqual = false;
                break;
            }
        }
        return isEqual;
    }

    public boolean equals(Object other) {
        if (other instanceof AggregationKey) {
            AggregationKey otherKey = (AggregationKey)other;
            if (this.constrainedColumnsBitKey.equals(otherKey.constrainedColumnsBitKey) && this.star.equals(otherKey.star) && this.hasSameCompoundPredicate(otherKey)) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return this.star.getFactTable().getTableName() + " " + this.constrainedColumnsBitKey.toString() + "\n" + this.compoundPredicateMap.toString();
    }

    public BitKey getConstrainedColumnsBitKey() {
        return this.constrainedColumnsBitKey;
    }

    public RolapStar getStar() {
        return this.star;
    }

    public List<StarPredicate> getCompoundPredicateList() {
        return new ArrayList<StarPredicate>(this.compoundPredicateMap.values());
    }
}

