/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.Arrays;
import java.util.List;
import mondrian.olap.Connection;
import mondrian.olap.Cube;
import mondrian.olap.DriverManager;
import mondrian.olap.MondrianException;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.rolap.RolapConnectionProperties;
import mondrian.test.FoodMartTestCase;
import mondrian.test.TestContext;

public class RolapSchemaReaderTest
extends FoodMartTestCase {
    public RolapSchemaReaderTest(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetCubesWithNoHrCubes() {
        String[] expectedCubes = new String[]{"Sales", "Warehouse", "Warehouse and Sales", "Store", "Sales Ragged", "Sales 2"};
        Connection connection = this.getTestContext().withRole("No HR Cube").getConnection();
        try {
            SchemaReader reader = connection.getSchemaReader();
            Cube[] cubes = reader.getCubes();
            RolapSchemaReaderTest.assertEquals((int)expectedCubes.length, (int)cubes.length);
            this.assertCubeExists(expectedCubes, cubes);
        }
        finally {
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetCubesWithNoRole() {
        String[] expectedCubes = new String[]{"Sales", "Warehouse", "Warehouse and Sales", "Store", "Sales Ragged", "Sales 2", "HR"};
        Connection connection = this.getTestContext().getConnection();
        try {
            SchemaReader reader = connection.getSchemaReader();
            Cube[] cubes = reader.getCubes();
            RolapSchemaReaderTest.assertEquals((int)expectedCubes.length, (int)cubes.length);
            this.assertCubeExists(expectedCubes, cubes);
        }
        finally {
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetCubesForCaliforniaManager() {
        String[] expectedCubes = new String[]{"Sales"};
        Connection connection = this.getTestContext().withRole("California manager").getConnection();
        try {
            SchemaReader reader = connection.getSchemaReader();
            Cube[] cubes = reader.getCubes();
            RolapSchemaReaderTest.assertEquals((int)expectedCubes.length, (int)cubes.length);
            this.assertCubeExists(expectedCubes, cubes);
        }
        finally {
            connection.close();
        }
    }

    public void testConnectUseContentChecksum() {
        Util.PropertyList properties = TestContext.instance().getFoodMartConnectionProperties();
        properties.put(RolapConnectionProperties.UseContentChecksum.name(), "true");
        try {
            DriverManager.getConnection(properties, null);
        }
        catch (MondrianException e) {
            e.printStackTrace();
            RolapSchemaReaderTest.fail((String)"unexpected exception for UseContentChecksum");
        }
    }

    private void assertCubeExists(String[] expectedCubes, Cube[] cubes) {
        List<String> cubesAsList = Arrays.asList(expectedCubes);
        for (Cube cube : cubes) {
            String cubeName = cube.getName();
            RolapSchemaReaderTest.assertTrue((String)("Cube name not found: " + cubeName), (boolean)cubesAsList.contains(cubeName));
        }
    }
}

