/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import javax.sql.DataSource;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Literal;
import mondrian.olap.MondrianProperties;
import mondrian.olap.NativeEvaluator;
import mondrian.olap.SchemaReader;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapNativeSet;
import mondrian.rolap.RolapNativeSql;
import mondrian.rolap.aggmatcher.AggStar;
import mondrian.rolap.sql.SqlQuery;
import mondrian.spi.Dialect;

public class RolapNativeTopCount
extends RolapNativeSet {
    public RolapNativeTopCount() {
        super.setEnabled(MondrianProperties.instance().EnableNativeTopCount.get());
    }

    protected boolean restrictMemberTypes() {
        return true;
    }

    NativeEvaluator createEvaluator(RolapEvaluator evaluator, FunDef fun, Exp[] args) {
        boolean ascending;
        if (!this.isEnabled()) {
            return null;
        }
        if (!TopCountConstraint.isValidContext(evaluator, this.restrictMemberTypes())) {
            return null;
        }
        String funName = fun.getName();
        if ("TopCount".equalsIgnoreCase(funName)) {
            ascending = false;
        } else if ("BottomCount".equalsIgnoreCase(funName)) {
            ascending = true;
        } else {
            return null;
        }
        if (args.length < 2 || args.length > 3) {
            return null;
        }
        RolapNativeSet.CrossJoinArg[] cargs = this.checkCrossJoinArg(evaluator, args[0]);
        if (cargs == null) {
            return null;
        }
        if (this.isPreferInterpreter(cargs, false)) {
            return null;
        }
        if (!(args[1] instanceof Literal)) {
            return null;
        }
        int count = ((Literal)args[1]).getIntValue();
        SchemaReader schemaReader = evaluator.getSchemaReader();
        DataSource ds = schemaReader.getDataSource();
        SqlQuery sqlQuery = SqlQuery.newQuery(ds, "NativeTopCount");
        RolapNativeSql sql = new RolapNativeSql(sqlQuery, null);
        Exp orderByExpr = null;
        if (args.length == 3) {
            orderByExpr = args[2];
            String orderBySQL = sql.generateTopCountOrderBy(args[2]);
            if (orderBySQL == null) {
                return null;
            }
        }
        LOGGER.debug((Object)"using native topcount");
        evaluator = this.overrideContext(evaluator, cargs, sql.getStoredMeasure());
        TopCountConstraint constraint = new TopCountConstraint(count, cargs, evaluator, orderByExpr, ascending);
        RolapNativeSet.SetEvaluator sev = new RolapNativeSet.SetEvaluator(cargs, schemaReader, constraint);
        sev.setMaxRows(count);
        return sev;
    }

    static class TopCountConstraint
    extends RolapNativeSet.SetConstraint {
        Exp orderByExpr;
        boolean ascending;
        Integer count;

        public TopCountConstraint(int count, RolapNativeSet.CrossJoinArg[] args, RolapEvaluator evaluator, Exp orderByExpr, boolean ascending) {
            super(args, evaluator, true);
            this.orderByExpr = orderByExpr;
            this.ascending = ascending;
            this.count = new Integer(count);
        }

        protected boolean isJoinRequired() {
            return true;
        }

        public void addConstraint(SqlQuery sqlQuery, RolapCube baseCube, AggStar aggStar) {
            if (this.orderByExpr != null) {
                RolapNativeSql sql = new RolapNativeSql(sqlQuery, aggStar);
                String orderBySql = sql.generateTopCountOrderBy(this.orderByExpr);
                Dialect dialect = sqlQuery.getDialect();
                if (dialect.requiresOrderByAlias()) {
                    String alias = sqlQuery.nextColumnAlias();
                    alias = dialect.quoteIdentifier(alias);
                    sqlQuery.addSelect(orderBySql, alias);
                    sqlQuery.addOrderBy(alias, this.ascending, true, false);
                } else {
                    sqlQuery.addOrderBy(orderBySql, this.ascending, true, false);
                }
            }
            super.addConstraint(sqlQuery, baseCube, aggStar);
        }

        public Object getCacheKey() {
            ArrayList<Object> key = new ArrayList<Object>();
            key.add(super.getCacheKey());
            if (this.orderByExpr != null) {
                key.add(this.orderByExpr.toString());
            }
            key.add(this.ascending);
            key.add(this.count);
            return key;
        }
    }
}

