/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import javax.sql.DataSource;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.MondrianProperties;
import mondrian.olap.NativeEvaluator;
import mondrian.olap.SchemaReader;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapNativeSet;
import mondrian.rolap.RolapNativeSql;
import mondrian.rolap.SqlConstraintUtils;
import mondrian.rolap.aggmatcher.AggStar;
import mondrian.rolap.sql.SqlQuery;

public class RolapNativeFilter
extends RolapNativeSet {
    public RolapNativeFilter() {
        super.setEnabled(MondrianProperties.instance().EnableNativeFilter.get());
    }

    protected boolean restrictMemberTypes() {
        return true;
    }

    NativeEvaluator createEvaluator(RolapEvaluator evaluator, FunDef fun, Exp[] args) {
        if (!this.isEnabled()) {
            return null;
        }
        if (!FilterConstraint.isValidContext(evaluator, this.restrictMemberTypes())) {
            return null;
        }
        String funName = fun.getName();
        if (!"Filter".equalsIgnoreCase(funName)) {
            return null;
        }
        if (args.length != 2) {
            return null;
        }
        RolapNativeSet.CrossJoinArg[] cargs = this.checkCrossJoinArg(evaluator, args[0]);
        if (cargs == null) {
            return null;
        }
        if (this.isPreferInterpreter(cargs, false)) {
            return null;
        }
        SchemaReader schemaReader = evaluator.getSchemaReader();
        DataSource ds = schemaReader.getDataSource();
        SqlQuery sqlQuery = SqlQuery.newQuery(ds, "NativeFilter");
        RolapNativeSql sql = new RolapNativeSql(sqlQuery, null);
        String filterExpr = sql.generateFilterCondition(args[1]);
        if (filterExpr == null) {
            return null;
        }
        if (SqlConstraintUtils.containsCalculatedMember(evaluator.getMembers())) {
            return null;
        }
        LOGGER.debug((Object)"using native filter");
        evaluator = this.overrideContext(evaluator, cargs, sql.getStoredMeasure());
        FilterConstraint constraint = new FilterConstraint(cargs, evaluator, args[1]);
        return new RolapNativeSet.SetEvaluator(this, cargs, schemaReader, constraint);
    }

    static class FilterConstraint
    extends RolapNativeSet.SetConstraint {
        Exp filterExpr;

        public FilterConstraint(RolapNativeSet.CrossJoinArg[] args, RolapEvaluator evaluator, Exp filterExpr) {
            super(args, evaluator, true);
            this.filterExpr = filterExpr;
        }

        protected boolean isJoinRequired() {
            return true;
        }

        public void addConstraint(SqlQuery sqlQuery, RolapCube baseCube, AggStar aggStar) {
            RolapNativeSql sql = new RolapNativeSql(sqlQuery, aggStar);
            String filterSql = sql.generateFilterCondition(this.filterExpr);
            sqlQuery.addHaving(filterSql);
            super.addConstraint(sqlQuery, baseCube, aggStar);
        }

        public Object getCacheKey() {
            ArrayList<Object> key = new ArrayList<Object>();
            key.add(super.getCacheKey());
            if (this.filterExpr != null) {
                key.add(this.filterExpr.toString());
            }
            return key;
        }
    }
}

