/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mondrian.olap.Axis;
import mondrian.olap.AxisOrdinal;
import mondrian.olap.CacheControl;
import mondrian.olap.Connection;
import mondrian.olap.Cube;
import mondrian.olap.Id;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Position;
import mondrian.olap.Property;
import mondrian.olap.Query;
import mondrian.olap.Result;
import mondrian.olap.SchemaReader;
import mondrian.rolap.MemberCache;
import mondrian.rolap.MemberReader;
import mondrian.rolap.RolapCubeMember;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapMember;
import mondrian.rolap.SmartMemberReader;
import mondrian.test.DiffRepository;
import mondrian.test.FoodMartTestCase;
import mondrian.test.TestContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemberCacheControlTest
extends FoodMartTestCase {
    private final boolean rolapCubeMemberCacheEnabled;

    public MemberCacheControlTest() {
        this.rolapCubeMemberCacheEnabled = MondrianProperties.instance().EnableRolapCubeMemberCache.get();
    }

    public MemberCacheControlTest(String name) {
        super(name);
        this.rolapCubeMemberCacheEnabled = MondrianProperties.instance().EnableRolapCubeMemberCache.get();
    }

    DiffRepository getDiffRepos() {
        return DiffRepository.lookup(MemberCacheControlTest.class);
    }

    @Override
    public TestContext getTestContext() {
        return TestContext.createSubstitutingCube("Sales", "  <Dimension name=\"Retail\" foreignKey=\"store_id\">\n    <Hierarchy hasAll=\"true\" primaryKey=\"store_id\">\n      <Table name=\"store\"/>\n      <Level name=\"State\" column=\"store_state\" uniqueMembers=\"true\">\n        <Property name=\"Country\" column=\"store_country\"/>\n      </Level>\n      <Level name=\"City\" column=\"store_city\" uniqueMembers=\"true\">\n        <Property name=\"Population\" column=\"store_postal_code\"/>\n      </Level>\n      <Level name=\"Name\" column=\"store_name\" uniqueMembers=\"true\">\n        <Property name=\"Store Type\" column=\"store_type\"/>\n        <Property name=\"Store Manager\" column=\"store_manager\"/>\n        <Property name=\"Store Sqft\" column=\"store_sqft\" type=\"Numeric\"/>\n        <Property name=\"Has coffee bar\" column=\"coffee_bar\" type=\"Boolean\"/>\n        <Property name=\"Street address\" column=\"store_street_address\" type=\"String\"/>\n      </Level>\n    </Hierarchy>\n   </Dimension>");
    }

    private static <K, V> Map<K, V> createMap(List<K> keys, List<V> values) {
        assert (keys.size() == values.size());
        HashMap<K, V> map = new HashMap<K, V>(keys.size());
        for (int i = 0; i < keys.size(); ++i) {
            map.put(keys.get(i), values.get(i));
        }
        return map;
    }

    protected static RolapMember findMember(TestContext tc, String cubeName, String ... names) {
        Cube cube = tc.getConnection().getSchema().lookupCube(cubeName, true);
        SchemaReader scr = cube.getSchemaReader(null);
        return (RolapMember)scr.getMemberByUniqueName(Id.Segment.toList(names), true);
    }

    private static PrintWriter printMemberProperties(PrintWriter pw, Member member) {
        pw.print(member.getUniqueName());
        pw.print(" {");
        int k = -1;
        for (Property p : member.getLevel().getProperties()) {
            if (++k > 0) {
                pw.print(",");
            }
            pw.println();
            String name = p.getName();
            Object value = member.getPropertyValue(name);
            if (value != null) {
                if (name.equals("Has coffee bar")) {
                    if (value instanceof Number) {
                        value = ((Number)value).intValue() != 0;
                    }
                } else if (name.endsWith(" Sqft")) {
                    Number number = (Number)value;
                    value = number.equals(number.intValue()) ? number.intValue() : Math.round(number.floatValue());
                }
            }
            pw.print("  [");
            pw.print(name);
            pw.print("]=[");
            pw.print(value);
            pw.print("]");
        }
        pw.println("}");
        return pw;
    }

    private static PrintWriter printMemberProperties(PrintWriter pw, Axis axis) {
        for (Position pos : axis.getPositions()) {
            for (Member m : pos) {
                MemberCacheControlTest.printMemberProperties(pw, m).println();
            }
        }
        return pw;
    }

    private static PrintWriter printRowMemberProperties(PrintWriter pw, Result result) {
        return MemberCacheControlTest.printMemberProperties(pw, result.getAxes()[AxisOrdinal.StandardAxisOrdinal.ROWS.logicalOrdinal()]);
    }

    private static String getRowMemberPropertiesAsString(Result r) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        MemberCacheControlTest.printRowMemberProperties(pw, r);
        pw.flush();
        return sw.toString();
    }

    private CacheControl.MemberSet createInterestingMemberSet(TestContext tc, CacheControl cc) {
        return cc.createUnionSet(cc.createMemberSet(MemberCacheControlTest.findMember(tc, "Sales", "Retail", "OR"), true), cc.createMemberSet(MemberCacheControlTest.findMember(tc, "Sales", "Retail", "Zacatecas", "Hidalgo"), true), cc.createMemberSet(MemberCacheControlTest.findMember(tc, "Sales", "Retail", "CA", "Alameda", "HQ"), false), cc.createMemberSet(true, MemberCacheControlTest.findMember(tc, "Sales", "Retail", "WA", "Bremerton"), true, MemberCacheControlTest.findMember(tc, "Sales", "Retail", "Yucatan", "Merida"), false), cc.createMemberSet(true, MemberCacheControlTest.findMember(tc, "Sales", "Retail", "DF"), true, MemberCacheControlTest.findMember(tc, "Sales", "Retail", "Jalisco"), true));
    }

    public void testFilter() {
        TestContext tc = this.getTestContext();
        Connection conn = tc.getConnection();
        DiffRepository dr = this.getDiffRepos();
        CacheControl cc = conn.getCacheControl(null);
        CacheControl.MemberSet memberSet = this.createInterestingMemberSet(tc, cc);
        dr.assertEquals("before", "${before}", memberSet.toString());
        RolapMember orMember = MemberCacheControlTest.findMember(tc, "Sales", "Retail", "OR");
        CacheControl.MemberSet filteredMemberSet = cc.filter(orMember.getLevel(), memberSet);
        dr.assertEquals("after", "${after}", filteredMemberSet.toString());
    }

    public void testMemberOpsFailIfCacheEnabled() {
        if (!this.rolapCubeMemberCacheEnabled) {
            return;
        }
        TestContext tc = this.getTestContext();
        Connection conn = tc.getConnection();
        CacheControl cc = conn.getCacheControl(null);
        CacheControl.MemberEditCommand command = cc.createDeleteCommand(MemberCacheControlTest.findMember(tc, "Sales", "Retail", "OR"));
        try {
            cc.execute(command);
            MemberCacheControlTest.fail((String)"expected exception");
        }
        catch (IllegalArgumentException e) {
            MemberCacheControlTest.assertEquals((String)"Member cache control operations are not allowed unless property mondrian.rolap.EnableRolapCubeMemberCache is false", (String)e.getMessage());
        }
    }

    public void testSetPropertyCommandOnLeafMember() {
        if (this.rolapCubeMemberCacheEnabled) {
            return;
        }
        TestContext tc = this.getTestContext();
        Connection conn = tc.getConnection();
        DiffRepository dr = this.getDiffRepos();
        CacheControl cc = conn.getCacheControl(null);
        String mdx = "SELECT {[Measures].[Unit Sales]} ON COLUMNS, {[Store].[USA].[CA].[San Francisco].[Store 14]} ON ROWS FROM [Sales]";
        Query q = conn.parseQuery(mdx);
        Result r = conn.execute(q);
        dr.assertEquals("props before", "${props before}", MemberCacheControlTest.getRowMemberPropertiesAsString(r));
        String resultString = TestContext.toString(r);
        dr.assertEquals("result before", "${result before}", resultString);
        RolapMember m = MemberCacheControlTest.findMember(tc, "Sales", "Store", "USA", "CA", "San Francisco", "Store 14");
        cc.execute(cc.createSetPropertyCommand(m, "Store Manager", "Higgins"));
        cc.execute(cc.createCompoundCommand(Arrays.asList(cc.createSetPropertyCommand(m, "Street address", "770 Mission St"), cc.createSetPropertyCommand(m, "Store Sqft", 6000), cc.createSetPropertyCommand(m, "Has coffee bar", "false"))));
        r = conn.execute(q);
        dr.assertEquals("props after", "${props after}", MemberCacheControlTest.getRowMemberPropertiesAsString(r));
        MemberCacheControlTest.assertEquals((String)resultString, (String)TestContext.toString(r));
    }

    public void testSetPropertyCommandOnNonLeafMember() {
        CacheControl.MemberEditCommand command;
        if (this.rolapCubeMemberCacheEnabled) {
            return;
        }
        TestContext tc = this.getTestContext();
        Connection conn = tc.getConnection();
        DiffRepository dr = this.getDiffRepos();
        CacheControl cc = tc.getConnection().getCacheControl(null);
        String mdx = "SELECT {[Measures].[Unit Sales]} ON COLUMNS, {[Retail].Members} ON ROWS FROM [Sales]";
        Query q = conn.parseQuery(mdx);
        Result r = conn.execute(q);
        dr.assertEquals("props before", "${props before}", MemberCacheControlTest.getRowMemberPropertiesAsString(r));
        String resultString = TestContext.toString(r);
        dr.assertEquals("result before", "${result before}", resultString);
        CacheControl.MemberSet memberSet = this.createInterestingMemberSet(tc, cc);
        Map<String, Object> propertyValues = MemberCacheControlTest.createMap(Arrays.asList("Has coffee bar", "Store Sqft"), Arrays.asList("true", 123));
        try {
            command = cc.createSetPropertyCommand(memberSet, propertyValues);
            MemberCacheControlTest.fail((String)("expected exception, got " + command));
        }
        catch (IllegalArgumentException e) {
            MemberCacheControlTest.assertEquals((String)"all members in set must belong to same level", (String)e.getMessage());
        }
        RolapMember hqMember = MemberCacheControlTest.findMember(tc, "Sales", "Retail", "CA", "Alameda", "HQ");
        CacheControl.MemberSet filteredMemberSet = cc.filter(hqMember.getLevel(), memberSet);
        command = cc.createSetPropertyCommand(filteredMemberSet, propertyValues);
        cc.execute(command);
        r = conn.execute(q);
        dr.assertEquals("props after", "${props after}", MemberCacheControlTest.getRowMemberPropertiesAsString(r));
        MemberCacheControlTest.assertEquals((String)resultString, (String)TestContext.toString(r));
    }

    public void testAddCommand() {
        if (this.rolapCubeMemberCacheEnabled) {
            return;
        }
        TestContext tc = this.getTestContext();
        Connection conn = tc.getConnection();
        CacheControl cc = conn.getCacheControl(null);
        RolapCubeMember caCubeMember = (RolapCubeMember)MemberCacheControlTest.findMember(tc, "Sales", "Retail", "CA");
        RolapMember caMember = caCubeMember.rolapMember;
        RolapMember rootMember = caMember.getParentMember();
        RolapHierarchy hierarchy = caMember.getHierarchy();
        RolapMember berkeleyMember = (RolapMember)hierarchy.createMember(caMember, caMember.getLevel().getChildLevel(), "Berkeley", null);
        RolapMember store987Member = (RolapMember)hierarchy.createMember(berkeleyMember, berkeleyMember.getLevel().getChildLevel(), "Store 987", null);
        tc.assertAxisReturns("[Retail].[CA].Children", MemberCacheControlTest.fold("[Retail].[All Retails].[CA].[Alameda]\n[Retail].[All Retails].[CA].[Beverly Hills]\n[Retail].[All Retails].[CA].[Los Angeles]\n[Retail].[All Retails].[CA].[San Diego]\n[Retail].[All Retails].[CA].[San Francisco]"));
        MemberReader memberReader = hierarchy.getMemberReader();
        MemberCache memberCache = ((SmartMemberReader)memberReader).getMemberCache();
        List<RolapMember> caChildren = memberCache.getChildrenFromCache(caMember, null);
        MemberCacheControlTest.assertEquals((int)5, (int)caChildren.size());
        CacheControl.MemberEditCommand command = cc.createCompoundCommand(cc.createAddCommand(berkeleyMember), cc.createAddCommand(store987Member));
        cc.execute(command);
        caChildren = memberCache.getChildrenFromCache(caMember, null);
        MemberCacheControlTest.assertNull(caChildren);
        List<RolapMember> berkeleyChildren = memberCache.getChildrenFromCache(berkeleyMember, null);
        MemberCacheControlTest.assertNull(berkeleyChildren);
        List<RolapMember> rootChildren = memberCache.getChildrenFromCache(rootMember, null);
        if (rootChildren != null) {
            MemberCacheControlTest.assertEquals((int)3, (int)rootChildren.size());
        }
    }

    public void testDeleteCommand() {
        List<RolapMember> rootChildren;
        if (this.rolapCubeMemberCacheEnabled) {
            return;
        }
        TestContext tc = this.getTestContext();
        Connection conn = tc.getConnection();
        CacheControl cc = conn.getCacheControl(null);
        RolapCubeMember alamedaCubeMember = (RolapCubeMember)MemberCacheControlTest.findMember(tc, "Sales", "Retail", "CA", "Alameda");
        RolapMember alamedaMember = alamedaCubeMember.rolapMember;
        RolapMember caMember = alamedaMember.getParentMember();
        RolapMember rootMember = caMember.getParentMember();
        RolapHierarchy hierarchy = caMember.getHierarchy();
        tc.assertAxisReturns("[Retail].[CA].Children", MemberCacheControlTest.fold("[Retail].[All Retails].[CA].[Alameda]\n[Retail].[All Retails].[CA].[Beverly Hills]\n[Retail].[All Retails].[CA].[Los Angeles]\n[Retail].[All Retails].[CA].[San Diego]\n[Retail].[All Retails].[CA].[San Francisco]"));
        MemberReader memberReader = hierarchy.getMemberReader();
        MemberCache memberCache = ((SmartMemberReader)memberReader).getMemberCache();
        List<RolapMember> caChildren = memberCache.getChildrenFromCache(caMember, null);
        MemberCacheControlTest.assertEquals((int)5, (int)caChildren.size());
        CacheControl.MemberEditCommand command = cc.createDeleteCommand(alamedaMember);
        cc.execute(command);
        caChildren = memberCache.getChildrenFromCache(caMember, null);
        if (caChildren != null) {
            MemberCacheControlTest.assertEquals((int)4, (int)caChildren.size());
        }
        if ((rootChildren = memberCache.getChildrenFromCache(rootMember, null)) != null) {
            MemberCacheControlTest.assertEquals((int)9999, (int)rootChildren.size());
        }
    }

    public void testAddCommandNegative() {
        CacheControl.MemberEditCommand command;
        if (this.rolapCubeMemberCacheEnabled) {
            return;
        }
        TestContext tc = this.getTestContext();
        Connection conn = tc.getConnection();
        CacheControl cc = conn.getCacheControl(null);
        try {
            command = cc.createAddCommand(null);
            MemberCacheControlTest.fail((String)("expected exception, got " + command));
        }
        catch (IllegalArgumentException e) {
            MemberCacheControlTest.assertEquals((String)"cannot add null member", (String)e.getMessage());
        }
        RolapCubeMember alamedaCubeMember = (RolapCubeMember)MemberCacheControlTest.findMember(tc, "Sales", "Retail", "CA", "Alameda");
        RolapMember alamedaMember = alamedaCubeMember.rolapMember;
        RolapMember caMember = alamedaMember.getParentMember();
        RolapCubeMember empCubeMember = (RolapCubeMember)MemberCacheControlTest.findMember(tc, "HR", "Employees", "Sheri Nowmer", "Michael Spence");
        RolapMember empMember = empCubeMember.rolapMember;
        try {
            command = cc.createMoveCommand(null, alamedaMember);
            MemberCacheControlTest.fail((String)("expected exception, got " + command));
        }
        catch (IllegalArgumentException e) {
            MemberCacheControlTest.assertEquals((String)"cannot move null member", (String)e.getMessage());
        }
        try {
            command = cc.createMoveCommand(alamedaMember, null);
            MemberCacheControlTest.fail((String)("expected exception, got " + command));
        }
        catch (IllegalArgumentException e) {
            MemberCacheControlTest.assertEquals((String)"cannot move member to null location", (String)e.getMessage());
        }
        try {
            command = cc.createDeleteCommand((Member)null);
            MemberCacheControlTest.fail((String)("expected exception, got " + command));
        }
        catch (IllegalArgumentException e) {
            MemberCacheControlTest.assertEquals((String)"cannot delete null member", (String)e.getMessage());
        }
        try {
            command = cc.createSetPropertyCommand(null, "foo", 1);
            MemberCacheControlTest.fail((String)("expected exception, got " + command));
        }
        catch (IllegalArgumentException e) {
            MemberCacheControlTest.assertEquals((String)"cannot set properties on null member", (String)e.getMessage());
        }
        try {
            command = cc.createAddCommand(empMember);
            MemberCacheControlTest.fail((String)("expected exception, got " + command));
        }
        catch (IllegalArgumentException e) {
            MemberCacheControlTest.assertEquals((String)"add member not supported for parent-child hierarchy", (String)e.getMessage());
        }
        try {
            command = cc.createMoveCommand(empMember, null);
            MemberCacheControlTest.fail((String)("expected exception, got " + command));
        }
        catch (IllegalArgumentException e) {
            MemberCacheControlTest.assertEquals((String)"move member not supported for parent-child hierarchy", (String)e.getMessage());
        }
        try {
            command = cc.createDeleteCommand(empMember);
            MemberCacheControlTest.fail((String)("expected exception, got " + command));
        }
        catch (IllegalArgumentException e) {
            MemberCacheControlTest.assertEquals((String)"delete member not supported for parent-child hierarchy", (String)e.getMessage());
        }
        try {
            command = cc.createSetPropertyCommand(empMember, "foo", "bar");
            MemberCacheControlTest.fail((String)("expected exception, got " + command));
        }
        catch (IllegalArgumentException e) {
            MemberCacheControlTest.assertEquals((String)"set properties not supported for parent-child hierarchy", (String)e.getMessage());
        }
        try {
            command = cc.createSetPropertyCommand(cc.createUnionSet(cc.createMemberSet(alamedaMember, false), cc.createMemberSet(caMember, false)), Collections.<String, Object>emptyMap());
            MemberCacheControlTest.fail((String)("expected exception, got " + command));
        }
        catch (IllegalArgumentException e) {
            MemberCacheControlTest.assertEquals((String)"all members in set must belong to same level", (String)e.getMessage());
        }
    }
}

