/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import mondrian.olap.CacheControl;
import mondrian.olap.Cube;
import mondrian.olap.Dimension;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Schema;
import mondrian.olap.Util;
import mondrian.resource.MondrianResource;
import mondrian.rolap.MemberCache;
import mondrian.rolap.MemberReader;
import mondrian.rolap.RolapCubeLevel;
import mondrian.rolap.RolapCubeMember;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapSchema;
import mondrian.rolap.RolapStar;
import mondrian.rolap.RolapStoredMeasure;
import mondrian.rolap.SmartMemberReader;
import org.eigenbase.util.property.BooleanProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheControlImpl
implements CacheControl {
    private static final Object MEMBER_CACHE_LOCK = new Object();

    @Override
    public CacheControl.CellRegion createMemberRegion(Member member, boolean descendants) {
        if (member == null) {
            throw new NullPointerException();
        }
        ArrayList<Member> list = new ArrayList<Member>();
        list.add(member);
        return new MemberCellRegion(list, descendants);
    }

    @Override
    public CacheControl.CellRegion createMemberRegion(boolean lowerInclusive, Member lowerMember, boolean upperInclusive, Member upperMember, boolean descendants) {
        if (lowerMember == null) {
            lowerInclusive = false;
        }
        if (upperMember == null) {
            upperInclusive = false;
        }
        return new MemberRangeCellRegion((RolapMember)lowerMember, lowerInclusive, (RolapMember)upperMember, upperInclusive, descendants);
    }

    @Override
    public CacheControl.CellRegion createCrossjoinRegion(CacheControl.CellRegion ... regions) {
        assert (regions != null);
        assert (regions.length >= 2);
        HashSet<Dimension> set = new HashSet<Dimension>();
        ArrayList<CellRegionImpl> list = new ArrayList<CellRegionImpl>();
        for (CacheControl.CellRegion region : regions) {
            int prevSize = set.size();
            List<Dimension> dimensionality = region.getDimensionality();
            set.addAll(dimensionality);
            if (set.size() < prevSize + dimensionality.size()) {
                throw MondrianResource.instance().CacheFlushCrossjoinDimensionsInCommon.ex(this.getDimensionalityList(regions));
            }
            this.flattenCrossjoin((CellRegionImpl)region, list);
        }
        return new CrossjoinCellRegion(list);
    }

    private String getDimensionalityList(CacheControl.CellRegion[] regions) {
        StringBuilder buf = new StringBuilder();
        int k = 0;
        for (CacheControl.CellRegion region : regions) {
            if (k++ > 0) {
                buf.append(", ");
            }
            buf.append("'");
            buf.append(region.getDimensionality().toString());
            buf.append("'");
        }
        return buf.toString();
    }

    @Override
    public CacheControl.CellRegion createUnionRegion(CacheControl.CellRegion ... regions) {
        if (regions == null) {
            throw new NullPointerException();
        }
        if (regions.length < 2) {
            throw new IllegalArgumentException();
        }
        ArrayList<CellRegionImpl> list = new ArrayList<CellRegionImpl>();
        for (CacheControl.CellRegion region : regions) {
            if (!((Object)region.getDimensionality()).equals(regions[0].getDimensionality())) {
                throw MondrianResource.instance().CacheFlushUnionDimensionalityMismatch.ex(regions[0].getDimensionality().toString(), region.getDimensionality().toString());
            }
            list.add((CellRegionImpl)region);
        }
        return new UnionCellRegion(list);
    }

    @Override
    public CacheControl.CellRegion createMeasuresRegion(Cube cube) {
        Dimension measuresDimension = cube.getDimensions()[0];
        List<Member> measures = cube.getSchemaReader(null).getLevelMembers(measuresDimension.getHierarchy().getLevels()[0], false);
        return new MemberCellRegion(measures, false);
    }

    @Override
    public void flush(CacheControl.CellRegion region) {
        List<Dimension> dimensionality = region.getDimensionality();
        boolean found = false;
        for (Dimension dimension : dimensionality) {
            if (!dimension.isMeasures()) continue;
            found = true;
            break;
        }
        if (!found) {
            throw MondrianResource.instance().CacheFlushRegionMustContainMembers.ex();
        }
        UnionCellRegion union = this.normalize((CellRegionImpl)region);
        for (CellRegionImpl cellRegion : union.regions) {
            this.flushNonUnion(cellRegion);
        }
    }

    protected void flushRegionList(List<CacheControl.CellRegion> cellRegionList) {
        CacheControl.CellRegion cellRegion;
        switch (cellRegionList.size()) {
            case 0: {
                return;
            }
            case 1: {
                cellRegion = cellRegionList.get(0);
                break;
            }
            default: {
                CacheControl.CellRegion[] cellRegions = cellRegionList.toArray(new CacheControl.CellRegion[cellRegionList.size()]);
                cellRegion = this.createUnionRegion(cellRegions);
            }
        }
        this.flush(cellRegion);
    }

    @Override
    public void trace(String message) {
    }

    @Override
    public void flushSchemaCache() {
        RolapSchema.Pool.instance().clear();
    }

    @Override
    public void flushSchema(String catalogUrl, String connectionKey, String jdbcUser, String dataSourceStr) {
        RolapSchema.Pool.instance().remove(catalogUrl, connectionKey, jdbcUser, dataSourceStr);
    }

    @Override
    public void flushSchema(String catalogUrl, DataSource dataSource) {
        RolapSchema.Pool.instance().remove(catalogUrl, dataSource);
    }

    @Override
    public void flushSchema(Schema schema) {
        if (!RolapSchema.class.isInstance(schema)) {
            throw new UnsupportedOperationException(schema.getClass().getName() + " cannot be flushed");
        }
        RolapSchema.Pool.instance().remove((RolapSchema)schema);
    }

    protected void flushNonUnion(CacheControl.CellRegion region) {
        throw new UnsupportedOperationException();
    }

    UnionCellRegion normalize(CellRegionImpl region) {
        LinkedList<CellRegionImpl> nonUnionList = new LinkedList<CellRegionImpl>();
        this.flattenUnion(region, nonUnionList);
        for (int i = 0; i < nonUnionList.size(); ++i) {
            CellRegionImpl nonUnionRegion;
            UnionCellRegion firstUnion;
            while ((firstUnion = this.findFirstUnion(nonUnionRegion = (CellRegionImpl)nonUnionList.get(i))) != null) {
                ArrayList<CellRegionImpl> list = new ArrayList<CellRegionImpl>();
                for (CellRegionImpl unionComponent : firstUnion.regions) {
                    CellRegionImpl cj = this.copyReplacing(nonUnionRegion, firstUnion, unionComponent);
                    list.add(cj);
                }
                nonUnionList.remove(i);
                nonUnionList.addAll(i, list);
            }
        }
        return new UnionCellRegion(nonUnionList);
    }

    private CellRegionImpl copyReplacing(CellRegionImpl region, CellRegionImpl seek, CellRegionImpl replacement) {
        if (region == seek) {
            return replacement;
        }
        if (region instanceof UnionCellRegion) {
            UnionCellRegion union = (UnionCellRegion)region;
            ArrayList<CellRegionImpl> list = new ArrayList<CellRegionImpl>();
            for (CellRegionImpl child : union.regions) {
                list.add(this.copyReplacing(child, seek, replacement));
            }
            return new UnionCellRegion(list);
        }
        if (region instanceof CrossjoinCellRegion) {
            CrossjoinCellRegion crossjoin = (CrossjoinCellRegion)region;
            ArrayList<CellRegionImpl> list = new ArrayList<CellRegionImpl>();
            for (CellRegionImpl child : crossjoin.components) {
                list.add(this.copyReplacing(child, seek, replacement));
            }
            return new CrossjoinCellRegion(list);
        }
        return region;
    }

    private void flattenUnion(CellRegionImpl region, List<CellRegionImpl> list) {
        if (region instanceof UnionCellRegion) {
            UnionCellRegion union = (UnionCellRegion)region;
            for (CellRegionImpl region1 : union.regions) {
                this.flattenUnion(region1, list);
            }
        } else {
            list.add(region);
        }
    }

    private void flattenCrossjoin(CellRegionImpl region, List<CellRegionImpl> list) {
        if (region instanceof CrossjoinCellRegion) {
            CrossjoinCellRegion crossjoin = (CrossjoinCellRegion)region;
            for (CellRegionImpl component : crossjoin.components) {
                this.flattenCrossjoin(component, list);
            }
        } else {
            list.add(region);
        }
    }

    private UnionCellRegion findFirstUnion(CacheControl.CellRegion region) {
        CellRegionVisitorImpl visitor = new CellRegionVisitorImpl(){

            public void visit(UnionCellRegion region) {
                throw new FoundOne(region);
            }
        };
        try {
            ((CellRegionImpl)region).accept(visitor);
            return null;
        }
        catch (FoundOne foundOne) {
            return foundOne.region;
        }
    }

    static List<Member> findMeasures(CacheControl.CellRegion region) {
        final ArrayList<Member> list = new ArrayList<Member>();
        CellRegionVisitorImpl visitor = new CellRegionVisitorImpl(){

            public void visit(MemberCellRegion region) {
                if (region.dimension.isMeasures()) {
                    list.addAll(region.memberList);
                }
            }

            public void visit(MemberRangeCellRegion region) {
                if (region.level.getDimension().isMeasures()) assert (false) : "ranges on measures dimension";
            }
        };
        ((CellRegionImpl)region).accept(visitor);
        return list;
    }

    static List<RolapStar> getStarList(CacheControl.CellRegion region) {
        ArrayList<RolapStar> starList = new ArrayList<RolapStar>();
        List<Member> measuresList = CacheControlImpl.findMeasures(region);
        for (Member measure : measuresList) {
            RolapStoredMeasure storedMeasure;
            RolapStar.Measure starMeasure;
            if (!(measure instanceof RolapStoredMeasure) || starList.contains((starMeasure = (RolapStar.Measure)(storedMeasure = (RolapStoredMeasure)measure).getStarMeasure()).getStar())) continue;
            starList.add(starMeasure.getStar());
        }
        return starList;
    }

    @Override
    public void printCacheState(PrintWriter pw, CacheControl.CellRegion region) {
        List<RolapStar> starList = CacheControlImpl.getStarList(region);
        for (RolapStar star : starList) {
            star.print(pw, "", false);
        }
    }

    @Override
    public CacheControl.MemberSet createMemberSet(Member member, boolean descendants) {
        return new SimpleMemberSet(Collections.singletonList((RolapMember)member), descendants);
    }

    @Override
    public CacheControl.MemberSet createMemberSet(boolean lowerInclusive, Member lowerMember, boolean upperInclusive, Member upperMember, boolean descendants) {
        if (lowerMember == null) {
            lowerInclusive = false;
        }
        if (upperMember == null) {
            upperInclusive = false;
        }
        return new RangeMemberSet(CacheControlImpl.stripMember((RolapMember)lowerMember), lowerInclusive, CacheControlImpl.stripMember((RolapMember)upperMember), upperInclusive, descendants);
    }

    @Override
    public CacheControl.MemberSet createUnionSet(CacheControl.MemberSet ... args) {
        return new UnionMemberSet(Arrays.asList(args));
    }

    @Override
    public CacheControl.MemberSet filter(Level level, CacheControl.MemberSet baseSet) {
        if (level instanceof RolapCubeLevel) {
            level = ((RolapCubeLevel)level).getRolapLevel();
        }
        return ((MemberSetPlus)baseSet).filter((RolapLevel)level);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush(CacheControl.MemberSet memberSet) {
        Object object = MEMBER_CACHE_LOCK;
        synchronized (object) {
            final ArrayList<CacheControl.CellRegion> cellRegionList = new ArrayList<CacheControl.CellRegion>();
            ((MemberSetPlus)memberSet).accept(new MemberSetVisitorImpl(){

                public void visit(RolapMember member) {
                    CacheControlImpl.this.flushMember(member, cellRegionList);
                }
            });
            this.flushRegionList(cellRegionList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printCacheState(PrintWriter pw, CacheControl.MemberSet set) {
        Object object = MEMBER_CACHE_LOCK;
        synchronized (object) {
            pw.println("need to implement printCacheState");
        }
    }

    @Override
    public CacheControl.MemberEditCommand createCompoundCommand(List<CacheControl.MemberEditCommand> commandList) {
        return new CompoundCommand(commandList);
    }

    @Override
    public CacheControl.MemberEditCommand createCompoundCommand(CacheControl.MemberEditCommand ... commands) {
        return new CompoundCommand(Arrays.asList(commands));
    }

    @Override
    public CacheControl.MemberEditCommand createDeleteCommand(Member member) {
        if (member == null) {
            throw new IllegalArgumentException("cannot delete null member");
        }
        if (((RolapLevel)member.getLevel()).isParentChild()) {
            throw new IllegalArgumentException("delete member not supported for parent-child hierarchy");
        }
        return this.createDeleteCommand(this.createMemberSet(member, false));
    }

    @Override
    public CacheControl.MemberEditCommand createDeleteCommand(CacheControl.MemberSet s) {
        return new DeleteMemberCommand((MemberSetPlus)s);
    }

    @Override
    public CacheControl.MemberEditCommand createAddCommand(Member member) throws IllegalArgumentException {
        if (member == null) {
            throw new IllegalArgumentException("cannot add null member");
        }
        if (((RolapLevel)member.getLevel()).isParentChild()) {
            throw new IllegalArgumentException("add member not supported for parent-child hierarchy");
        }
        return new AddMemberCommand((RolapMember)member);
    }

    @Override
    public CacheControl.MemberEditCommand createMoveCommand(Member member, Member loc) throws IllegalArgumentException {
        if (member == null) {
            throw new IllegalArgumentException("cannot move null member");
        }
        if (((RolapLevel)member.getLevel()).isParentChild()) {
            throw new IllegalArgumentException("move member not supported for parent-child hierarchy");
        }
        if (loc == null) {
            throw new IllegalArgumentException("cannot move member to null location");
        }
        return new MoveMemberCommand((RolapMember)member, (RolapMember)loc);
    }

    @Override
    public CacheControl.MemberEditCommand createSetPropertyCommand(Member member, String name, Object value) throws IllegalArgumentException {
        if (member == null) {
            throw new IllegalArgumentException("cannot set properties on null member");
        }
        if (((RolapLevel)member.getLevel()).isParentChild()) {
            throw new IllegalArgumentException("set properties not supported for parent-child hierarchy");
        }
        return new ChangeMemberPropsCommand(new SimpleMemberSet(Collections.singletonList((RolapMember)member), false), Collections.singletonMap(name, value));
    }

    @Override
    public CacheControl.MemberEditCommand createSetPropertyCommand(CacheControl.MemberSet members, Map<String, Object> propertyValues) throws IllegalArgumentException {
        this.validateSameLevel((MemberSetPlus)members);
        return new ChangeMemberPropsCommand((MemberSetPlus)members, propertyValues);
    }

    private void validateSameLevel(MemberSetPlus memberSet) throws IllegalArgumentException {
        memberSet.accept(new MemberSetVisitor(){
            final Set<RolapLevel> levelSet = new HashSet<RolapLevel>();

            private void visitMember(RolapMember member, boolean descendants) {
                String message = "all members in set must belong to same level";
                if (this.levelSet.add(member.getLevel()) && this.levelSet.size() > 1) {
                    throw new IllegalArgumentException("all members in set must belong to same level");
                }
                if (descendants && member.getLevel().getChildLevel() != null) {
                    throw new IllegalArgumentException("all members in set must belong to same level");
                }
            }

            public void visit(SimpleMemberSet simpleMemberSet) {
                for (RolapMember member : simpleMemberSet.members) {
                    this.visitMember(member, simpleMemberSet.descendants);
                }
            }

            public void visit(UnionMemberSet unionMemberSet) {
                for (MemberSetPlus item : unionMemberSet.items) {
                    item.accept(this);
                }
            }

            public void visit(RangeMemberSet rangeMemberSet) {
                this.visitMember(rangeMemberSet.lowerMember, rangeMemberSet.descendants);
                this.visitMember(rangeMemberSet.upperMember, rangeMemberSet.descendants);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(CacheControl.MemberEditCommand cmd) {
        BooleanProperty prop = MondrianProperties.instance().EnableRolapCubeMemberCache;
        if (prop.get()) {
            throw new IllegalArgumentException("Member cache control operations are not allowed unless property " + prop.getPath() + " is false");
        }
        Object object = MEMBER_CACHE_LOCK;
        synchronized (object) {
            ArrayList<CacheControl.CellRegion> cellRegionList = new ArrayList<CacheControl.CellRegion>();
            ((MemberEditCommandPlus)cmd).execute(cellRegionList);
        }
    }

    private static MemberCache getMemberCache(RolapMember member) {
        MemberReader memberReader = member.getHierarchy().getMemberReader();
        SmartMemberReader smartMemberReader = (SmartMemberReader)memberReader;
        return smartMemberReader.getMemberCache();
    }

    private static RolapMember stripMember(RolapMember member) {
        if (member instanceof RolapCubeMember) {
            member = ((RolapCubeMember)member).rolapMember;
        }
        return member;
    }

    private static void stripMemberList(List<RolapMember> members) {
        for (int i = 0; i < members.size(); ++i) {
            RolapMember member = members.get(i);
            if (!(member instanceof RolapCubeMember)) continue;
            members.set(i, ((RolapCubeMember)member).rolapMember);
        }
    }

    private void deleteMember(RolapMember member, RolapMember previousParent, List<CacheControl.CellRegion> cellRegionList) {
        MemberCache memberCache = CacheControlImpl.getMemberCache(member);
        Object key = memberCache.makeKey(previousParent, member.getKey());
        memberCache.removeMember(key);
        cellRegionList.add(this.createMemberRegion(member, true));
    }

    private void addMember(RolapMember member, RolapMember parent, List<CacheControl.CellRegion> cellRegionList) {
        MemberCache memberCache = CacheControlImpl.getMemberCache(member);
        Object parentKey = memberCache.makeKey(parent.getParentMember(), parent.getKey());
        memberCache.removeMember(parentKey);
        cellRegionList.add(this.createMemberRegion(parent, false));
    }

    private void flushMember(RolapMember member, List<CacheControl.CellRegion> cellRegionList) {
        cellRegionList.add(this.createMemberRegion(member, false));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ChangeMemberPropsCommand
    extends MemberSetVisitorImpl
    implements MemberEditCommandPlus {
        final MemberSetPlus memberSet;
        final Map<String, Object> propertyValues;

        ChangeMemberPropsCommand(MemberSetPlus memberSet, Map<String, Object> propertyValues) {
            this.memberSet = memberSet;
            this.propertyValues = propertyValues;
        }

        public String toString() {
            return "CreateMemberPropsCommand(" + this.memberSet + ", " + this.propertyValues + ")";
        }

        @Override
        public void execute(List<CacheControl.CellRegion> cellRegionList) {
            this.memberSet.accept(this);
        }

        @Override
        public void visit(RolapMember member) {
            Object cacheKey;
            MemberCache memberCache = CacheControlImpl.getMemberCache(member = CacheControlImpl.stripMember(member));
            RolapMember cacheMember = memberCache.getMember(cacheKey = memberCache.makeKey(member.getParentMember(), member.getKey()));
            if (cacheMember == null) {
                return;
            }
            for (Map.Entry<String, Object> entry : this.propertyValues.entrySet()) {
                cacheMember.setProperty(entry.getKey(), entry.getValue());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MoveMemberCommand
    implements MemberEditCommandPlus {
        private final RolapMember member;
        private final RolapMember newParent;

        MoveMemberCommand(RolapMember member, RolapMember newParent) {
            this.member = member;
            this.newParent = newParent;
        }

        public String toString() {
            return "MoveMemberCommand(" + this.member + ", " + this.newParent + ")";
        }

        @Override
        public void execute(List<CacheControl.CellRegion> cellRegionList) {
            CacheControlImpl.this.deleteMember(this.member, this.member.getParentMember(), cellRegionList);
            this.member.setParentMember(this.newParent);
            CacheControlImpl.this.addMember(this.member, this.member.getParentMember(), cellRegionList);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AddMemberCommand
    implements MemberEditCommandPlus {
        private final RolapMember member;

        public AddMemberCommand(RolapMember member) {
            assert (member != null);
            this.member = CacheControlImpl.stripMember(member);
        }

        public String toString() {
            return "AddMemberCommand(" + this.member + ")";
        }

        @Override
        public void execute(List<CacheControl.CellRegion> cellRegionList) {
            CacheControlImpl.this.addMember(this.member, this.member.getParentMember(), cellRegionList);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DeleteMemberCommand
    extends MemberSetVisitorImpl
    implements MemberEditCommandPlus {
        private final MemberSetPlus set;
        private List<CacheControl.CellRegion> cellRegionList;

        DeleteMemberCommand(MemberSetPlus set) {
            this.set = set;
        }

        public String toString() {
            return "DeleteMemberCommand(" + this.set + ")";
        }

        @Override
        public void execute(List<CacheControl.CellRegion> cellRegionList) {
            this.cellRegionList = cellRegionList;
            this.set.accept(this);
            this.cellRegionList = null;
        }

        @Override
        public void visit(RolapMember member) {
            CacheControlImpl.this.deleteMember(member, member.getParentMember(), this.cellRegionList);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CompoundCommand
    implements MemberEditCommandPlus {
        private final List<MemberEditCommandPlus> commandList;

        CompoundCommand(List<MemberEditCommandPlus> commandList) {
            this.commandList = commandList;
        }

        public String toString() {
            return Util.commaList("Compound", this.commandList);
        }

        @Override
        public void execute(List<CacheControl.CellRegion> cellRegionList) {
            for (MemberEditCommandPlus command : this.commandList) {
                command.execute(cellRegionList);
            }
        }
    }

    static class RangeMemberSet
    implements MemberSetPlus {
        private final RolapMember lowerMember;
        private final boolean lowerInclusive;
        private final RolapMember upperMember;
        private final boolean upperInclusive;
        private final boolean descendants;
        private final RolapLevel level;

        RangeMemberSet(RolapMember lowerMember, boolean lowerInclusive, RolapMember upperMember, boolean upperInclusive, boolean descendants) {
            assert (lowerMember != null || upperMember != null);
            assert (lowerMember == null || upperMember == null || lowerMember.getLevel() == upperMember.getLevel());
            assert (lowerMember != null || !lowerInclusive);
            assert (upperMember != null || !upperInclusive);
            assert (!(lowerMember instanceof RolapCubeMember));
            assert (!(upperMember instanceof RolapCubeMember));
            this.lowerMember = lowerMember;
            this.lowerInclusive = lowerInclusive;
            this.upperMember = upperMember;
            this.upperInclusive = upperInclusive;
            this.descendants = descendants;
            this.level = lowerMember == null ? upperMember.getLevel() : lowerMember.getLevel();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Range(");
            if (this.lowerMember == null) {
                sb.append("null");
            } else {
                sb.append(this.lowerMember);
                if (this.lowerInclusive) {
                    sb.append(" inclusive");
                } else {
                    sb.append(" exclusive");
                }
            }
            sb.append(" to ");
            if (this.upperMember == null) {
                sb.append("null");
            } else {
                sb.append(this.upperMember);
                if (this.upperInclusive) {
                    sb.append(" inclusive");
                } else {
                    sb.append(" exclusive");
                }
            }
            sb.append(")");
            return sb.toString();
        }

        public void accept(MemberSetVisitor visitor) {
            visitor.visit(this);
        }

        public MemberSetPlus filter(RolapLevel level) {
            if (level == this.level) {
                return this;
            }
            return this.filter2(level, this.level, this.lowerMember, this.upperMember);
        }

        public MemberSetPlus filter2(RolapLevel seekLevel, RolapLevel level, RolapMember lower, RolapMember upper) {
            if (level == seekLevel) {
                return new RangeMemberSet(lower, this.lowerInclusive, upper, this.upperInclusive, false);
            }
            if (this.descendants && level.getHierarchy() == seekLevel.getHierarchy() && level.getDepth() < seekLevel.getDepth()) {
                MemberReader memberReader = level.getHierarchy().getMemberReader();
                ArrayList<RolapMember> list = new ArrayList<RolapMember>();
                memberReader.getMemberChildren(lower, list);
                if (list.isEmpty()) {
                    return EmptyMemberSet.INSTANCE;
                }
                RolapMember lowerChild = (RolapMember)list.get(0);
                list.clear();
                memberReader.getMemberChildren(upper, list);
                if (list.isEmpty()) {
                    return EmptyMemberSet.INSTANCE;
                }
                RolapMember upperChild = (RolapMember)list.get(list.size() - 1);
                return this.filter2(seekLevel, (RolapLevel)level.getChildLevel(), lowerChild, upperChild);
            }
            return EmptyMemberSet.INSTANCE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class UnionMemberSet
    implements MemberSetPlus {
        private final List<MemberSetPlus> items;

        UnionMemberSet(List<MemberSetPlus> items) {
            this.items = items;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Union(");
            for (int i = 0; i < this.items.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                MemberSetPlus item = this.items.get(i);
                sb.append(item.toString());
            }
            sb.append(")");
            return sb.toString();
        }

        @Override
        public void accept(MemberSetVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public MemberSetPlus filter(RolapLevel level) {
            ArrayList<MemberSetPlus> filteredItems = new ArrayList<MemberSetPlus>();
            for (MemberSetPlus item : this.items) {
                MemberSetPlus filteredItem = item.filter(level);
                if (filteredItem == EmptyMemberSet.INSTANCE) continue;
                assert (!(filteredItem instanceof EmptyMemberSet));
                filteredItems.add(filteredItem);
            }
            if (filteredItems.isEmpty()) {
                return EmptyMemberSet.INSTANCE;
            }
            if (((Object)filteredItems).equals(this.items)) {
                return this;
            }
            return new UnionMemberSet(filteredItems);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SimpleMemberSet
    implements MemberSetPlus {
        public final List<RolapMember> members;
        public final boolean descendants;
        public final RolapHierarchy hierarchy;

        SimpleMemberSet(List<RolapMember> members, boolean descendants) {
            this.members = new ArrayList<RolapMember>(members);
            CacheControlImpl.stripMemberList(this.members);
            this.descendants = descendants;
            this.hierarchy = members.isEmpty() ? null : members.get(0).getHierarchy();
        }

        public String toString() {
            return Util.commaList("Member", this.members);
        }

        @Override
        public void accept(MemberSetVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public MemberSetPlus filter(RolapLevel level) {
            ArrayList<RolapMember> filteredMembers = new ArrayList<RolapMember>();
            for (RolapMember member : this.members) {
                if (!member.getLevel().equals(level)) continue;
                filteredMembers.add(member);
            }
            if (filteredMembers.isEmpty()) {
                return EmptyMemberSet.INSTANCE;
            }
            if (((Object)filteredMembers).equals(this.members)) {
                return this;
            }
            return new SimpleMemberSet(filteredMembers, false);
        }
    }

    static class EmptyMemberSet
    implements MemberSetPlus {
        public static final EmptyMemberSet INSTANCE = new EmptyMemberSet();

        private EmptyMemberSet() {
        }

        public void accept(MemberSetVisitor visitor) {
        }

        public MemberSetPlus filter(RolapLevel level) {
            return this;
        }

        public String toString() {
            return "Empty";
        }
    }

    public static abstract class MemberSetVisitorImpl
    implements MemberSetVisitor {
        public void visit(UnionMemberSet s) {
            for (MemberSetPlus item : s.items) {
                item.accept(this);
            }
        }

        public void visit(RangeMemberSet s) {
            MemberReader memberReader = s.level.getHierarchy().getMemberReader();
            this.visitRange(memberReader, s.level, s.lowerMember, s.upperMember, s.descendants);
        }

        protected void visitRange(MemberReader memberReader, RolapLevel level, RolapMember lowerMember, RolapMember upperMember, boolean recurse) {
            ArrayList<RolapMember> list = new ArrayList<RolapMember>();
            memberReader.getMemberRange(level, lowerMember, upperMember, list);
            for (RolapMember member : list) {
                this.visit(member);
            }
            if (recurse) {
                list.clear();
                memberReader.getMemberChildren(lowerMember, list);
                if (list.isEmpty()) {
                    return;
                }
                RolapMember lowerChild = (RolapMember)list.get(0);
                list.clear();
                memberReader.getMemberChildren(upperMember, list);
                if (list.isEmpty()) {
                    return;
                }
                RolapMember upperChild = (RolapMember)list.get(list.size() - 1);
                this.visitRange(memberReader, level, lowerChild, upperChild, recurse);
            }
        }

        public void visit(SimpleMemberSet s) {
            for (RolapMember member : s.members) {
                this.visit(member);
            }
        }

        public abstract void visit(RolapMember var1);
    }

    static interface MemberSetVisitor {
        public void visit(SimpleMemberSet var1);

        public void visit(UnionMemberSet var1);

        public void visit(RangeMemberSet var1);
    }

    static interface MemberSetPlus
    extends CacheControl.MemberSet {
        public void accept(MemberSetVisitor var1);

        public MemberSetPlus filter(RolapLevel var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface MemberEditCommandPlus
    extends CacheControl.MemberEditCommand {
        public void execute(List<CacheControl.CellRegion> var1);
    }

    private static class CellRegionVisitorImpl
    implements CellRegionVisitor {
        private CellRegionVisitorImpl() {
        }

        public void visit(MemberCellRegion region) {
        }

        public void visit(MemberRangeCellRegion region) {
        }

        public void visit(UnionCellRegion region) {
        }

        public void visit(CrossjoinCellRegion region) {
        }
    }

    private static class FoundOne
    extends RuntimeException {
        private final transient UnionCellRegion region;

        public FoundOne(UnionCellRegion region) {
            this.region = region;
        }
    }

    static interface CellRegionVisitor {
        public void visit(MemberCellRegion var1);

        public void visit(MemberRangeCellRegion var1);

        public void visit(UnionCellRegion var1);

        public void visit(CrossjoinCellRegion var1);
    }

    static interface CellRegionImpl
    extends CacheControl.CellRegion {
        public void accept(CellRegionVisitor var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnionCellRegion
    implements CellRegionImpl {
        private final List<CellRegionImpl> regions;

        UnionCellRegion(List<CellRegionImpl> regions) {
            this.regions = regions;
            assert (regions.size() >= 1);
            for (int i = 1; i < regions.size(); ++i) {
                CacheControl.CellRegion region0 = regions.get(0);
                CacheControl.CellRegion region = regions.get(i);
                assert (((Object)region0.getDimensionality()).equals(region.getDimensionality()));
            }
        }

        @Override
        public List<Dimension> getDimensionality() {
            return this.regions.get(0).getDimensionality();
        }

        public String toString() {
            return Util.commaList("Union", this.regions);
        }

        @Override
        public void accept(CellRegionVisitor visitor) {
            visitor.visit(this);
            for (CellRegionImpl cellRegion : this.regions) {
                cellRegion.accept(visitor);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CrossjoinCellRegion
    implements CellRegionImpl {
        final List<Dimension> dimensions;
        private List<CellRegionImpl> components = new ArrayList<CellRegionImpl>();

        CrossjoinCellRegion(List<CellRegionImpl> regions) {
            ArrayList<Dimension> dimensionality = new ArrayList<Dimension>();
            CrossjoinCellRegion.compute(regions, this.components, dimensionality);
            this.dimensions = Collections.unmodifiableList(dimensionality);
        }

        private static void compute(List<CellRegionImpl> regions, List<CellRegionImpl> components, List<Dimension> dimensionality) {
            HashSet<Dimension> dimensionSet = new HashSet<Dimension>();
            for (CellRegionImpl region : regions) {
                CrossjoinCellRegion.addComponents(region, components);
                List<Dimension> regionDimensionality = region.getDimensionality();
                dimensionality.addAll(regionDimensionality);
                dimensionSet.addAll(regionDimensionality);
                assert (dimensionSet.size() == dimensionality.size()) : "dimensions in common";
            }
        }

        @Override
        public void accept(CellRegionVisitor visitor) {
            visitor.visit(this);
            Iterator<CellRegionImpl> i$ = this.components.iterator();
            while (i$.hasNext()) {
                CellRegionImpl component;
                CellRegionImpl cellRegion = component = i$.next();
                cellRegion.accept(visitor);
            }
        }

        private static void addComponents(CellRegionImpl region, List<CellRegionImpl> list) {
            if (region instanceof CrossjoinCellRegion) {
                CrossjoinCellRegion crossjoinRegion = (CrossjoinCellRegion)region;
                for (CellRegionImpl component : crossjoinRegion.components) {
                    list.add(component);
                }
            } else {
                list.add(region);
            }
        }

        @Override
        public List<Dimension> getDimensionality() {
            return this.dimensions;
        }

        public String toString() {
            return Util.commaList("Crossjoin", this.components);
        }

        public List<CacheControl.CellRegion> getComponents() {
            return Util.cast(this.components);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MemberRangeCellRegion
    implements CellRegionImpl {
        private final RolapMember lowerMember;
        private final boolean lowerInclusive;
        private final RolapMember upperMember;
        private final boolean upperInclusive;
        private final boolean descendants;
        private final RolapLevel level;

        MemberRangeCellRegion(RolapMember lowerMember, boolean lowerInclusive, RolapMember upperMember, boolean upperInclusive, boolean descendants) {
            assert (lowerMember != null || upperMember != null);
            assert (lowerMember == null || upperMember == null || lowerMember.getLevel() == upperMember.getLevel());
            assert (lowerMember != null || !lowerInclusive);
            assert (upperMember != null || !upperInclusive);
            this.lowerMember = lowerMember;
            this.lowerInclusive = lowerInclusive;
            this.upperMember = upperMember;
            this.upperInclusive = upperInclusive;
            this.descendants = descendants;
            this.level = lowerMember == null ? upperMember.getLevel() : lowerMember.getLevel();
        }

        @Override
        public List<Dimension> getDimensionality() {
            return Collections.singletonList(this.level.getDimension());
        }

        public RolapLevel getLevel() {
            return this.level;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Range(");
            if (this.lowerMember == null) {
                sb.append("null");
            } else {
                sb.append(this.lowerMember);
                if (this.lowerInclusive) {
                    sb.append(" inclusive");
                } else {
                    sb.append(" exclusive");
                }
            }
            sb.append(" to ");
            if (this.upperMember == null) {
                sb.append("null");
            } else {
                sb.append(this.upperMember);
                if (this.upperInclusive) {
                    sb.append(" inclusive");
                } else {
                    sb.append(" exclusive");
                }
            }
            sb.append(")");
            return sb.toString();
        }

        @Override
        public void accept(CellRegionVisitor visitor) {
            visitor.visit(this);
        }

        public boolean getLowerInclusive() {
            return this.lowerInclusive;
        }

        public RolapMember getLowerBound() {
            return this.lowerMember;
        }

        public boolean getUpperInclusive() {
            return this.upperInclusive;
        }

        public RolapMember getUpperBound() {
            return this.upperMember;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MemberCellRegion
    implements CellRegionImpl {
        private final List<Member> memberList;
        private final Dimension dimension;

        MemberCellRegion(List<Member> memberList, boolean descendants) {
            assert (memberList.size() > 0);
            this.memberList = memberList;
            this.dimension = memberList.get(0).getDimension();
            Util.discard((boolean)descendants);
        }

        @Override
        public List<Dimension> getDimensionality() {
            return Collections.singletonList(this.dimension);
        }

        public String toString() {
            return Util.commaList("Member", this.memberList);
        }

        @Override
        public void accept(CellRegionVisitor visitor) {
            visitor.visit(this);
        }

        public List<Member> getMemberList() {
            return this.memberList;
        }
    }
}

