/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap4j;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import mondrian.olap.Cube;
import mondrian.olap.Dimension;
import mondrian.olap.Hierarchy;
import mondrian.olap.Id;
import mondrian.olap.Member;
import mondrian.olap.NamedSet;
import mondrian.olap.SchemaReader;
import mondrian.olap4j.MondrianOlap4jConnection;
import mondrian.olap4j.MondrianOlap4jDimension;
import mondrian.olap4j.MondrianOlap4jHierarchy;
import mondrian.olap4j.MondrianOlap4jLevel;
import mondrian.olap4j.MondrianOlap4jMember;
import mondrian.olap4j.MondrianOlap4jSchema;
import org.olap4j.OlapException;
import org.olap4j.impl.Named;
import org.olap4j.impl.NamedListImpl;
import org.olap4j.impl.Olap4jUtil;
import org.olap4j.metadata.Measure;
import org.olap4j.metadata.Member;
import org.olap4j.metadata.NamedList;
import org.olap4j.metadata.Schema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MondrianOlap4jCube
implements org.olap4j.metadata.Cube,
Named {
    private final Cube cube;
    final MondrianOlap4jSchema olap4jSchema;

    MondrianOlap4jCube(Cube cube, MondrianOlap4jSchema olap4jSchema) {
        this.cube = cube;
        this.olap4jSchema = olap4jSchema;
    }

    public Schema getSchema() {
        return this.olap4jSchema;
    }

    public int hashCode() {
        return this.olap4jSchema.hashCode() ^ this.cube.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof MondrianOlap4jCube) {
            MondrianOlap4jCube that = (MondrianOlap4jCube)obj;
            return this.olap4jSchema == that.olap4jSchema && this.cube.equals(that.cube);
        }
        return false;
    }

    public NamedList<org.olap4j.metadata.Dimension> getDimensions() {
        NamedListImpl list = new NamedListImpl();
        for (Dimension dimension : this.cube.getDimensions()) {
            list.add((Object)new MondrianOlap4jDimension(this.olap4jSchema, dimension));
        }
        return Olap4jUtil.cast((NamedList)list);
    }

    public NamedList<org.olap4j.metadata.Hierarchy> getHierarchies() {
        NamedListImpl list = new NamedListImpl();
        for (Dimension dimension : this.cube.getDimensions()) {
            for (Hierarchy hierarchy : dimension.getHierarchies()) {
                list.add((Object)new MondrianOlap4jHierarchy(this.olap4jSchema, hierarchy));
            }
        }
        return Olap4jUtil.cast((NamedList)list);
    }

    public List<Measure> getMeasures() {
        MondrianOlap4jLevel measuresLevel = (MondrianOlap4jLevel)((org.olap4j.metadata.Dimension)this.getDimensions().get("Measures")).getDefaultHierarchy().getLevels().get(0);
        return Olap4jUtil.cast(measuresLevel.getMembers());
    }

    public NamedList<org.olap4j.metadata.NamedSet> getSets() {
        NamedListImpl list = new NamedListImpl();
        MondrianOlap4jConnection olap4jConnection = this.olap4jSchema.olap4jCatalog.olap4jDatabaseMetaData.olap4jConnection;
        for (NamedSet namedSet : this.cube.getNamedSets()) {
            list.add((Object)olap4jConnection.toOlap4j(this.cube, namedSet));
        }
        return Olap4jUtil.cast((NamedList)list);
    }

    public Collection<Locale> getSupportedLocales() {
        throw new UnsupportedOperationException();
    }

    public String getName() {
        return this.cube.getName();
    }

    public String getUniqueName() {
        return this.cube.getUniqueName();
    }

    public String getCaption(Locale locale) {
        return this.cube.getCaption();
    }

    public String getDescription(Locale locale) {
        return this.cube.getDescription();
    }

    public MondrianOlap4jMember lookupMember(String ... nameParts) {
        MondrianOlap4jConnection olap4jConnection = this.olap4jSchema.olap4jCatalog.olap4jDatabaseMetaData.olap4jConnection;
        SchemaReader schemaReader = this.cube.getSchemaReader(olap4jConnection.connection.getRole());
        ArrayList<Id.Segment> segmentList = new ArrayList<Id.Segment>();
        for (String namePart : nameParts) {
            segmentList.add(new Id.Segment(namePart, Id.Quoting.QUOTED));
        }
        Member member = schemaReader.getMemberByUniqueName(segmentList, false);
        if (member == null) {
            return null;
        }
        return olap4jConnection.toOlap4j(member);
    }

    public List<org.olap4j.metadata.Member> lookupMembers(Set<Member.TreeOp> treeOps, String ... nameParts) throws OlapException {
        MondrianOlap4jMember parentMember;
        MondrianOlap4jMember member = this.lookupMember(nameParts);
        if (member == null) {
            return Collections.emptyList();
        }
        ArrayList<MondrianOlap4jMember> list = new ArrayList<MondrianOlap4jMember>();
        if (treeOps.contains(Member.TreeOp.ANCESTORS)) {
            for (MondrianOlap4jMember m = member.getParentMember(); m != null; m = m.getParentMember()) {
                list.add(0, m);
            }
        } else if (treeOps.contains(Member.TreeOp.PARENT) && (parentMember = member.getParentMember()) != null) {
            list.add(parentMember);
        }
        ArrayList remainingSiblingsList = null;
        if (treeOps.contains(Member.TreeOp.SIBLINGS)) {
            MondrianOlap4jMember parentMember2 = member.getParentMember();
            NamedList siblingMembers = parentMember2 != null ? parentMember2.getChildMembers() : Olap4jUtil.cast((NamedList)member.getHierarchy().getRootMembers());
            ArrayList<MondrianOlap4jMember> targetList = list;
            for (MondrianOlap4jMember siblingMember : siblingMembers) {
                if (siblingMember.equals(member)) {
                    remainingSiblingsList = new ArrayList();
                    targetList = remainingSiblingsList;
                    continue;
                }
                targetList.add(siblingMember);
            }
        }
        if (treeOps.contains(Member.TreeOp.SELF)) {
            list.add(member);
        }
        if (treeOps.contains(Member.TreeOp.DESCENDANTS)) {
            for (MondrianOlap4jMember childMember : member.getChildMembers()) {
                list.add(childMember);
                MondrianOlap4jCube.addDescendants(list, childMember);
            }
        } else if (treeOps.contains(Member.TreeOp.CHILDREN)) {
            for (MondrianOlap4jMember childMember : member.getChildMembers()) {
                list.add(childMember);
            }
        }
        if (remainingSiblingsList != null) {
            list.addAll(remainingSiblingsList);
        }
        return Olap4jUtil.cast(list);
    }

    private static void addDescendants(List<MondrianOlap4jMember> list, MondrianOlap4jMember member) {
        for (MondrianOlap4jMember childMember : member.getChildMembers()) {
            list.add(childMember);
            MondrianOlap4jCube.addDescendants(list, childMember);
        }
    }
}

