/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import java.util.ArrayList;
import java.util.List;
import mondrian.olap.Dimension;
import mondrian.olap.Exp;
import mondrian.olap.Hierarchy;
import mondrian.olap.Id;
import mondrian.olap.Level;
import mondrian.olap.MatchType;
import mondrian.olap.Member;
import mondrian.olap.MemberFormatter;
import mondrian.olap.OlapElement;
import mondrian.olap.OlapElementBase;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.resource.MondrianResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MemberBase
extends OlapElementBase
implements Member {
    protected Member parentMember;
    protected final Level level;
    protected String uniqueName;
    protected final int flags;
    private static final int FLAG_TYPE_MASK = 7;
    private static final int FLAG_HIDDEN = 8;
    private static final int FLAG_ALL = 16;
    private static final int FLAG_NULL = 32;
    private static final int FLAG_CALCULATED = 64;
    private static final int FLAG_MEASURE = 128;
    protected String parentUniqueName;
    private static final Member.MemberType[] MEMBER_TYPE_VALUES = Member.MemberType.values();

    protected MemberBase(Member parentMember, Level level, Member.MemberType memberType) {
        this.parentMember = parentMember;
        this.level = level;
        this.parentUniqueName = parentMember == null ? null : parentMember.getUniqueName();
        this.flags = memberType.ordinal() | (memberType == Member.MemberType.ALL ? 16 : 0) | (memberType == Member.MemberType.NULL ? 32 : 0) | (this.computeCalculated(memberType) ? 64 : 0) | (level.getHierarchy().getDimension().isMeasures() ? 128 : 0);
    }

    protected MemberBase() {
        this.level = null;
        this.flags = 0;
        this.parentUniqueName = null;
    }

    @Override
    public String getQualifiedName() {
        return MondrianResource.instance().MdxMemberName.str(this.getUniqueName());
    }

    @Override
    public abstract String getName();

    @Override
    public String getUniqueName() {
        return this.uniqueName;
    }

    @Override
    public String getCaption() {
        MemberFormatter mf = this.getLevel().getMemberFormatter();
        if (mf != null) {
            return mf.formatMember(this);
        }
        String caption = super.getCaption();
        return caption != null ? caption : this.getName();
    }

    @Override
    public String getParentUniqueName() {
        return this.parentUniqueName;
    }

    @Override
    public Dimension getDimension() {
        return this.getLevel().getDimension();
    }

    @Override
    public Hierarchy getHierarchy() {
        return this.getLevel().getHierarchy();
    }

    @Override
    public Level getLevel() {
        return this.level;
    }

    @Override
    public Member.MemberType getMemberType() {
        return MEMBER_TYPE_VALUES[this.flags & 7];
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public boolean isMeasure() {
        return (this.flags & 0x80) != 0;
    }

    @Override
    public boolean isAll() {
        return (this.flags & 0x10) != 0;
    }

    @Override
    public boolean isNull() {
        return (this.flags & 0x20) != 0;
    }

    @Override
    public boolean isCalculated() {
        return (this.flags & 0x40) != 0;
    }

    @Override
    public boolean isEvaluated() {
        return this.isCalculated();
    }

    @Override
    public OlapElement lookupChild(SchemaReader schemaReader, Id.Segment childName, MatchType matchType) {
        return schemaReader.lookupMemberChildByName(this, childName, matchType);
    }

    @Override
    public Member getParentMember() {
        if (this.parentUniqueName == null) {
            return null;
        }
        if (this.parentMember != null) {
            return this.parentMember;
        }
        boolean failIfNotFound = true;
        Hierarchy hierarchy = this.getHierarchy();
        SchemaReader schemaReader = hierarchy.getDimension().getSchema().getSchemaReader();
        List<Id.Segment> parentUniqueNameParts = Util.parseIdentifier(this.parentUniqueName);
        this.parentMember = schemaReader.getMemberByUniqueName(parentUniqueNameParts, failIfNotFound);
        return this.parentMember;
    }

    @Override
    public boolean isChildOrEqualTo(Member member) {
        return member != null && this.isChildOrEqualTo(member.getUniqueName());
    }

    public boolean isChildOrEqualTo(String uniqueName) {
        if (uniqueName == null) {
            return false;
        }
        String thisUniqueName = this.getUniqueName();
        if (thisUniqueName.equals(uniqueName)) {
            return true;
        }
        String parentUniqueName = this.getParentUniqueName();
        return parentUniqueName == null ? false : ((MemberBase)this.getParentMember()).isChildOrEqualTo(uniqueName);
    }

    protected boolean computeCalculated(Member.MemberType memberType) {
        return this.isCalculatedInQuery() || memberType == Member.MemberType.FORMULA;
    }

    @Override
    public int getSolveOrder() {
        return -1;
    }

    @Override
    public Exp getExpression() {
        return null;
    }

    @Override
    public List<Member> getAncestorMembers() {
        ArrayList<Member> list = new ArrayList<Member>();
        for (Member parentMember = this.getParentMember(); parentMember != null; parentMember = parentMember.getParentMember()) {
            list.add(parentMember);
        }
        return list;
    }

    @Override
    public int getOrdinal() {
        return -1;
    }

    @Override
    public Comparable getOrderKey() {
        return null;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public Member getDataMember() {
        return null;
    }

    @Override
    public String getPropertyFormattedValue(String propertyName) {
        return this.getPropertyValue(propertyName).toString();
    }
}

