/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.diff;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.api.diff.Diff;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.Project;
import org.netbeans.modules.diff.DiffModuleConfig;
import org.netbeans.modules.diff.EditorBufferSelectorPanel;
import org.netbeans.modules.diff.builtin.DefaultDiff;
import org.netbeans.modules.diff.builtin.SingleDiffPanel;
import org.netbeans.modules.diff.options.AccessibleJFileChooser;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.nodes.Node;
import org.openide.util.Cancellable;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;
import org.openide.windows.WindowManager;

public class DiffAction
extends NodeAction {
    public DiffAction() {
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public Action createContextAwareInstance(Lookup lookup) {
        return new DiffActionImpl(lookup);
    }

    public String getName() {
        return NbBundle.getMessage(DiffAction.class, (String)"CTL_DiffActionName");
    }

    static FileObject getFileFromNode(Node node) {
        FileObject fileObject = (FileObject)node.getLookup().lookup(FileObject.class);
        if (fileObject == null) {
            Project project = (Project)node.getLookup().lookup(Project.class);
            if (project != null) {
                return project.getProjectDirectory();
            }
            DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
            if (dataObject instanceof DataShadow) {
                dataObject = ((DataShadow)dataObject).getOriginal();
            }
            if (dataObject != null) {
                fileObject = dataObject.getPrimaryFile();
            }
        }
        return fileObject;
    }

    public boolean enable(Node[] nodeArray) {
        FileObject fileObject;
        if (nodeArray.length == 2) {
            FileObject fileObject2 = DiffAction.getFileFromNode(nodeArray[0]);
            FileObject fileObject3 = DiffAction.getFileFromNode(nodeArray[1]);
            if (fileObject2 != null && fileObject3 != null && fileObject2.isData() && fileObject3.isData()) {
                Diff diff = Diff.getDefault();
                return diff != null;
            }
        } else if (nodeArray.length == 1 && (fileObject = DiffAction.getFileFromNode(nodeArray[0])) != null && fileObject.isData()) {
            Diff diff = Diff.getDefault();
            return diff != null;
        }
        return false;
    }

    protected boolean asynchronous() {
        return false;
    }

    public void performAction(Node[] nodeArray) {
        FileObject fileObject;
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        for (int i = 0; i < nodeArray.length; ++i) {
            fileObject = DiffAction.getFileFromNode(nodeArray[i]);
            if (fileObject == null) continue;
            arrayList.add(fileObject);
        }
        if (arrayList.size() < 1) {
            return;
        }
        final FileObject fileObject2 = (FileObject)arrayList.get(0);
        if (arrayList.size() > 1) {
            fileObject = (FileObject)arrayList.get(1);
        } else {
            fileObject = this.promptForFileobject(fileObject2);
            if (fileObject == null) {
                return;
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DiffAction.performAction(fileObject2, fileObject, null);
            }
        });
    }

    private FileObject promptForFileobject(FileObject fileObject) {
        String string = DiffModuleConfig.getDefault().getPreferences().get("diffToLatestFolder", fileObject.getParent().getPath());
        File file = FileUtil.normalizeFile((File)new File(string));
        AccessibleJFileChooser accessibleJFileChooser = new AccessibleJFileChooser(NbBundle.getMessage(DiffAction.class, (String)"ACSD_BrowseDiffToFile"), file);
        accessibleJFileChooser.setDialogTitle(NbBundle.getMessage(DiffAction.class, (String)"DiffTo_BrowseFile_Title", (Object)fileObject.getName()));
        accessibleJFileChooser.setMultiSelectionEnabled(false);
        accessibleJFileChooser.setFileSelectionMode(0);
        EditorBufferSelectorPanel editorBufferSelectorPanel = new EditorBufferSelectorPanel(accessibleJFileChooser, fileObject);
        accessibleJFileChooser.setAccessory(editorBufferSelectorPanel);
        int n = accessibleJFileChooser.showDialog(WindowManager.getDefault().getMainWindow(), NbBundle.getMessage(DiffAction.class, (String)"DiffTo_BrowseFile_OK"));
        if (n != 0) {
            return null;
        }
        File file2 = accessibleJFileChooser.getSelectedFile();
        if (file2 != null) {
            File file3 = file2.getAbsoluteFile();
            DiffModuleConfig.getDefault().getPreferences().put("diffToLatestFolder", file3.getParent());
            return FileUtil.toFileObject((File)file2);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void performAction(FileObject fileObject, FileObject fileObject2, FileObject fileObject3) {
        Object object;
        Diff diff = Diff.getDefault();
        if (diff == null) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(DiffAction.class, (String)"MSG_NoDiffVisualizer")));
            return;
        }
        SingleDiffPanel singleDiffPanel = null;
        try {
            object = Thread.currentThread();
            Cancellable cancellable = new Cancellable((Thread)object){
                final /* synthetic */ Thread val$victim;
                {
                    this.val$victim = thread;
                }

                public boolean cancel() {
                    this.val$victim.interrupt();
                    return true;
                }
            };
            String string = NbBundle.getMessage(DiffAction.class, (String)"BK0001");
            ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)string, (Cancellable)cancellable);
            try {
                progressHandle.start();
                singleDiffPanel = new SingleDiffPanel(fileObject, fileObject2, fileObject3);
            }
            finally {
                progressHandle.finish();
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
            return;
        }
        if (singleDiffPanel != null) {
            object = singleDiffPanel;
            SwingUtilities.invokeLater(new Runnable((SingleDiffPanel)object){
                final /* synthetic */ SingleDiffPanel val$fsdp;
                {
                    this.val$fsdp = singleDiffPanel;
                }

                public void run() {
                    DefaultDiff.DiffTopComponent diffTopComponent = new DefaultDiff.DiffTopComponent(this.val$fsdp);
                    diffTopComponent.open();
                    diffTopComponent.requestActive();
                }
            });
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(DiffAction.class);
    }

    private class DiffActionImpl
    extends AbstractAction {
        private final Node[] nodes;

        private DiffActionImpl(Lookup lookup) {
            Collection collection = lookup.lookup(new Lookup.Template(Node.class)).allInstances();
            this.nodes = collection.toArray(new Node[collection.size()]);
            if (this.nodes.length == 1) {
                this.putValue("Name", NbBundle.getMessage(DiffAction.class, (String)"CTL_DiffToActionName"));
            } else {
                this.putValue("Name", DiffAction.this.getName());
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DiffAction.this.performAction(this.nodes);
        }

        public boolean isEnabled() {
            return DiffAction.this.enable(this.nodes);
        }
    }
}

