# OSDN\ProjectFrsApi

All URIs are relative to *https://osdn.jp/api/v0*

Method | HTTP request | Description
------------- | ------------- | -------------
[**createPackage**](ProjectFrsApi.md#createPackage) | **POST** /project/{id_or_name}/frs | 
[**createRelease**](ProjectFrsApi.md#createRelease) | **POST** /project/{id_or_name}/frs/{package_id} | 
[**createReleaseFile**](ProjectFrsApi.md#createReleaseFile) | **POST** /project/{id_or_name}/frs/{package_id}/{release_id} | 
[**deletePackage**](ProjectFrsApi.md#deletePackage) | **DELETE** /project/{id_or_name}/frs/{package_id} | 
[**deleteRelease**](ProjectFrsApi.md#deleteRelease) | **DELETE** /project/{id_or_name}/frs/{package_id}/{release_id} | 
[**deleteReleaseFile**](ProjectFrsApi.md#deleteReleaseFile) | **DELETE** /project/{id_or_name}/frs/{package_id}/{release_id}/{file_id} | 
[**draftRelease**](ProjectFrsApi.md#draftRelease) | **GET** /project/{id_or_name}/frs/{package_id}/draft | 
[**getPackage**](ProjectFrsApi.md#getPackage) | **GET** /project/{id_or_name}/frs/{package_id} | 
[**getRelease**](ProjectFrsApi.md#getRelease) | **GET** /project/{id_or_name}/frs/{package_id}/{release_id} | 
[**getReleaseFile**](ProjectFrsApi.md#getReleaseFile) | **GET** /project/{id_or_name}/frs/{package_id}/{release_id}/{file_id} | 
[**listPackages**](ProjectFrsApi.md#listPackages) | **GET** /project/{id_or_name}/frs | 
[**updatePackage**](ProjectFrsApi.md#updatePackage) | **PATCH** /project/{id_or_name}/frs/{package_id} | 
[**updateRelease**](ProjectFrsApi.md#updateRelease) | **PATCH** /project/{id_or_name}/frs/{package_id}/{release_id} | 
[**updateReleaseFile**](ProjectFrsApi.md#updateReleaseFile) | **PATCH** /project/{id_or_name}/frs/{package_id}/{release_id}/{file_id} | 


# **createPackage**
> \OSDN\Model\Package createPackage($id_or_name, $name, $visibility)



Create a package.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectFrsApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$name = "name_example"; // string | package name
$visibility = "visibility_example"; // string | visibility status (public, hidden or private)

try {
    $result = $api_instance->createPackage($id_or_name, $name, $visibility);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectFrsApi->createPackage: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **name** | **string**| package name |
 **visibility** | **string**| visibility status (public, hidden or private) | [optional]

### Return type

[**\OSDN\Model\Package**](../Model/Package.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **createRelease**
> \OSDN\Model\Release createRelease($id_or_name, $package_id, $name, $visibility, $time, $release_note, $change_log)



Create new release in specified package.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectFrsApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$package_id = 56; // int | 
$name = "name_example"; // string | Release name
$visibility = "visibility_example"; // string | visibility status (public, hidden or private)
$time = "time_example"; // string | Release datetime. If you set future time, the release hide until specified time.
$release_note = "release_note_example"; // string | Release note body text.
$change_log = "change_log_example"; // string | Changelog body text.

try {
    $result = $api_instance->createRelease($id_or_name, $package_id, $name, $visibility, $time, $release_note, $change_log);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectFrsApi->createRelease: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **package_id** | **int**|  |
 **name** | **string**| Release name |
 **visibility** | **string**| visibility status (public, hidden or private) | [optional]
 **time** | **string**| Release datetime. If you set future time, the release hide until specified time. | [optional]
 **release_note** | **string**| Release note body text. | [optional]
 **change_log** | **string**| Changelog body text. | [optional]

### Return type

[**\OSDN\Model\Release**](../Model/Release.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **createReleaseFile**
> \OSDN\Model\RelFile createReleaseFile($id_or_name, $package_id, $release_id, $file, $visibility)



Create new file in target release.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectFrsApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$package_id = 56; // int | 
$release_id = 56; // int | 
$file = "/path/to/file.txt"; // \SplFileObject | Upload file in \"multipart/form-data\".
$visibility = "visibility_example"; // string | visibility status (public, hidden or private)

try {
    $result = $api_instance->createReleaseFile($id_or_name, $package_id, $release_id, $file, $visibility);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectFrsApi->createReleaseFile: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **package_id** | **int**|  |
 **release_id** | **int**|  |
 **file** | **\SplFileObject**| Upload file in \&quot;multipart/form-data\&quot;. |
 **visibility** | **string**| visibility status (public, hidden or private) | [optional]

### Return type

[**\OSDN\Model\RelFile**](../Model/RelFile.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: multipart/form-data
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deletePackage**
> deletePackage($id_or_name, $package_id)



Delete taret package.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectFrsApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$package_id = 56; // int | 

try {
    $api_instance->deletePackage($id_or_name, $package_id);
} catch (Exception $e) {
    echo 'Exception when calling ProjectFrsApi->deletePackage: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **package_id** | **int**|  |

### Return type

void (empty response body)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteRelease**
> deleteRelease($id_or_name, $package_id, $release_id)



Delete target release.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectFrsApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$package_id = 56; // int | 
$release_id = 56; // int | 

try {
    $api_instance->deleteRelease($id_or_name, $package_id, $release_id);
} catch (Exception $e) {
    echo 'Exception when calling ProjectFrsApi->deleteRelease: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **package_id** | **int**|  |
 **release_id** | **int**|  |

### Return type

void (empty response body)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteReleaseFile**
> deleteReleaseFile($id_or_name, $package_id, $release_id, $file_id)



Delete target file.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectFrsApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$package_id = 56; // int | 
$release_id = 56; // int | 
$file_id = 56; // int | 

try {
    $api_instance->deleteReleaseFile($id_or_name, $package_id, $release_id, $file_id);
} catch (Exception $e) {
    echo 'Exception when calling ProjectFrsApi->deleteReleaseFile: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **package_id** | **int**|  |
 **release_id** | **int**|  |
 **file_id** | **int**|  |

### Return type

void (empty response body)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **draftRelease**
> \OSDN\Model\Release draftRelease($id_or_name, $package_id)



Get release draft in specified package. If draft is not exist, it will be created automatically.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectFrsApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$package_id = 56; // int | 

try {
    $result = $api_instance->draftRelease($id_or_name, $package_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectFrsApi->draftRelease: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **package_id** | **int**|  |

### Return type

[**\OSDN\Model\Release**](../Model/Release.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getPackage**
> \OSDN\Model\Package getPackage($id_or_name, $package_id)



Get specified package info and release list of the package.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectFrsApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$package_id = 56; // int | 

try {
    $result = $api_instance->getPackage($id_or_name, $package_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectFrsApi->getPackage: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **package_id** | **int**|  |

### Return type

[**\OSDN\Model\Package**](../Model/Package.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getRelease**
> \OSDN\Model\Release getRelease($id_or_name, $package_id, $release_id)



Get specified release info and file list of the release.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectFrsApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$package_id = 56; // int | 
$release_id = 56; // int | 

try {
    $result = $api_instance->getRelease($id_or_name, $package_id, $release_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectFrsApi->getRelease: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **package_id** | **int**|  |
 **release_id** | **int**|  |

### Return type

[**\OSDN\Model\Release**](../Model/Release.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getReleaseFile**
> \OSDN\Model\RelFile getReleaseFile($id_or_name, $package_id, $release_id, $file_id)



Get single file object.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectFrsApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$package_id = 56; // int | 
$release_id = 56; // int | 
$file_id = 56; // int | 

try {
    $result = $api_instance->getReleaseFile($id_or_name, $package_id, $release_id, $file_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectFrsApi->getReleaseFile: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **package_id** | **int**|  |
 **release_id** | **int**|  |
 **file_id** | **int**|  |

### Return type

[**\OSDN\Model\RelFile**](../Model/RelFile.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **listPackages**
> \OSDN\Model\Package[] listPackages($id_or_name)



Get package list of specified project.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectFrsApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name

try {
    $result = $api_instance->listPackages($id_or_name);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectFrsApi->listPackages: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |

### Return type

[**\OSDN\Model\Package[]**](../Model/Package.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **updatePackage**
> \OSDN\Model\Package updatePackage($id_or_name, $package_id, $name, $visibility)



Update tagret package.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectFrsApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$package_id = 56; // int | 
$name = "name_example"; // string | package name
$visibility = "visibility_example"; // string | visibility status (public, hidden or private)

try {
    $result = $api_instance->updatePackage($id_or_name, $package_id, $name, $visibility);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectFrsApi->updatePackage: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **package_id** | **int**|  |
 **name** | **string**| package name | [optional]
 **visibility** | **string**| visibility status (public, hidden or private) | [optional]

### Return type

[**\OSDN\Model\Package**](../Model/Package.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **updateRelease**
> \OSDN\Model\Release updateRelease($id_or_name, $package_id, $release_id, $visibility, $name, $time, $move_to_package_id)



Update target release. (Note: If you update draft release, the release will be public automatically.)

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectFrsApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$package_id = 56; // int | 
$release_id = 56; // int | 
$visibility = "visibility_example"; // string | visibility status (public, hidden or private)
$name = "name_example"; // string | Release name
$time = "time_example"; // string | Release datetime. If you set future time, the release hide until specified time.
$move_to_package_id = 56; // int | If this parameter is specified, the release move to another package.

try {
    $result = $api_instance->updateRelease($id_or_name, $package_id, $release_id, $visibility, $name, $time, $move_to_package_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectFrsApi->updateRelease: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **package_id** | **int**|  |
 **release_id** | **int**|  |
 **visibility** | **string**| visibility status (public, hidden or private) | [optional]
 **name** | **string**| Release name | [optional]
 **time** | **string**| Release datetime. If you set future time, the release hide until specified time. | [optional]
 **move_to_package_id** | **int**| If this parameter is specified, the release move to another package. | [optional]

### Return type

[**\OSDN\Model\Release**](../Model/Release.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **updateReleaseFile**
> \OSDN\Model\RelFile updateReleaseFile($id_or_name, $package_id, $release_id, $file_id, $visibility)



Change visibility of target file.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectFrsApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$package_id = 56; // int | 
$release_id = 56; // int | 
$file_id = 56; // int | 
$visibility = "visibility_example"; // string | visibility status (public, hidden or private)

try {
    $result = $api_instance->updateReleaseFile($id_or_name, $package_id, $release_id, $file_id, $visibility);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectFrsApi->updateReleaseFile: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **package_id** | **int**|  |
 **release_id** | **int**|  |
 **file_id** | **int**|  |
 **visibility** | **string**| visibility status (public, hidden or private) | [optional]

### Return type

[**\OSDN\Model\RelFile**](../Model/RelFile.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

