/*
̃t@C̒ǵANTT I[v\[XCZX@o[W 1.0iu{
_vƂj̓Kp󂯂܂B
{_炵ȂÃt@CgpĂ͂Ȃ܂B
{_̃Rs[́Âtqkł܂B
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

{_ɊÂЕz\tgEFÁÂ܂܁Âَ͖
ނ̕ۏ؂ȂŁAЕz܂B{_ɊÂyѐ𗥂
̕ɂẮA{_QƂĂB

uIWiR[hv́A NTT Cyber Space Laboratories Code łB 
uIWiR[hv́uJҁv́A{dMdbЂłB  
{dMdbЂɂn삳ꂽ́ACopyright (C) 2004 
{dMdb łB
SĂ̌ۂ܂B 
uRgr[^vF_____________________________________ 


The contents of this file are subject to the NTT Opensource License
Version 1.0 (the License); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

Software distributed under the License is distributed on an AS IS
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NTT Cyber Space Laboratories Code .

The Initial Developer of the Original Code is NIPPON TELEGRAPH AND 
TELEPHONE CORPORATION.
Portions created by the NIPPON TELEGRAPH AND TELEPHONE CORPORATION 
are Copyright (C) 2004 NIPPON TELEGRAPH AND TELEPHONE CORPORATION. 
All Rights Reserved.

Contributor(s) ______________________________________.
*/
package jp.co.ntt.lms.installer.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.apache.xpath.XPathAPI;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/**
 * wlk̈ʓIȃ[eBeBENXB
 * @author T.Nishiki
 */
public class XmlUtil {
	/**
	 * Oo̓IuWFNgB
	 */
	private static Logger _logger;

	/**
	 * X^eBbNECjVCUB<br>
	 * Oo̓IuWFNg擾܂B
	 */
	static {
		_logger = LoggerUtil.getLogger(XmlUtil.class);
	}


	/**
	 * w肳ꂽwlk\[XDOM Documentɕϊ܂B<br>
	 * @param resourceURI wlk\[X݂URIB
	 * @return xmlStream琶DOM DocumentB
	 * @throws ParserConfigurationException DocumentBuilder𐶐łȂꍇB
	 * @throws SAXException Xg[̃f[^XMLƂĕsȏꍇB
	 * @throws IOException Xg[̓͂ŃG[ꍇB
	 */
	public static Document convertXmlResourceToDocument(String resourceURI)
			throws ParserConfigurationException
			, SAXException, IOException  {
		// \bhJnO
		LoggerUtil.methodHead(
			_logger, "convertXmlResourceToDocument(" +  resourceURI + ")");

		Document document = null;
		InputStream stream = null;
		// tryubN̏BȂtrueB
		boolean successFlag = false;
		try {
			ClassLoader loader = ClassLoader.getSystemClassLoader();
			stream = loader.getResourceAsStream(resourceURI);
			document = XmlUtil.convertXmlStreamToDocument(stream);
			// tryubNI[܂œB琬
			successFlag = true;
		}
		finally {
			FileUtil.close(stream, successFlag);
		}
		// \bhIO
		LoggerUtil.methodTail(
			_logger, "convertXmlResourceToDocument(" +  resourceURI + ")",
			document);
		return document;
	}

	/**
	 * w肳ꂽwlkXg[DOM Documentɕϊ܂B<br>
	 * @param xmlStream wlkXg[B
	 * @return xmlStream琶DOM DocumentB
	 * @throws ParserConfigurationException DocumentBuilder𐶐łȂꍇB
	 * @throws SAXException Xg[̃f[^XMLƂĕsȏꍇB
	 * @throws IOException Xg[̓͂ŃG[ꍇB
	 */
	public static Document convertXmlStreamToDocument(InputStream xmlStream)
			throws ParserConfigurationException
			, SAXException, IOException  {
		// \bhJnO
		LoggerUtil.methodHead(
			_logger, "convertXmlStreamToDocument(InputStream)");

		Document document = null;
		DocumentBuilderFactory factory
			= DocumentBuilderFactory.newInstance();
		DocumentBuilder builder = factory.newDocumentBuilder();
		document = builder.parse(xmlStream);
		// \bhIO
		LoggerUtil.methodTail(
			_logger, "convertXmlStreamToDocument(InputStream)");
		return document;
	}

	/**
	 * w肳ꂽwlkt@CDOM Documentɕϊ܂B<br>
	 * @param file wlkt@CB
	 * @return file琶DOM DocumentB
	 * @throws ParserConfigurationException DocumentBuilder𐶐łȂꍇB
	 * @throws SAXException file̓eXMLƂĕsȏꍇB
	 * @throws IOException file̓͂ŃG[ꍇB
	 */
	public static Document convertXmlFileToDocument(File file)
			throws ParserConfigurationException
			, SAXException, IOException  {
		// \bhJnO
		LoggerUtil.methodHead(
			_logger, "convertXmlStreamToDocument(" + file + ")");

		Document document = null;
		try {
			DocumentBuilderFactory factory
				= DocumentBuilderFactory.newInstance();
			DocumentBuilder builder = factory.newDocumentBuilder();
			document = builder.parse(file);
		}
		catch (IOException e) {
			LoggerUtil.throwable(_logger, e);
			throw e;
		}
		// \bhIO
		LoggerUtil.methodTail(
			_logger, "convertXmlStreamToDocument(" + file + ")");
		return document;
	}

	/**
	 * DOM DocumentXMLt@CɕϊEۑ܂B<br>
	 *
	 * @param doc ۑDOM DocumentB
	 * @param file ۑƂȂt@C\FileIuWFNgB
	 * @param outputProperties ϊvpeBB
	 * @throws TransformerConfigurationException
	 *          ϊ郂W[̐łȂꍇB
	 * @throws TransformerException ϊsȂꍇB
	 */
	public static void convertDocumentToFile(
			Document doc, File file, Properties outputProperties)
			throws TransformerException, TransformerConfigurationException {

		DOMSource source = new DOMSource(doc);
		StreamResult result = new StreamResult(file);
		TransformerFactory factory = TransformerFactory.newInstance();
		Transformer transformer = factory.newTransformer();
		if (outputProperties != null) {
			transformer.setOutputProperties(outputProperties);
		}
		transformer.transform(source, result);
	}
	/**
	 * w肵m[h̒l擾܂B<br>
	 * XPath𗘗pāAw肵_m[hw肵pXŃm[hA
	 * Čm[h̒l߂܂B<br>
	 * @param originNode _ƂȂm[hB
	 * @param locationPath 邽߃P[VEpXB
	 * @return Ώۂ̃m[hꍇÃm[h̒l߂܂B
	 *          ȂꍇAnull߂܂B
	 * @throws DOMException XMLf[^쒆ɗOꍇB
	 * @throws TransformerException w肵pXP[VEpX
	 *          ĂȂǌɗOꍇB
	 */
	public static String getNodeValue(Node originNode, String locationPath)
			throws DOMException, TransformerException {
		// \bhJnO
		LoggerUtil.methodHead(_logger,
			"getNodeValue(" + originNode + "," + locationPath + ")");
		// ̃\bh̖߂l
		String nodeValue = null;
		try {
			Node targetNode = XPathAPI.selectSingleNode(
									originNode, locationPath);
			if ( targetNode != null ) {
				nodeValue = targetNode.getNodeValue();
			}
		}
		catch (DOMException e) {
			LoggerUtil.throwable(_logger, e);
			throw e;
		}
		catch (TransformerException e) {
			LoggerUtil.throwable(_logger, e);
			throw e;
		}
		// \bhIO
		LoggerUtil.methodTail( _logger,
			"getNodeValue(" + originNode + "," + locationPath + ")",
			nodeValue);
		return nodeValue;
	}

	/**
	 * w肵m[h̒l擾܂B<br>
	 * XPath𗘗pāAw肵_m[hw肵pXŃm[hA
	 * Čm[h̒l߂܂B<br>
	 * @param originNode _ƂȂm[hB
	 * @param locationPath 邽߃P[VEpXB
	 * @return Ώۂ̃m[hꍇAm[h̒lz߂܂B
	 *          ȂꍇAvfzƂĖ߂܂B
	 * @throws DOMException XMLf[^쒆ɗOꍇB
	 * @throws TransformerException w肵pXP[VEpX
	 *          ĂȂǌɗOꍇB
	 */
	public static String[] getNodeValues(Node originNode, String locationPath)
			throws DOMException, TransformerException {
		// \bhJnO
		LoggerUtil.methodHead(_logger,
			"getNodeValues(" + originNode + "," + locationPath + ")");
		// ̃\bh̖߂l
		String[] nodeValues = null;
		try {
			List nodeValuesList = new ArrayList();
			NodeList targetNodes = XPathAPI.selectNodeList(
									originNode, locationPath);
			for (int i = 0; i < targetNodes.getLength(); i++) {
				Node node = targetNodes.item(i);
				nodeValuesList.add(node.getNodeValue());
			}
			nodeValues = new String[nodeValuesList.size()];
			nodeValuesList.toArray(nodeValues);
		}
		catch (DOMException e) {
			throw e;
		}
		catch (TransformerException e) {
			throw e;
		}
		// \bhIO
		LoggerUtil.methodTail( _logger,
				"getNodeValues(" + originNode + "," + locationPath + ")",
				nodeValues);
		return nodeValues;
	}

	/**
	 * w肳ꂽENTITY̒l擾܂B
	 * @param document DOM DocumentB
	 * @param entityName 擾ENTITÝ̖B
	 * @return YENTITY݂΂̒lB݂ȂnullB
	 */
	public static String getEntityValue(
			Document document, String entityName) {
		// \bhJnO
		LoggerUtil.methodHead(_logger,
			"getEntityValue(" + document + "," + entityName + ")");
		// ENTITYlĩ\bh̖߂lj
		String entityValue = null;
		// ENTITYDTD擾
		DocumentType documentType = document.getDoctype();
		if (documentType != null) {
			// ׂENTITY擾APPmFB
			NamedNodeMap nodeMap = documentType.getEntities();
			int length = nodeMap.getLength();
			for (int i = 0; i < length; i++) {
				Node entity = nodeMap.item(i);
				// ̂ႤꍇA
				if (entityName.equals(entity.getNodeName()) == false) {
					continue;
				}
				// ΏۂENTITYꍇATEXTm[h擾
				NodeList nodeList = entity.getChildNodes();
				for (int j = 0; j < nodeList.getLength(); j++) {
					Node entityChild = nodeList.item(j);
					// TEXTm[hΏI
					if (entityChild.getNodeType() == Node.TEXT_NODE) {
						entityValue = entityChild.getNodeValue();
						break;
					}
				}
				break;
			}
		}
		// \bhJnO
		LoggerUtil.methodTail(_logger,
			"getEntityValue(" + document + "," + entityName + ")",
			entityValue);
		return entityValue;
	}
}
