
/*
̃t@C̒ǵANTT I[v\[XCZX@o[W 1.0iu{
_vƂj̓Kp󂯂܂B
{_炵ȂÃt@CgpĂ͂Ȃ܂B
{_̃Rs[́Âtqkł܂B
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

{_ɊÂЕz\tgEFÁÂ܂܁Âَ͖
ނ̕ۏ؂ȂŁAЕz܂B{_ɊÂyѐ𗥂
̕ɂẮA{_QƂĂB

uIWiR[hv́A NTT Cyber Space Laboratories Code łB 
uIWiR[hv́uJҁv́A{dMdbЂłB  
{dMdbЂɂn삳ꂽ́ACopyright (C) 2004 
{dMdb łB
SĂ̌ۂ܂B 
uRgr[^vF_____________________________________ 


The contents of this file are subject to the NTT Opensource License
Version 1.0 (the License); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

Software distributed under the License is distributed on an AS IS
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NTT Cyber Space Laboratories Code .

The Initial Developer of the Original Code is NIPPON TELEGRAPH AND 
TELEPHONE CORPORATION.
Portions created by the NIPPON TELEGRAPH AND TELEPHONE CORPORATION 
are Copyright (C) 2004 NIPPON TELEGRAPH AND TELEPHONE CORPORATION. 
All Rights Reserved.

Contributor(s) ______________________________________.
*/
package jp.co.ntt.lms.installer.core.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Logger;

import jp.co.ntt.lms.installer.core.InstallerException;
import jp.co.ntt.lms.installer.core.InstallerOverwritePropertiesValue;
import jp.co.ntt.lms.installer.core.InstallerValues;
import jp.co.ntt.lms.installer.util.LoggerUtil;
import jp.co.ntt.lms.installer.util.StringUtil;

/**
 * vpeBɊւ郆[eBeBENXB
 * @author T.Nishiki
 */
public class InstallerPropertiesUtil {
	/**
	 * Oo̓IuWFNgB
	 */
	private static Logger _logger;

	/**
	 * X^eBbNECjVCUB<br>
	 * Oo̓IuWFNg擾܂B
	 */
	static {
		_logger = LoggerUtil.getLogger(InstallerPropertiesUtil.class);
	}

	/**
	 * w肳ꂽL[ɑΉvpeB̏l擾܂B<br>
	 * _ƂȂvpeBƁAQƂvpeBƂׂāA
	 * ҂̎w̃vpeBɍقꍇ́AQƂvpeBl܂B
	 * قȂꍇ́Anull߂܂B
	 *
	 * @param targetProperties ق擾vpeBB
	 * @param originProperties ق̊_ƂȂvpeBB
	 * @param key قmFvpeBEL[B
	 * @return w肳ꂽL[ŃvpeBɍق΁A
	 *          targetPropertiesł̒l߂B
	 *          قȂnull߂B
	 */
	public static String determineInitialValue(
			Properties targetProperties,
			Properties originProperties, String key) {
		String difference = null;
		String targetProperty = targetProperties.getProperty(key);
		String originProperty = originProperties.getProperty(key);
		if (StringUtil.isEmpty(targetProperty)) {
			difference = null;
		}
		else if (StringUtil.isEmpty(originProperty)) {
			difference = targetProperty;
		}
		else if (targetProperty.equals(originProperty)) {
			difference = null;
		}
		else {
			difference = targetProperty;
		}
		return difference;
	}

	/**
	 * w肳ꂽ\[XvpeBƂă[h܂B<br>
	 * @param values CXg[ʃf[^IuWFNgB
	 * @param resourceKey 擾郊\[Ẍʒu擾邽߂̃L[B
	 * @return resourceKeywpX̃\[X
	 *          ꂽvpeB߂܂B
	 * @throws InstallerException \[X擾ɎsꍇB
	 */
	public static Properties load(InstallerValues values, String resourceKey)
			throws InstallerException {
		// \bhJn^O
		LoggerUtil.methodHead(_logger, "load(" + resourceKey + ")");

		// ̃\bh̖߂l
		Properties properties = null;
		// \[X̓̓Xg[
		InputStream stream = null;
		// tOiꍇtrueɕύXj
		boolean successFlag = false;
		try {
			stream = values.getResourceKeyStream(resourceKey);
			properties = new Properties();
			properties.load(stream);
			successFlag = true;
		}
		catch (InstallerException e) {
			throw e;
		}
		catch (Exception e) {
			LoggerUtil.throwable(_logger, e);
			throw new InstallerException(e);
		}
		finally {
			InstallerFileUtil.close(stream, successFlag);
		}
		// \bhI^O
		LoggerUtil.methodTail(_logger, "load(" + resourceKey + ")");
		return properties;
	}

	/**
	 * vpeBt@C㏑܂B<br>
	 * @param values CXg[ʃf[^IuWFNgB
	 * @param propertiesValue ㏑鍀ڂɂĎ擾łf[^B
	 * @throws InstallerException vpeBt@C̎擾EɎsꍇB
	 */
	public static void overwriteProperties(
			InstallerValues values,
			InstallerOverwritePropertiesValue propertiesValue)
			throws InstallerException {
		////////////////////////////////////////////////////////////////////////
		// \bhJn^O
		LoggerUtil.methodHead(_logger,
			"overwriteProperties(InstallerValues," + propertiesValue + ")");
		////////////////////////////////////////////////////////////////////////
		// vpeBt@C̏㏑
		// =====================================================================
		// vpeBt@C擾邽߂ɃL[
		String targetFileKey = propertiesValue.getTargetFileKey();
		// ㏑vpeB
		Properties overwrittenProperties
			= propertiesValue.getOverwrittenProperties(values);
		// vpeBt@C̃GR[h
		String targetFileEncode
			= values.getResourceKeyEncode(targetFileKey);
		//  vpeB̍XV
		overwritePropertiesFile(values,
			overwrittenProperties, targetFileKey, targetFileEncode, true);
		////////////////////////////////////////////////////////////////////////
		// vpeBt@Cij̏㏑
		// =====================================================================
		// vpeBt@C(Native)擾邽߂ɃL[
		String nativeFileKey = propertiesValue.getTargetNativeFileKey();
		if (StringUtil.isEmpty(nativeFileKey) == false) {
			// vpeBt@C̃GR[h
			String nativeFileEncode
				= values.getResourceKeyEncode(nativeFileKey);
			//  vpeB̍XV
			overwritePropertiesFile(values,
				overwrittenProperties, nativeFileKey, nativeFileEncode, false);
		}
		////////////////////////////////////////////////////////////////////////
		// \bhI^O
		LoggerUtil.methodTail(_logger,
			"overwriteProperties(InstallerValues," + propertiesValue + ")");
	}


	/**
	 * vpeBt@C㏑܂B<br>
	 * @param values CXg[ʃf[^IuWFNgB
	 * @param overwrittenProperties ㏑vpeBB
	 * @param targetFileKey XVvpeBt@C擾邽߂̃L[B
	 * @param fileEncode XVvpeBt@C̃GR[hB
	 * @param unicodeEscape vpeBUNICDEGXP[vꍇ́A
	 *         trueAGXP[vȂꍇfalsen܂B
	 * @throws InstallerException vpeBt@C̎擾EɎsꍇB
	 */
	private static void overwritePropertiesFile(
			InstallerValues values,
			Properties overwrittenProperties,
			String targetFileKey,
			String fileEncode,
			boolean unicodeEscape)
			throws InstallerException {
		// \bhJn^O
		LoggerUtil.methodHead(_logger,
			"overwritePropertiesFile(InstallerValues,Properties,"
				+ targetFileKey + "," + fileEncode + ")");
		// \bh{
		BufferedReader reader = null;
		BufferedWriter writer = null;
		boolean successFlag = false;
		try {
			// =================================================================
			// ͗pe|Et@C
			// o͗pe|Et@C̃pXݒB
			File tempDir = values.getInstallerTempDir();
			File tempInputFile = File.createTempFile(
				targetFileKey + "_IN_", ".properties", tempDir);
			File tempOutputFile = File.createTempFile(
				targetFileKey + "_OUT_", ".properties", tempDir);
			// =================================================================
			// Ώۃt@C݂΁A͗pe|Et@CɃRs[
			File targetFile = values.getFileOnSystem(targetFileKey);
			if (targetFile.exists()) {
				InstallerFileUtil.copyFile(targetFile, tempInputFile);
			}
			// =================================================================
			// Ώۃt@C݂Ȃꍇ́A\[Xi{j̓e
			// ͗pe|Et@CɃRs[
			else {
				InstallerFileUtil.loadFile(
					values, tempInputFile, targetFileKey);
			}
			// =================================================================
			// ͗pe|Et@CPsǂ݂ȂA
			// o͗pe|Et@Cɏo͂
			reader = new BufferedReader(
				new InputStreamReader(
					new FileInputStream(tempInputFile), fileEncode));
			writer = new BufferedWriter(
				new OutputStreamWriter(
					new FileOutputStream(tempOutputFile), fileEncode));
			// [NEvpeB
			Properties workProperties
				= (Properties)overwrittenProperties.clone();
			while (true) {
				String line = null;
				line = reader.readLine();
				if (line == null) {
					break;
				}
				String trimmedLine = line.trim();
				// Rgs̔f
				// RgsȂ΂̂܂܏o
				if (trimmedLine.startsWith("#")
						|| trimmedLine.startsWith("!")) {
					writer.write(line);
					writer.newLine();
					continue;
				}
				// vpeBlݒ肵Ăsf
				int boudaryPos = trimmedLine.indexOf('=');
				if (boudaryPos < 0) {
					boudaryPos = trimmedLine.indexOf(':');
				}
				// vpeBݒsłȂ΁Â܂܏o
				if (boudaryPos <= 0) {
					writer.write(line);
					writer.newLine();
					continue;
				}
				// ݒ肳ĂvpeBL[̃vpeBl擾
				String propertyName = trimmedLine.substring(0, boudaryPos);
				propertyName = propertyName.trim();
				// 擾vpeBXVΏۂł邩mF
				String newPropertyValue
					= workProperties.getProperty(propertyName);
				// XVΏۂłȂ΁Â܂܏o
				if (newPropertyValue == null) {
					writer.write(line);
					writer.newLine();
					continue;
				}
				// XVl݂΁AXV̒lɕύXďo
				if (unicodeEscape) {
					propertyName
						= escapeUnicodeString(propertyName);
					newPropertyValue
						= escapeUnicodeString(newPropertyValue);
				}
				writer.write(propertyName);
				writer.write("=");
				writer.write(newPropertyValue);
				writer.newLine();
				// XV₩폜
				workProperties.remove(propertyName);
			}
			// =================================================================
			// o͂ĂȂXVvpeBΏo
			for (Iterator it = workProperties.keySet().iterator();
					it.hasNext();) {
				String propertyName = (String)it.next();
				String propertyValue
					= workProperties.getProperty(propertyName);

				if (unicodeEscape) {
					propertyName
						= escapeUnicodeString(propertyName);
					propertyValue
						= escapeUnicodeString(propertyValue);
				}
				writer.write(propertyName);
				writer.write("=");
				writer.write(propertyValue);
				writer.newLine();
			}
			// ̃t@C̃Rs[̂ŃN[Y
			writer.close();
			// =================================================================
			// o͗pvpeBEt@C̓eΏۃt@CɃRs[
			InstallerFileUtil.copyFile(tempOutputFile, targetFile);
			// =================================================================
			// tryubN̏I[܂œB琬Ƃ݂ȂB
			successFlag = true;
		}
		catch (InstallerException e) {
			throw e;
		}
		catch (Exception e) {
			LoggerUtil.throwable(_logger, e);
			throw new InstallerException(e);
		}
		finally {
			InstallerFileUtil.close(reader, writer, successFlag);
		}
		// \bhI^O
		LoggerUtil.methodTail(_logger,
			"overwritePropertiesFile(InstallerValues,Properties,"
				+ targetFileKey + "," + fileEncode + ")");
	}

	/**
	 * nꂽvpeBt@Cɏo͂邽߂ɕɕϊ܂B
	 * @param value ϊΏۂ̕B
	 * @return ϊ̕B
	 */
	private static String escapeUnicodeString(String value) {
		String convertedValue = null;
		if (value == null) {
			convertedValue = "";
		}
		else {
			StringBuffer buffer = new StringBuffer();
			// ꕶAGXP[v̗vۂ𔻒fāAAB
			for (int i = 0; i < value.length(); i++) {
				char c = value.charAt(i);
				// obNXbV
				if (c == '\\') {
					buffer.append("\\\\");
				}
				// ^u
				else if (c == '\t') {
					buffer.append("\\t");
				}
				// s
				else if (c == '\n') {
					buffer.append("\\n");
				}
				// A
				else if (c == '\r') {
					buffer.append("\\r");
				}
				// ASCIIȊȌꍇ́A
				// \\uXXXX`UNICODEGXP[vĂA
				else if (c < '\u0020' || '\u007E' < c) {
					buffer.append("\\u");
					// 16i𐶐A40pfBO{ĘAB
					String escaped = Integer.toHexString(c);
					switch (escaped.length()) {
						case 0:
							buffer.append("0000");
							break;
						case 1:
							buffer.append("000");
							buffer.append(escaped);
							break;
						case 2:
							buffer.append("00");
							buffer.append(escaped);
							break;
						case 3:
							buffer.append("0");
							buffer.append(escaped);
							break;
						default:
							buffer.append(escaped);
							break;
					}
				}
				// ʏASCII͂̂܂ܘA
				else {
					buffer.append(c);
				}
			}
			convertedValue = buffer.toString();
		}
		return convertedValue;
	}
}
