/*
 * Decompiled with CFR 0.152.
 */
package jp.co.ntt.lms.installer.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import jp.co.ntt.lms.installer.util.FileUtil;
import jp.co.ntt.lms.installer.util.LoggerUtil;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XmlUtil {
    private static Logger _logger = LoggerUtil.getLogger(class$jp$co$ntt$lms$installer$util$XmlUtil == null ? (class$jp$co$ntt$lms$installer$util$XmlUtil = XmlUtil.class$("jp.co.ntt.lms.installer.util.XmlUtil")) : class$jp$co$ntt$lms$installer$util$XmlUtil);
    static /* synthetic */ Class class$jp$co$ntt$lms$installer$util$XmlUtil;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document convertXmlResourceToDocument(String string) throws ParserConfigurationException, SAXException, IOException {
        LoggerUtil.methodHead(_logger, "convertXmlResourceToDocument(" + string + ")");
        Document document = null;
        InputStream inputStream = null;
        boolean bl = false;
        try {
            ClassLoader classLoader = ClassLoader.getSystemClassLoader();
            inputStream = classLoader.getResourceAsStream(string);
            document = XmlUtil.convertXmlStreamToDocument(inputStream);
            bl = true;
        }
        catch (Throwable throwable) {
            FileUtil.close(inputStream, bl);
            throw throwable;
        }
        FileUtil.close(inputStream, bl);
        LoggerUtil.methodTail(_logger, "convertXmlResourceToDocument(" + string + ")", document);
        return document;
    }

    public static Document convertXmlStreamToDocument(InputStream inputStream) throws ParserConfigurationException, SAXException, IOException {
        LoggerUtil.methodHead(_logger, "convertXmlStreamToDocument(InputStream)");
        Document document = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        document = documentBuilder.parse(inputStream);
        LoggerUtil.methodTail(_logger, "convertXmlStreamToDocument(InputStream)");
        return document;
    }

    public static Document convertXmlFileToDocument(File file) throws ParserConfigurationException, SAXException, IOException {
        LoggerUtil.methodHead(_logger, "convertXmlStreamToDocument(" + file + ")");
        Document document = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.parse(file);
        }
        catch (IOException iOException) {
            LoggerUtil.throwable(_logger, iOException);
            throw iOException;
        }
        LoggerUtil.methodTail(_logger, "convertXmlStreamToDocument(" + file + ")");
        return document;
    }

    public static void convertDocumentToFile(Document document, File file, Properties properties) throws TransformerException, TransformerConfigurationException {
        DOMSource dOMSource = new DOMSource(document);
        StreamResult streamResult = new StreamResult(file);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        if (properties != null) {
            transformer.setOutputProperties(properties);
        }
        transformer.transform(dOMSource, streamResult);
    }

    public static String getNodeValue(Node node, String string) throws DOMException, TransformerException {
        LoggerUtil.methodHead(_logger, "getNodeValue(" + node + "," + string + ")");
        String string2 = null;
        try {
            Node node2 = XPathAPI.selectSingleNode((Node)node, (String)string);
            if (node2 != null) {
                string2 = node2.getNodeValue();
            }
        }
        catch (DOMException dOMException) {
            LoggerUtil.throwable(_logger, dOMException);
            throw dOMException;
        }
        catch (TransformerException transformerException) {
            LoggerUtil.throwable(_logger, transformerException);
            throw transformerException;
        }
        LoggerUtil.methodTail(_logger, "getNodeValue(" + node + "," + string + ")", string2);
        return string2;
    }

    public static String[] getNodeValues(Node node, String string) throws DOMException, TransformerException {
        LoggerUtil.methodHead(_logger, "getNodeValues(" + node + "," + string + ")");
        String[] stringArray = null;
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            NodeList nodeList = XPathAPI.selectNodeList((Node)node, (String)string);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                arrayList.add(node2.getNodeValue());
            }
            stringArray = new String[arrayList.size()];
            arrayList.toArray(stringArray);
        }
        catch (DOMException dOMException) {
            throw dOMException;
        }
        catch (TransformerException transformerException) {
            throw transformerException;
        }
        LoggerUtil.methodTail(_logger, "getNodeValues(" + node + "," + string + ")", stringArray);
        return stringArray;
    }

    public static String getEntityValue(Document document, String string) {
        LoggerUtil.methodHead(_logger, "getEntityValue(" + document + "," + string + ")");
        String string2 = null;
        DocumentType documentType = document.getDoctype();
        if (documentType != null) {
            NamedNodeMap namedNodeMap = documentType.getEntities();
            int n = namedNodeMap.getLength();
            block0: for (int i = 0; i < n; ++i) {
                Node node = namedNodeMap.item(i);
                if (!string.equals(node.getNodeName())) continue;
                NodeList nodeList = node.getChildNodes();
                for (int j = 0; j < nodeList.getLength(); ++j) {
                    Node node2 = nodeList.item(j);
                    if (node2.getNodeType() != 3) continue;
                    string2 = node2.getNodeValue();
                    break block0;
                }
                break;
            }
        }
        LoggerUtil.methodTail(_logger, "getEntityValue(" + document + "," + string + ")", string2);
        return string2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

