<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF6070"
	title	= "クロス集計"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>
<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
/>

<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
	SELECT BLOCK,YYYY||MM as YMD, sum(SALES) AS KEI
	FROM GF43
	group by rollup( YYYY||MM,BLOCK )
	having YYYY||MM is not null					<!-- 列合計が不要なので省く -->
	order by 2,1 NULLS FIRST					<!-- 行合計を先頭に持ってくる NULLS FIRST -->
</og:query>

<og:columnEditor column="YMD" renderer="YM" />

<og:view
	viewFormType = "HTML{@CROSS}Table"
	command    = "{@command}"
	checked    = "{@checked}"
	startNo    = "{@startNo}"
	pageSize   = "{@pageSize}"
	useParam   = "true"
  >
	<og:crossParam
		gokeiLabel		= " "
		useHeaderColumn  = "true"
		useHeaderResource= "true"
	/>
</og:view>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
