/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

public class ReaderInputStream
extends InputStream {
    private static final int BYTE_BUFFER_SIZE = 128;
    private final Reader reader;
    private final CharsetEncoder encoder;
    private final CharBuffer charBuffer;
    private final ByteBuffer byteBuffer = ByteBuffer.allocate(128);
    private CoderResult coderResult;
    private boolean endOfReaderInput;

    public ReaderInputStream(Reader reader, Charset charset, int charBufferSize) {
        this.reader = reader;
        this.encoder = charset.newEncoder();
        this.charBuffer = CharBuffer.allocate(charBufferSize);
        this.charBuffer.flip();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int totalRead = 0;
        while (len > 0) {
            if (this.byteBuffer.position() > 0) {
                this.byteBuffer.flip();
                int numBytesRead = Math.min(this.byteBuffer.remaining(), len);
                this.byteBuffer.get(b, off, numBytesRead);
                off += numBytesRead;
                len -= numBytesRead;
                totalRead += numBytesRead;
                this.byteBuffer.compact();
                continue;
            }
            if (!this.endOfReaderInput && (this.coderResult == null || this.coderResult.isUnderflow())) {
                this.charBuffer.compact();
                int position = this.charBuffer.position();
                int numCharsRead = this.reader.read(this.charBuffer.array(), position, this.charBuffer.remaining());
                if (numCharsRead == -1) {
                    this.endOfReaderInput = true;
                } else {
                    this.charBuffer.position(position + numCharsRead);
                }
                this.charBuffer.flip();
            }
            this.coderResult = this.encoder.encode(this.charBuffer, this.byteBuffer, this.endOfReaderInput);
            if (!this.endOfReaderInput || this.byteBuffer.position() != 0) continue;
        }
        return totalRead == 0 && this.endOfReaderInput ? -1 : totalRead;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read() throws IOException {
        byte[] b = new byte[1];
        return this.read(b) == -1 ? -1 : b[0] & 0xFF;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

