/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.gbp.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.openstack4j.model.gbp.PolicyTargetGroupCreate;
import org.openstack4j.model.gbp.builder.PolicyTargetGroupBuilder;
import org.openstack4j.openstack.common.ListResult;

@JsonRootName(value="policy_target_group")
public class GbpPolicyTargetGroupCreate
implements PolicyTargetGroupCreate {
    private static final long serialVersionUID = 1L;
    private String name;
    @JsonProperty(value="tenant_id")
    private String tenantId;
    private String id;
    private String description;
    @JsonProperty(value="consumed_policy_rule_sets")
    private Map<String, String> consumedPolicyRuleSets;
    @JsonProperty(value="provided_policy_rule_sets")
    private Map<String, String> providedPolicyRuleSets;
    @JsonProperty(value="l2_policy_id")
    private String l2PolicyId;
    @JsonProperty(value="network_service_policy_id")
    private String networkServicePolicyId;
    @JsonProperty(value="policy_targets")
    private List<String> policyTargets;
    @JsonProperty(value="service_management")
    private Boolean serviceManagement;
    private Boolean shared;
    @JsonProperty(value="subnets")
    private List<String> subnets;

    @Override
    public PolicyTargetGroupBuilder toBuilder() {
        return new PolicyTargetConcreteGroupBuilder(this);
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Map<String, String> getConsumedPolicyRuleSets() {
        return this.consumedPolicyRuleSets;
    }

    @Override
    public Map<String, String> getProvidedPolicyRuleSets() {
        return this.providedPolicyRuleSets;
    }

    @Override
    public String getL2PolicyId() {
        return this.l2PolicyId;
    }

    @Override
    public String getNetworkServicePolicyId() {
        return this.networkServicePolicyId;
    }

    @Override
    public List<String> getPolicyTargets() {
        return this.policyTargets;
    }

    @Override
    public boolean isServiceManagement() {
        return this.serviceManagement == null ? false : this.serviceManagement;
    }

    @Override
    public boolean isShared() {
        return this.shared == null ? false : this.shared;
    }

    @Override
    public List<String> getSubnets() {
        return this.subnets;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("id", (Object)this.id).add("name", (Object)this.name).add("desription", (Object)this.description).add("tenantId", (Object)this.tenantId).add("consumedPolicyRuleSets", this.consumedPolicyRuleSets).add("providedPolicyRuleSets", this.providedPolicyRuleSets).add("l2PolicyId", (Object)this.l2PolicyId).add("networkServicePolicyId", (Object)this.networkServicePolicyId).add("policyTargets", this.policyTargets).add("serviceManagement", (Object)this.serviceManagement).add("shared", (Object)this.shared).add("subnets", this.subnets).toString();
    }

    public static PolicyTargetGroupBuilder builder() {
        return new PolicyTargetConcreteGroupBuilder();
    }

    public static class PolicyTargetConcreteGroupBuilder
    implements PolicyTargetGroupBuilder {
        private GbpPolicyTargetGroupCreate policyTargetGroup;

        public PolicyTargetConcreteGroupBuilder(GbpPolicyTargetGroupCreate gbpPolicyTargetGroup) {
            this.policyTargetGroup = gbpPolicyTargetGroup;
        }

        public PolicyTargetConcreteGroupBuilder() {
            this(new GbpPolicyTargetGroupCreate());
        }

        @Override
        public PolicyTargetGroupCreate build() {
            return this.policyTargetGroup;
        }

        @Override
        public PolicyTargetGroupBuilder from(PolicyTargetGroupCreate in) {
            this.policyTargetGroup = (GbpPolicyTargetGroupCreate)in;
            return this;
        }

        @Override
        public PolicyTargetGroupBuilder name(String name) {
            this.policyTargetGroup.name = name;
            return this;
        }

        @Override
        public PolicyTargetGroupBuilder description(String description) {
            this.policyTargetGroup.description = description;
            return this;
        }

        @Override
        public PolicyTargetGroupBuilder isShared(boolean shared) {
            this.policyTargetGroup.shared = shared;
            return this;
        }

        @Override
        public PolicyTargetGroupBuilder consumedPolicyRuleSets(List<String> policyRuleSet) {
            this.policyTargetGroup.consumedPolicyRuleSets = Maps.newHashMap();
            for (String id : policyRuleSet) {
                this.policyTargetGroup.consumedPolicyRuleSets.put(id, "");
            }
            return this;
        }

        @Override
        public PolicyTargetGroupBuilder providedPolicyRuleSets(List<String> policyRuleSet) {
            this.policyTargetGroup.providedPolicyRuleSets = Maps.newHashMap();
            for (String id : policyRuleSet) {
                this.policyTargetGroup.providedPolicyRuleSets.put(id, "");
            }
            return this;
        }

        @Override
        public PolicyTargetGroupBuilder policyTargets(List<String> policyTargets) {
            this.policyTargetGroup.policyTargets = policyTargets;
            return this;
        }

        @Override
        public PolicyTargetGroupBuilder networkServicePolicyId(String id) {
            this.policyTargetGroup.networkServicePolicyId = id;
            return this;
        }

        @Override
        public PolicyTargetGroupBuilder l2Policy(String id) {
            this.policyTargetGroup.l2PolicyId = id;
            return this;
        }

        @Override
        public PolicyTargetGroupBuilder serviceManagement(boolean serviceManagement) {
            this.policyTargetGroup.serviceManagement = serviceManagement;
            return this;
        }
    }

    public static class PolicyTargetGroups
    extends ListResult<GbpPolicyTargetGroupCreate> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="policy_target_groups")
        private List<GbpPolicyTargetGroupCreate> policyTargetGroups;

        @Override
        public List<GbpPolicyTargetGroupCreate> value() {
            return this.policyTargetGroups;
        }
    }
}

