/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.api.request.processor;

import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import oracle.cloudstorage.api.IRequestBuilder;
import oracle.cloudstorage.api.ISession;
import oracle.cloudstorage.api.header.Header;
import oracle.cloudstorage.api.header.Map;
import oracle.cloudstorage.api.http.HttpProxyConfig;
import oracle.cloudstorage.api.http.URLStreamHandlerConfig;
import oracle.cloudstorage.api.request.Method;
import oracle.cloudstorage.api.request.Scope;
import oracle.cloudstorage.api.request.processor.IContent;
import oracle.cloudstorage.api.request.processor.IResponse;
import oracle.cloudstorage.api.request.processor.ISendable;
import oracle.cloudstorage.api.session.Session;

public class Sendable
implements ISendable {
    private static final AtomicLong nextId = new AtomicLong();
    private final long tx = nextId.incrementAndGet();
    private final Method method;
    private final String url;
    private final Scope scope;
    private final oracle.cloudstorage.api.queryparam.Map queryParams = new oracle.cloudstorage.api.queryparam.Map();
    private final Map headers = new Map();
    private final HttpProxyConfig httpProxyConfig;
    private final URLStreamHandlerConfig urlStreamHandlerConfig;
    private final long connectTimeout;
    private final long readTimeout;
    private final int chunk;
    private final IContent content;
    private Object requestLogEvent = null;
    private Object responseLogEvent = null;

    public Sendable(IRequestBuilder builder, Map builderHeaders, Method method, Scope scope, String url, IContent content, int chunk) {
        String storageToken;
        this.method = method;
        this.scope = scope;
        this.url = url;
        this.queryParams.putAll(builder.getQueryParams());
        for (String key : builderHeaders.keySet()) {
            String value = builderHeaders.get(key);
            if (scope == Scope.object && value == null) continue;
            this.headers.put(key, value);
        }
        if (this.headers.get(Header.accept) == null) {
            this.headers.put(Header.accept.provide("*/*"));
        }
        ISession session = builder.getSession();
        if (!(this.headers.containsKey(Header.storageToken) || this.headers.containsKey(Header.basicAuthHeader) || (storageToken = session.getStorageToken()) == null || storageToken.trim().isEmpty())) {
            this.headers.put(Header.storageToken.provide(storageToken));
        }
        this.httpProxyConfig = session.getHttpProxyConfig();
        this.urlStreamHandlerConfig = session.getURLStreamHandlerConfig();
        long timeout = builder.getConnectTimeout();
        this.connectTimeout = Session.isTimeoutSet(timeout) ? timeout : session.getConnectTimeout();
        timeout = builder.getReadTimeout();
        this.readTimeout = Session.isTimeoutSet(timeout) ? timeout : session.getReadTimeout();
        this.content = content;
        this.chunk = chunk == -1 ? session.getChunk() : chunk;
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    @Override
    public Scope getScope() {
        return this.scope;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public oracle.cloudstorage.api.queryparam.Map getQueryParams() {
        return this.queryParams;
    }

    @Override
    public Map getHeaders() {
        return this.headers;
    }

    @Override
    public HttpProxyConfig getHttpProxyConfig() {
        return this.httpProxyConfig;
    }

    @Override
    public URLStreamHandlerConfig getURLStreamHandlerConfig() {
        return this.urlStreamHandlerConfig;
    }

    @Override
    public int getConnectTimeout() {
        return (int)this.connectTimeout;
    }

    @Override
    public int getReadTimeout() {
        return (int)this.readTimeout;
    }

    @Override
    public int getChunk() {
        return this.chunk;
    }

    @Override
    public IContent getContent() {
        return this.content;
    }

    @Override
    public final synchronized Object getRequestLogEvent() {
        this.buildRequestLogEvent();
        return this.requestLogEvent;
    }

    @Override
    public final synchronized Object getResponseLogEvent(IResponse response) {
        this.buildResponseLogEvent(response);
        return this.responseLogEvent;
    }

    public String toString() {
        return this.buildRequestLogMessage();
    }

    private StringBuilder endpoint() {
        StringBuilder msg = new StringBuilder(Long.toHexString(this.tx)).append(": ").append((Object)this.getMethod()).append(' ').append(this.getUrl());
        this.getQueryParams().appendTo(msg, true);
        return msg;
    }

    private String buildRequestLogMessage() {
        StringBuilder msg = this.endpoint();
        for (Map.Entry header : this.headers.entrySet()) {
            msg.append("\n  ").append((String)header.getKey()).append(':').append(Map.mask((String)header.getKey(), header.getValue()));
        }
        return msg.toString();
    }

    private String buildResponseLogMessage(IResponse response) {
        StringBuilder msg = this.endpoint();
        msg.append("\n").append(response.getStatus());
        for (Map.Entry<String, List<Object>> header : response.getHeaders().entrySet()) {
            msg.append("\n  ").append(header.getKey()).append(':');
            int sep = 32;
            for (Object value : header.getValue()) {
                msg.append((char)sep).append(Map.mask(header.getKey(), value));
                sep = 44;
            }
        }
        String error = response.getErrorContent();
        if (error != null && !error.trim().isEmpty()) {
            msg.append("\n").append(error);
        }
        return msg.toString();
    }

    private void buildRequestLogEvent() {
        if (this.requestLogEvent != null) {
            return;
        }
        this.requestLogEvent = new Object(){
            private String msg = null;

            public synchronized String toString() {
                if (this.msg == null) {
                    this.msg = Sendable.this.buildRequestLogMessage();
                }
                return this.msg;
            }
        };
    }

    private void buildResponseLogEvent(final IResponse response) {
        if (this.responseLogEvent != null) {
            return;
        }
        this.responseLogEvent = new Object(){
            private String msg = null;

            public synchronized String toString() {
                if (this.msg == null) {
                    this.msg = Sendable.this.buildResponseLogMessage(response);
                }
                return this.msg;
            }
        };
    }
}

