/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.image.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Maps;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.openstack4j.model.common.builder.BasicResourceBuilder;
import org.openstack4j.model.image.ContainerFormat;
import org.openstack4j.model.image.DiskFormat;
import org.openstack4j.model.image.Image;
import org.openstack4j.model.image.StoreType;
import org.openstack4j.model.image.builder.ImageBuilder;
import org.openstack4j.openstack.common.ListResult;

@JsonRootName(value="image")
public class GlanceImage
implements Image {
    private static final long serialVersionUID = 1L;
    private String id;
    private String name;
    private String location;
    @JsonProperty(value="disk_format")
    private DiskFormat diskFormat;
    @JsonProperty(value="container_format")
    private ContainerFormat containerFormat;
    private Long size;
    private String checksum;
    private String owner;
    @JsonProperty(value="created_at")
    private Date createdAt;
    @JsonProperty(value="updated_at")
    private Date updatedAt;
    @JsonProperty(value="deleted_at")
    private Date deletedAt;
    private Image.Status status;
    @JsonProperty(value="is_public")
    private boolean isPublic;
    @JsonProperty(value="min_ram")
    private Long minRam;
    @JsonProperty(value="min_disk")
    private Long minDisk;
    @JsonProperty(value="deleted")
    private boolean isDeleted;
    @JsonProperty(value="protected")
    private boolean isProtected;
    @JsonProperty(value="copy_from")
    private String copyFrom;
    private Map<String, String> properties;
    private transient StoreType storeType;

    public static ImageBuilder builder() {
        return new ImageConcreteBuilder();
    }

    @Override
    public ImageBuilder toBuilder() {
        return new ImageConcreteBuilder(this);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public ContainerFormat getContainerFormat() {
        return this.containerFormat != null ? this.containerFormat : ContainerFormat.UNRECOGNIZED;
    }

    @Override
    public DiskFormat getDiskFormat() {
        return this.diskFormat != null ? this.diskFormat : DiskFormat.UNRECOGNIZED;
    }

    @Override
    public Long getSize() {
        return this.size;
    }

    @Override
    public String getChecksum() {
        return this.checksum;
    }

    @Override
    public long getMinDisk() {
        return this.minDisk == null ? 0L : this.minDisk;
    }

    @Override
    public long getMinRam() {
        return this.minRam == null ? 0L : this.minRam;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    @Nullable
    public String getOwner() {
        return this.owner;
    }

    @Override
    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    @Override
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @Override
    @Nullable
    public Date getDeletedAt() {
        return this.deletedAt;
    }

    @Override
    public Image.Status getStatus() {
        return this.status;
    }

    @Override
    public boolean isPublic() {
        return this.isPublic;
    }

    @Override
    public boolean isDeleted() {
        return this.isDeleted;
    }

    @Override
    public boolean isProtected() {
        return this.isProtected;
    }

    @Override
    public StoreType getStoreType() {
        return this.storeType;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public String getCopyFrom() {
        return this.copyFrom;
    }

    public GlanceImage isProtected(Boolean isProtected) {
        if (isProtected != null) {
            this.isProtected = isProtected;
        }
        return this;
    }

    public GlanceImage isDeleted(Boolean isDeleted) {
        if (isDeleted != null) {
            this.isDeleted = isDeleted;
        }
        return this;
    }

    public GlanceImage status(Image.Status status) {
        this.status = status;
        return this;
    }

    public GlanceImage createdAt(Date createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    public GlanceImage updatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    public GlanceImage deletedAt(Date deletedAt) {
        this.deletedAt = deletedAt;
        return this;
    }

    public GlanceImage size(Long size) {
        this.size = size;
        return this;
    }

    public GlanceImage location(String location) {
        this.location = location;
        return this;
    }

    public GlanceImage properties(Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    @Override
    @JsonIgnore
    public boolean isSnapshot() {
        return this.properties != null && this.properties.containsKey("image_location") && "snapshot".equals(this.properties.get("image_location"));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("id", (Object)this.id).add("name", (Object)this.name).add("status", (Object)this.status).add("location", (Object)this.location).add("diskFormat", (Object)this.diskFormat).add("containerFormat", (Object)this.containerFormat).add("size", (Object)this.size).add("owner", (Object)this.owner).add("minRam", (Object)this.minRam).add("minDisk", (Object)this.minDisk).add("created", (Object)this.createdAt).add("updated", (Object)this.updatedAt).add("deleted", (Object)this.deletedAt).add("isPublic", this.isPublic).add("isProtected", this.isProtected).add("isDeleted", this.isDeleted).add("propterties", this.properties).addValue((Object)"\n").toString();
    }

    public static class ImageConcreteBuilder
    extends BasicResourceBuilder<Image, ImageConcreteBuilder>
    implements ImageBuilder {
        private GlanceImage m;

        ImageConcreteBuilder() {
            this(new GlanceImage());
        }

        ImageConcreteBuilder(GlanceImage m) {
            this.m = m;
        }

        @Override
        public ImageBuilder diskFormat(DiskFormat diskFormat) {
            this.m.diskFormat = diskFormat;
            return this;
        }

        @Override
        public ImageBuilder containerFormat(ContainerFormat containerFormat) {
            this.m.containerFormat = containerFormat;
            return this;
        }

        @Override
        public ImageBuilder size(Long size) {
            this.m.size = size;
            return this;
        }

        @Override
        public ImageBuilder checksum(String checksum) {
            this.m.checksum = checksum;
            return this;
        }

        @Override
        public ImageBuilder minDisk(Long minDisk) {
            this.m.minDisk = minDisk;
            return this;
        }

        @Override
        public ImageBuilder minRam(Long minRam) {
            this.m.minRam = minRam;
            return this;
        }

        @Override
        public ImageBuilder owner(String owner) {
            this.m.owner = owner;
            return this;
        }

        @Override
        public ImageBuilder isPublic(Boolean isPublic) {
            if (isPublic != null) {
                this.m.isPublic = isPublic;
            }
            return this;
        }

        @Override
        public ImageBuilder properties(Map<String, String> properties) {
            this.m.properties = properties;
            return this;
        }

        @Override
        protected Image reference() {
            return this.m;
        }

        @Override
        public Image build() {
            return this.m;
        }

        @Override
        public ImageBuilder from(Image in) {
            this.m = (GlanceImage)in;
            return this;
        }

        @Override
        public ImageBuilder property(String key, String value) {
            if (key != null && value != null) {
                if (this.m.properties == null) {
                    this.m.properties = Maps.newHashMap();
                }
                this.m.properties.put(key, value);
            }
            return this;
        }

        @Override
        public ImageBuilder storeType(StoreType storeType) {
            this.m.storeType = storeType;
            return this;
        }

        @Override
        public ImageBuilder copyFrom(String copyFrom) {
            this.m.copyFrom = copyFrom;
            return this;
        }
    }

    public static class Images
    extends ListResult<GlanceImage> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="images")
        private List<GlanceImage> images;

        @Override
        protected List<GlanceImage> value() {
            return this.images;
        }
    }
}

