/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.api.dlo;

import java.io.Closeable;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import oracle.cloudstorage.util.Throwables;

public class InputStreamSegmenter
implements Closeable,
Iterable<InputStream>,
Iterator<InputStream> {
    private final InputStream in;
    private final long segmentSize;
    private final InputStream wrapper;
    private long read = 0L;
    private boolean done = false;
    private final byte[] peeked = new byte[16];
    private int peekOff = -1;
    private int peekLen = -1;
    private IOException peekException = null;
    private int segment = 0;
    private int total = 0;

    public InputStreamSegmenter(InputStream in, long segmentSize) {
        this.in = in;
        this.wrapper = this.wrap(in);
        if (segmentSize <= 0L) {
            throw new IllegalArgumentException("The segment size for putting dynamic large objects must be positive, found " + segmentSize + ".");
        }
        this.segmentSize = segmentSize;
    }

    private int read(byte[] bytes, int off, int len) throws IOException {
        this.throwPeekException();
        if (this.read == this.segmentSize) {
            return -1;
        }
        if (this.peekLen > 0) {
            int segmentRead = 0;
            for (int i = 0; i < len && this.peekOff < this.peekLen && this.read < this.segmentSize; ++i) {
                if (this.peekOff >= 16) {
                    throw new IllegalStateException(this.getClass() + " peeked more than 15: " + this.peekOff);
                }
                bytes[off + i] = this.peeked[this.peekOff];
                ++this.peekOff;
                ++segmentRead;
                ++this.read;
            }
            if (this.peekOff >= this.peekLen) {
                this.peekOff = 0;
                this.peekLen = -1;
            }
            return segmentRead;
        }
        int segmentLen = (int)Math.min(this.segmentSize - this.read, (long)len);
        int segmentRead = this.in.read(bytes, off, segmentLen);
        if (segmentRead == -1) {
            this.done = true;
        } else {
            this.read += (long)segmentRead;
            this.total += segmentRead;
        }
        return segmentRead;
    }

    private void peek() {
        if (this.peekLen > 0 || this.done) {
            return;
        }
        try {
            if (this.peekLen <= 0 || this.peekLen > this.peeked.length) {
                this.peekLen = this.peeked.length;
            }
            this.peekOff = 0;
            this.peekLen = this.in.read(this.peeked, 0, this.peeked.length);
            this.done = this.peekLen == -1;
        }
        catch (IOException e) {
            if (this.peekException == null) {
                this.peekException = e;
            }
            Throwables.addSuppressed(this.peekException, e);
        }
    }

    private void throwPeekException() throws IOException {
        if (this.peekException != null) {
            throw this.peekException;
        }
    }

    private boolean isDone() {
        this.peek();
        return this.done;
    }

    @Override
    public void close() throws IOException {
        if (this.isDone()) {
            this.in.close();
        }
    }

    @Override
    public boolean hasNext() {
        return !this.isDone();
    }

    @Override
    public InputStream next() {
        if (this.isDone()) {
            return null;
        }
        this.read = 0L;
        ++this.segment;
        return this.wrapper;
    }

    public int getTotal() {
        return this.total;
    }

    public int getSegments() {
        return this.segment;
    }

    public long getSegmentSize() {
        return this.segmentSize;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<InputStream> iterator() {
        return this;
    }

    private final InputStream wrap(InputStream in) {
        return new FilterInputStream(in){
            private final byte[] single;
            {
                this.single = new byte[1];
            }

            @Override
            public int read() throws IOException {
                int read = this.read(this.single);
                if (read == -1) {
                    return read;
                }
                return this.single[0];
            }

            @Override
            public int read(byte[] bytes) throws IOException {
                int read = this.read(bytes, 0, bytes.length);
                return read;
            }

            @Override
            public int read(byte[] bytes, int off, int len) throws IOException {
                int read = InputStreamSegmenter.this.read(bytes, off, len);
                return read;
            }

            @Override
            public void close() throws IOException {
            }
        };
    }
}

