/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.api;

import java.net.URLEncoder;
import java.util.LinkedList;
import java.util.List;
import oracle.cloudstorage.api.ISession;
import oracle.cloudstorage.api.delete.IBulkDeleteReply;
import oracle.cloudstorage.api.get.IGetAccountReply;
import oracle.cloudstorage.api.get.IGetContainerReply;
import oracle.cloudstorage.api.get.IGetRequestBuilder;
import oracle.cloudstorage.api.reply.IReplyPartError;

public class Cleanup {
    private final ISession session;
    private final String accountId;

    public Cleanup(ISession session) {
        this(session, null);
    }

    public Cleanup(ISession session, String accountId) {
        this.session = session;
        this.accountId = accountId;
    }

    public List<IReplyPartError> cleanup() throws Exception {
        LinkedList<IReplyPartError> errors = new LinkedList<IReplyPartError>();
        String storageUrl = this.session.getStorageUrl();
        if (storageUrl == null) {
            return errors;
        }
        IGetAccountReply getAccountReply = this.session.get().account(this.accountId).send();
        for (String containerId : getAccountReply.getContainerIds()) {
            errors.addAll(this.cleanup(containerId));
        }
        return errors;
    }

    public List<IReplyPartError> cleanup(String containerId) throws Exception {
        IGetContainerReply getContainerReply = ((IGetRequestBuilder.Container)this.session.get().account(this.accountId).container(containerId)).send();
        containerId = URLEncoder.encode(containerId, "UTF-8");
        LinkedList<String> items = new LinkedList<String>();
        for (String objectId : getContainerReply.getObjectIds()) {
            objectId = URLEncoder.encode(objectId, "UTF-8");
            String item = containerId + "/" + objectId;
            items.add(item);
        }
        items.add(containerId);
        IBulkDeleteReply bulkDeleteReply = this.session.delete().bulk(items).send();
        return bulkDeleteReply.getErrors();
    }
}

