/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.storage.internal;

import oracle.cloud.storage.CloudStorage;
import oracle.cloud.storage.CloudStorageConfig;
import oracle.cloud.storage.EncryptedCloudStorage;
import oracle.cloud.storage.internal.CloudStorageImpl;
import oracle.cloud.storage.internal.EncryptedCloudStorageImpl;
import oracle.cloud.storage.spi.CloudStorageServiceProvider;

public class CloudStorageServiceProviderImpl
implements CloudStorageServiceProvider {
    private static final String NAME = "cloud";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public CloudStorage createCloudStorage(CloudStorageConfig config) {
        return new CloudStorageImpl(config);
    }

    @Override
    public EncryptedCloudStorage createEncryptedCloudStorage(CloudStorageConfig config) {
        return new EncryptedCloudStorageImpl(config);
    }

    @Override
    public void validateConfig(CloudStorageConfig config) {
        if (config.getServiceName() == null || config.getServiceName().trim().equals("")) {
            throw new IllegalArgumentException("service name is not set");
        }
        if (config.getServiceUrl() == null) {
            throw new IllegalArgumentException("service url is not set");
        }
        if (config.getUsername() == null || config.getUsername().trim().equals("")) {
            throw new IllegalArgumentException("service user name is not set");
        }
        if (config.getPassword() == null || new String(config.getPassword()).trim().equals("")) {
            throw new IllegalArgumentException("service password or access token is not set.");
        }
    }
}

