/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.model.storage.object.options;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;

public final class ContainerListOptions {
    private Map<String, String> queryParams = Maps.newHashMap();

    private ContainerListOptions() {
    }

    public static ContainerListOptions create() {
        return new ContainerListOptions();
    }

    public ContainerListOptions startsWith(String prefix) {
        return this.add("prefix", (String)Preconditions.checkNotNull((Object)prefix));
    }

    public ContainerListOptions limit(int limit) {
        Preconditions.checkState((limit >= 0 ? 1 : 0) != 0, (Object)"limit must be >= 0");
        Preconditions.checkState((limit <= 10000 ? 1 : 0) != 0, (Object)"limit must be <= 10000");
        this.add("limit", Integer.toString(limit));
        return this;
    }

    public ContainerListOptions marker(String marker) {
        this.add("marker", (String)Preconditions.checkNotNull((Object)marker, (Object)"marker"));
        return this;
    }

    public ContainerListOptions endMarker(String endMarker) {
        this.add("end_marker", (String)Preconditions.checkNotNull((Object)endMarker, (Object)"endMarker"));
        return this;
    }

    public ContainerListOptions delimiter(char delimiter) {
        return this.add("delimiter", Character.toString(delimiter));
    }

    public ContainerListOptions path(String path) {
        return this.add("path", (String)Preconditions.checkNotNull((Object)path));
    }

    private ContainerListOptions add(String param, String value) {
        this.queryParams.put(param, value);
        return this;
    }

    public Map<String, String> getOptions() {
        return this.queryParams;
    }
}

