/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.api.auth;

import java.util.concurrent.TimeUnit;
import oracle.cloudstorage.api.IRequestBuilder;
import oracle.cloudstorage.api.ISession;
import oracle.cloudstorage.api.auth.IAuthKeepAliveStrategy;
import oracle.cloudstorage.api.auth.IAuthReply;
import oracle.cloudstorage.api.auth.IAuthRequestBuilder;
import oracle.cloudstorage.api.auth.IAuthStrategy;
import oracle.cloudstorage.api.auth.IUser;
import oracle.cloudstorage.api.auth.StorageUser;
import oracle.cloudstorage.api.header.Header;
import oracle.cloudstorage.api.request.Method;
import oracle.cloudstorage.api.request.builder.AbstractRequestBuilder;
import oracle.cloudstorage.api.retry.IRetryStrategy;
import oracle.cloudstorage.api.retry.RetryException;
import oracle.cloudstorage.text.Marker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthRequestBuilder
extends AbstractRequestBuilder<IAuthRequestBuilder, IAuthStrategy>
implements IAuthRequestBuilder {
    private static Logger logger = LoggerFactory.getLogger(AuthRequestBuilder.class);
    private String url;
    private IAuthKeepAliveStrategy authKeepAliveStrategy = null;
    private PartialStorageUser partialStorageUser = null;

    public AuthRequestBuilder(IRequestBuilder that) {
        super(that, Method.get);
    }

    @Override
    public String getUrl() {
        String rootUrl = this.url;
        String url = rootUrl + (rootUrl.endsWith("/") ? "" : "/") + "auth/v1.0";
        return url;
    }

    @Override
    public IAuthRequestBuilder.RetryStrategy root(ISession session, IAuthStrategy processor) {
        this.createContext(session, processor);
        return new RetryStrategy();
    }

    @Override
    public IAuthKeepAliveStrategy getAuthKeepAlive() {
        return this.authKeepAliveStrategy;
    }

    public IAuthRequestBuilder.RetryStrategy root() {
        return new RetryStrategy();
    }

    private void setStorageUser(IUser.PreBuilt finalStorageUser) {
        assert (this.url == null);
        this.url = finalStorageUser.getUrlRoot();
        this.setHeader(Header.storagePassword.provide(finalStorageUser.getPassword()));
        this.setHeader(Header.storageUser.provide(finalStorageUser.getStorageUser()));
    }

    public String toString() {
        String url = this.getUrl();
        String user = this.getHeader(Header.storageUser);
        String password = this.getHeader(Header.storagePassword) == null ? null : "********";
        return this.getClass().getSimpleName() + " user: " + user + ", password: " + password + ", url: " + url;
    }

    private static class PartialStorageUser
    implements IUser.PreBuilt {
        private final IUser.PreBuilt delegate;
        private final String urlRoot;

        private PartialStorageUser(String urlRoot) {
            this.delegate = null;
            this.urlRoot = urlRoot;
        }

        private PartialStorageUser(IUser.PreBuilt delegate) {
            this.delegate = delegate;
            this.urlRoot = delegate.getUrlRoot();
        }

        private PartialStorageUser(IUser.PreBuilt previous, IUser.PreBuiltAware preBuilt) {
            this.delegate = new StorageUser((IUser.Base)previous, preBuilt);
            this.urlRoot = previous.getUrlRoot();
        }

        private PartialStorageUser(IUser.PreBuilt previous, IUser.TenantAware tenant) {
            this.delegate = new StorageUser((IUser.Base)previous, tenant);
            this.urlRoot = previous.getUrlRoot();
        }

        private PartialStorageUser(IUser.PreBuilt previous, IUser.AccountAware account) {
            this.delegate = new StorageUser((IUser.Base)previous, account);
            this.urlRoot = previous.getUrlRoot();
        }

        private PartialStorageUser(IUser.PreBuilt previous, IUser.IdentityDomainAware identityDomain) {
            this.delegate = new StorageUser((IUser.Base)previous, identityDomain);
            this.urlRoot = previous.getUrlRoot();
        }

        private PartialStorageUser(IUser.PreBuilt previous, IUser.PropertiesAware properties) {
            this.delegate = new StorageUser((IUser.Base)previous, properties);
            this.urlRoot = previous.getUrlRoot();
        }

        @Override
        public final String getUrlRoot() {
            return this.urlRoot;
        }

        @Override
        public String getStorageUser() {
            return this.delegate == null ? null : this.delegate.getStorageUser();
        }

        @Override
        public String getPassword() {
            return this.delegate == null ? null : this.delegate.getPassword();
        }

        @Override
        public String getTargetRegions() {
            return this.delegate == null ? null : this.delegate.getTargetRegions();
        }
    }

    private class Auth
    implements IAuthRequestBuilder.Auth {
        private Auth() {
        }

        @Override
        public ISession getSession() {
            return AuthRequestBuilder.this.getSession();
        }

        @Override
        public IAuthReply send() throws RetryException, InterruptedException {
            logger.debug(Marker.auth.marker, "Sending auth request {}", (Object)AuthRequestBuilder.this);
            IAuthReply reply = ((IAuthStrategy)AuthRequestBuilder.this.getProcessor()).authenticate(AuthRequestBuilder.this, null);
            logger.debug(Marker.auth.marker, "Received auth reply {}", (Object)reply);
            return reply;
        }
    }

    private class Password
    implements IAuthRequestBuilder.Password {
        private Password() {
        }

        @Override
        public IAuthRequestBuilder.Auth password(final String password) {
            AuthRequestBuilder.this.setStorageUser(new PartialStorageUser(AuthRequestBuilder.this.partialStorageUser){

                @Override
                public String getPassword() {
                    return password;
                }
            });
            return new Auth();
        }
    }

    private class User
    implements IAuthRequestBuilder.User {
        private User() {
        }

        @Override
        public Password user(final String storageUser) {
            AuthRequestBuilder.this.partialStorageUser = new PartialStorageUser((IUser.PreBuilt)AuthRequestBuilder.this.partialStorageUser, new IUser.PreBuiltAware(){

                @Override
                public String getStorageUser() {
                    return storageUser;
                }
            });
            return new Password();
        }

        @Override
        public Password tenant(final String tenant) {
            AuthRequestBuilder.this.partialStorageUser = new PartialStorageUser((IUser.PreBuilt)AuthRequestBuilder.this.partialStorageUser, new IUser.TenantAware(){

                @Override
                public String getTenant() {
                    return tenant;
                }
            });
            return new Password();
        }

        @Override
        public Password user(final String account, final String userName) {
            AuthRequestBuilder.this.partialStorageUser = new PartialStorageUser((IUser.PreBuilt)AuthRequestBuilder.this.partialStorageUser, new IUser.AccountAware(){

                @Override
                public String getName() {
                    return userName;
                }

                @Override
                public String getAccount() {
                    return account;
                }

                @Override
                public String getTargetRegions() {
                    return null;
                }
            });
            return new Password();
        }

        @Override
        public Password user(final String serviceName, final String identityDomain, final String userName) {
            AuthRequestBuilder.this.partialStorageUser = new PartialStorageUser((IUser.PreBuilt)AuthRequestBuilder.this.partialStorageUser, new IUser.IdentityDomainAware(){

                @Override
                public String getName() {
                    return userName;
                }

                @Override
                public String getServiceName() {
                    return serviceName;
                }

                @Override
                public String getIdentityDomain() {
                    return identityDomain;
                }
            });
            return new Password();
        }

        @Override
        public Password user(final String storageUser, final String tenant, final String account, final String serviceName, final String identityDomain, final String userName) {
            AuthRequestBuilder.this.partialStorageUser = new PartialStorageUser((IUser.PreBuilt)AuthRequestBuilder.this.partialStorageUser, new IUser.PropertiesAware(){

                @Override
                public String getStorageUser() {
                    return storageUser;
                }

                @Override
                public String getTenant() {
                    return tenant;
                }

                @Override
                public String getAccount() {
                    return account;
                }

                @Override
                public String getServiceName() {
                    return serviceName;
                }

                @Override
                public String getIdentityDomain() {
                    return identityDomain;
                }

                @Override
                public String getName() {
                    return userName;
                }

                @Override
                public String getTargetRegions() {
                    return null;
                }
            });
            return new Password();
        }
    }

    private class Host
    implements IAuthRequestBuilder.Host {
        private Host() {
        }

        @Override
        public IAuthRequestBuilder.Auth user(IUser.Properties user) {
            AuthRequestBuilder.this.setStorageUser(new StorageUser(user));
            return new Auth();
        }

        @Override
        public IAuthRequestBuilder.Auth user(IUser.FromTenant user) {
            AuthRequestBuilder.this.setStorageUser(new StorageUser(user));
            return new Auth();
        }

        @Override
        public IAuthRequestBuilder.Auth user(IUser.FromAccount user) {
            AuthRequestBuilder.this.setStorageUser(new StorageUser(user));
            return new Auth();
        }

        @Override
        public IAuthRequestBuilder.Auth user(IUser.FromIdentityDomain user) {
            AuthRequestBuilder.this.setStorageUser(new StorageUser(user));
            return new Auth();
        }

        @Override
        public IAuthRequestBuilder.Auth user(IUser.PreBuilt user) {
            AuthRequestBuilder.this.setStorageUser(new StorageUser(user));
            return new Auth();
        }

        @Override
        public User url(String url) {
            AuthRequestBuilder.this.partialStorageUser = new PartialStorageUser(url);
            return new User();
        }

        @Override
        public User region(String region) {
            return this.url(((IAuthStrategy)AuthRequestBuilder.this.getProcessor()).buildHost(region));
        }
    }

    private class KeepAlive
    extends Host
    implements IAuthRequestBuilder.KeepAlive {
        private KeepAlive() {
        }

        @Override
        public Host keepAlive(IAuthKeepAliveStrategy authKeepAliveStrategy) {
            AuthRequestBuilder.this.authKeepAliveStrategy = authKeepAliveStrategy;
            return new Host();
        }
    }

    private class ReadTimeout
    extends KeepAlive
    implements IAuthRequestBuilder.ReadTimeout {
        private ReadTimeout() {
        }

        @Override
        public IAuthRequestBuilder.KeepAlive read(long timeout, TimeUnit units) {
            return new KeepAlive();
        }
    }

    private class ConnectTimeout
    extends ReadTimeout
    implements IAuthRequestBuilder.ConnectTimeout {
        private ConnectTimeout() {
        }

        @Override
        public IAuthRequestBuilder.ReadTimeout connect(long timeout, TimeUnit units) {
            return new ReadTimeout();
        }
    }

    class RetryStrategy
    extends ConnectTimeout
    implements IAuthRequestBuilder.RetryStrategy {
        RetryStrategy() {
        }

        @Override
        public ConnectTimeout retry(IRetryStrategy retryStrategy) {
            AuthRequestBuilder.this.setRetryStrategy(retryStrategy);
            return new ConnectTimeout();
        }
    }
}

