/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.storage;

import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.cloud.storage.CloudStorage;
import oracle.cloud.storage.CloudStorageConfig;
import oracle.cloud.storage.EncryptedCloudStorage;
import oracle.cloud.storage.spi.CloudStorageServiceProvider;

public class CloudStorageFactory {
    private static final String DEFAULT_PROVIDER = "cloud";
    private static final String JAVASERVICE_PROVIDER = "javaservice";
    private static final Logger logger = Logger.getLogger("oracle.cloud.storage");

    public static CloudStorage getStorage(CloudStorageConfig config) {
        CloudStorageServiceProvider provider = CloudStorageFactory.getProvider(config);
        provider.validateConfig(config);
        return provider.createCloudStorage(config);
    }

    public static EncryptedCloudStorage getEncryptedStorage(CloudStorageConfig config) {
        CloudStorageServiceProvider provider = CloudStorageFactory.getProvider(config);
        provider.validateConfig(config);
        return provider.createEncryptedCloudStorage(config);
    }

    private static Iterator<CloudStorageServiceProvider> loadProviders() {
        ServiceLoader<CloudStorageServiceProvider> loader = ServiceLoader.load(CloudStorageServiceProvider.class);
        return loader.iterator();
    }

    private static CloudStorageServiceProvider getProvider(CloudStorageConfig config) {
        String name = null;
        if (config != null) {
            name = config.getProvider();
        }
        Iterator<CloudStorageServiceProvider> iterator = CloudStorageFactory.loadProviders();
        CloudStorageServiceProvider standard = null;
        while (iterator.hasNext()) {
            CloudStorageServiceProvider impl = null;
            try {
                impl = iterator.next();
            }
            catch (ServiceConfigurationError error) {
                logger.log(Level.WARNING, "Encountered bad CloudStorageProvider", error);
                continue;
            }
            if (name != null && impl.getName().equals(name)) {
                return impl;
            }
            if (name != null) continue;
            if (impl.getName().equals(DEFAULT_PROVIDER)) {
                standard = impl;
                continue;
            }
            if (!impl.getName().equals(JAVASERVICE_PROVIDER)) continue;
            return impl;
        }
        return standard;
    }
}

