/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.process;

import java.util.ArrayList;
import java.util.List;
import org.opengion.fukurou.process.FilterOperation;
import org.opengion.fukurou.process.LineModel;

public class LineModelFilter {
    private final List<FilterOperation> opes = new ArrayList<FilterOperation>();
    private final List<String> clms = new ArrayList<String>();
    private final List<String> vals = new ArrayList<String>();
    private int[] clmNo = null;
    private int size = 0;

    public void add(FilterOperation filterOperation, String string, String string2) {
        this.opes.add(filterOperation);
        this.clms.add(string);
        this.vals.add(string2);
    }

    public boolean filter(LineModel lineModel) {
        int n;
        if (this.clmNo == null) {
            this.size = this.clms.size();
            this.clmNo = new int[this.size];
            for (n = 0; n < this.size; ++n) {
                this.clmNo[n] = lineModel.getColumnNo(this.clms.get(n));
            }
        }
        n = 1;
        for (int i = 0; i < this.size; ++i) {
            boolean bl;
            Object object = lineModel.getValue(this.clmNo[i]);
            if (object == null) {
                n = 0;
                break;
            }
            FilterOperation filterOperation = this.opes.get(i);
            String string = String.valueOf(object);
            String string2 = this.vals.get(i);
            switch (filterOperation) {
                case PREFIX: {
                    bl = string.startsWith(string2);
                    break;
                }
                case SUFFIX: {
                    bl = string.endsWith(string2);
                    break;
                }
                case INSTR: {
                    bl = string.contains(string2);
                    break;
                }
                case EQUALS: {
                    bl = string.equalsIgnoreCase(string2);
                    break;
                }
                case MATCH: {
                    bl = string.matches(string2);
                    break;
                }
                case UNMATCH: {
                    bl = !string.matches(string2);
                    break;
                }
                default: {
                    bl = false;
                }
            }
            if (bl) continue;
            n = 0;
            break;
        }
        return n != 0;
    }

    public String toString() {
        int n = this.opes.size();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append((Object)this.opes.get(i)).append('(');
            stringBuilder.append(this.clms.get(i)).append(',');
            stringBuilder.append(this.vals.get(i)).append(") + ");
        }
        return stringBuilder.toString();
    }
}

