/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.plugin.token;

import org.opengion.fukurou.util.XHTMLTag;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.html.AbstractCreateToken;

/**
 * サンプルとして、エンジンのURLCheckの機能をプラグインとして作成するパターンを作成します。
 * ※URLCheck機能を使う場合は、このプラグインではなくlinkタグの機能を使ってください。
 *
 * @og.group 画面表示
 * @og.rev 5.8.2.1 (2014/12/13)
 *
 * @version  5.0
 * @author	 Takahashi Masakazu
 * @since    JDK5.0,
 */
public class CreateToken_URLCheck extends AbstractCreateToken {
	//* このプログラムのVERSION文字列を設定します。	{@value} */
	private static final String VERSION = "6.1.1.0 (2015/01/17)" ;

	/**
	 * デフォルトコンストラクター
	 *
	 */
	public CreateToken_URLCheck() {
		super();							// PMD:Document empty constructor 対策
	}

	/**
	 * トークン付のURLを返します。
	 * 通常はこのメソッドをオーバーライドします。
	 *
	 * @og.rev 6.1.1.0 (2015/01/17) 可変長配列にメソッドを統合。
	 *
	 * @param	inURL	トークンを付加するURL
	 * @param   time	有効期限(millis）
	 * @param	user	ユーザ
	 * @param	param	パラメータ配列
	 *
	 * @return	トークン付のURL
	 * @og.rtnNotNull
	 */
	@Override
//	public String generateURL( final String inURL, final long time, final String user, final String[] param ){
	public String generateURL( final String inURL, final long time, final String user, final String... param ){
		return XHTMLTag.addURLCheckKey( inURL, HybsSystem.URL_CHECK_KEY, null, time );
	}
}
