/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.hayabusa.html;

/**
 * CreateToken インターフェース の実装Abstractクラスです。
 * これを,共通のスーパークラスとして 各種トークン作成に使います。
 *
 * 各種トークンに対応したサブクラス上でgenerateURLをオーバーライドして下さい。
 *
 * @og.group 画面表示
 * @og.rev 5.8.2.1 (2014/12/13) 新規作成
 *
 * @version  4.0
 * @author	 Kazuhiko Hasegawa
 * @since    JDK5.0,
 */
public abstract class AbstractCreateToken implements CreateToken {
//	private static long	tokenTime= 1000*60*60;		// 初期は1時間の有効期限とする

//	/**
//	 * トークン付のURLを返します。
//	 *
//	 * @og.rev 6.1.1.0 (2015/01/17) 可変長配列にメソッドを統合。
//	 *
//	 * @param	inURL	トークンを付加するURL
//	 * @param   time	有効期限(millis）
//	 * @param	user	ユーザ
//	 *
//	 * @return	トークン付のURL
//	 */
//	public String generateURL( final String inURL, final long time, final String user ) {
//		return generateURL( inURL, time, user, null );
//	}

	/**
	 * トークン付のURLを返します。
	 * 通常はこのメソッドをオーバーライドします。
	 *
	 * @og.rev 6.1.1.0 (2015/01/17) 可変長配列にメソッドを統合。
	 *
	 * @param	inURL	トークンを付加するURL
	 * @param   time	有効期限(millis）
	 * @param	user	ユーザ
	 * @param	param	パラメータ配列(可変長引数)
	 *
	 * @return	トークン付のURL
	 */
//	public String generateURL( final String inURL, final long time, final String user, final String[] param ) {
	public String generateURL( final String inURL, final long time, final String user, final String... param ) {
		return inURL;
	}

//	/**
//	 * Aタグの文字列を解析して、hrefの最後にトークンを付加します。
//	 * URLチェックよりも後ろにトークンが付く形になるので併用は可能です。
//	 *
//	 * @og.rev 6.1.1.0 (2015/01/17) 可変長配列にメソッドを統合。
//	 *
//	 * @param   tag		Aタグ文字列
//	 * @param   time	有効期限(millis）
//	 * @param	user	ユーザ
//	 *
//	 * @return  トークンが付加されたAタグ文字列
//	 */
//	public String embedToken( final String tag, final long time, final String user ) {
//		return embedToken( tag, time, user, null );
//	}

	/**
	 * Aタグの文字列を解析して、hrefの最後にトークンを付加します。
	 * URLチェックよりも後ろにトークンが付く形になるので併用は可能です。
	 *
	 * @og.rev 6.1.1.0 (2015/01/17) 可変長配列にメソッドを統合。
	 *
	 * @param   tag		Aタグ文字列
	 * @param   time	有効期限(millis）
	 * @param	user	ユーザ
	 * @param	param	パラメータ配列(可変長引数)
	 *
	 * @return  トークンが付加されたAタグ文字列
	 */
//	public String embedToken( final String tag, final long time, final String user, final String[] param  ) {
	public String embedToken( final String tag, final long time, final String user, final String... param  ) {
		String rtn = tag;
		final int hrefStr = rtn.indexOf( "href=\"" );
		if( hrefStr >= 0 ) {
			final int hrefEnd = rtn.indexOf( "\"",hrefStr + 6 );
			if( hrefEnd >= 0 ) {
				String href = rtn.substring( hrefStr + 6, hrefEnd );
				href = generateURL( href, time, user, param );
				rtn = rtn.substring( 0,  hrefStr ) + "href=\"" + href + rtn.substring( hrefEnd );
			}
		}
		return rtn;
	}
}
