/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.fukurou.util;

/**
 * POI による、EXCELバイナリファイルに対する、読み込みイベント処理用のインターフェースです。
 *
 * 基本的なPOIでの読み取りレコードに対して、イベント処理する場合に使用します。
 * このメソッドは、それぞれのPOIUtil処理中に、塊単位で呼ばれるため、逐次処理に向いています。
 *
 * 設定される引数は、WORD,PPT,EXCEL 処理ごとに異なります。
 *
 * @og.rev 6.0.2.0 (2014/09/19) 新規作成
 * @og.group その他
 *
 * @version  6.0
 * @author   Kazuhiko Hasegawa
 * @since    JDK7.0,
 */
public interface POIEvent {

	/**
	 * 読み込みイベント処理のメソッドです。
	 *
	 * 読み取りレコードに対して、このメソッドがコールされます。
	 *
	 * 例：
	 *   WORD :テキスト タイトル 0:Section番号 1:page番号     2:Paragraph番号
	 *   PPT  :テキスト タイトル 0:Slide番号   1:TextRun番号
	 *   EXCEL:テキスト Sheet名  0:Sheet番号   1:Row番号      2:Cell番号
	 *
	 * @og.rev 6.0.2.0 (2014/09/19) 新規作成
	 *
	 * @param	text テキスト
	 * @param	cmnt 説明
	 * @param	args... 可変長引数(ページ数や行番号など)
	 */
	void readText( String text , String cmnt , int... args );
}
