<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:jsp="http://java.sun.com/JSP/Page"
    xmlns:java="http://xml.apache.org/xalan/java"
	xmlns:og="mis-taglib.tld"
	exclude-result-prefixes="xsl jsp java og" >

  <xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"
              omit-xml-declaration="yes"   />

  <xsl:param name="SYSTEM_ID" select="" />
  <xsl:param name="TBLSYU"    select="" />
  <xsl:param name="FILEPATH"  select="" />
  <xsl:param name="ADDRESS"   select="" />
  <xsl:param name="FILENAME"  select="" />
  <xsl:param name="MODIFIED"  select="" />

  <xsl:param name="row_header" >
     <SYSTEM_ID ><xsl:value-of select="$SYSTEM_ID" /></SYSTEM_ID>
	 <TBLSYU	><xsl:value-of select="$TBLSYU"    /></TBLSYU>
     <ADDRESS   ><xsl:value-of select="$ADDRESS"   /></ADDRESS>
     <FILENAME  ><xsl:value-of select="$FILENAME"  /></FILENAME>
     <FILEPATH  ><xsl:value-of select="$FILEPATH"  /></FILEPATH>
     <MODIFIED  ><xsl:value-of select="$MODIFIED"  /></MODIFIED>
  </xsl:param>

  <xsl:template match="jsp:root">
    <xsl:apply-templates select="//jsp:directive.include"    />
    <xsl:apply-templates select="//script[@src]" />
  </xsl:template>

  <xsl:template match="jsp:directive.include">
     <ROW>
       <xsl:copy-of select="$row_header" />
       <TAGNAME  ><xsl:value-of select="name()"  /></TAGNAME>
       <SRC_FILE ><xsl:value-of select="@file"  /></SRC_FILE>
     </ROW>
  </xsl:template>

  <xsl:template match="script[@src]">
     <ROW>
       <xsl:copy-of select="$row_header" />
       <TAGNAME  ><xsl:value-of select="name()"  /></TAGNAME>
       <SRC_FILE ><xsl:value-of select="@src"   /></SRC_FILE>
     </ROW>
  </xsl:template>

</xsl:stylesheet>
