<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes" />

	<xsl:template match="/javadoc">
		<ROWSET tableName="GEA08">
			<EXEC_SQL>delete from GEA08 where SYSTEM_ID='GF' and KBSAKU='0' and KBLBL='A'</EXEC_SQL>
			<xsl:apply-templates select="classDoc/method" />
		</ROWSET>
	</xsl:template>

	<xsl:template match="classDoc/method">
		<xsl:if test="name[not(.=preceding::name)]">
			<xsl:element name="ROW">
				<xsl:attribute name="num">
					<xsl:number level="any" format="1" count="method" />
				</xsl:attribute>
				<SYSTEM_ID		>GF</SYSTEM_ID>
				<CLM			><xsl:value-of select="name"	/></CLM>
				<NAME_JA		><xsl:value-of select="label"	/></NAME_JA>
				<LNAME			><xsl:value-of select="label"	/></LNAME>
				<DESCRIPTION	><xsl:value-of select="description" /></DESCRIPTION>
				<KBSAKU			>0</KBSAKU>
				<LANG			>ja</LANG>
				<KBLBL			>A</KBLBL>
				<FGJ			>1</FGJ>
			</xsl:element>
		</xsl:if>
	</xsl:template>

</xsl:stylesheet>
