/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.mail;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;

final class CharCodeConverter {
    private static final byte[] SJIS_KANA;

    private CharCodeConverter() {
    }

    public static byte[] sjisToJis(byte ... byArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        boolean bl = false;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            int n2;
            if (byArray[i] >= 0) {
                if (bl) {
                    bl = false;
                    byteArrayOutputStream.write(27);
                    byteArrayOutputStream.write(40);
                    byteArrayOutputStream.write(66);
                }
                byteArrayOutputStream.write(byArray[i]);
                continue;
            }
            if (!bl) {
                bl = true;
                byteArrayOutputStream.write(27);
                byteArrayOutputStream.write(36);
                byteArrayOutputStream.write(66);
            }
            if ((n2 = byArray[i] & 0xFF) >= 161 && n2 <= 223) {
                int n3 = (n2 - 161) * 2;
                CharCodeConverter.sjisToJis(byteArrayOutputStream, SJIS_KANA[n3], SJIS_KANA[n3 + 1]);
                continue;
            }
            if (++i == n) break;
            CharCodeConverter.sjisToJis(byteArrayOutputStream, byArray[i - 1], byArray[i]);
        }
        if (bl) {
            byteArrayOutputStream.write(27);
            byteArrayOutputStream.write(40);
            byteArrayOutputStream.write(66);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private static void sjisToJis(ByteArrayOutputStream byteArrayOutputStream, byte by, byte by2) {
        int n = by << 1 & 0xFF;
        int n2 = by2 & 0xFF;
        if (n2 < 159) {
            n = n < 63 ? (n += 31) : (n -= 97);
            n2 = n2 > 126 ? (n2 -= 32) : (n2 -= 31);
        } else {
            n = n < 63 ? (n += 32) : (n -= 96);
            n2 -= 126;
        }
        byteArrayOutputStream.write(n);
        byteArrayOutputStream.write(n2);
    }

    static {
        try {
            SJIS_KANA = "\u3002\u300c\u300d\u3001\u30fb\u30f2\u30a1\u30a3\u30a5\u30a7\u30a9\u30e3\u30e5\u30e7\u30c3\u30fc\u30a2\u30a4\u30a6\u30a8\u30aa\u30ab\u30ad\u30af\u30b1\u30b3\u30b5\u30b7\u30b9\u30bb\u30bd\u30bf\u30c1\u30c4\u30c6\u30c8\u30ca\u30cb\u30cc\u30cd\u30ce\u30cf\u30d2\u30d5\u30d8\u30db\u30de\u30df\u30e0\u30e1\u30e2\u30e4\u30e6\u30e8\u30e9\u30ea\u30eb\u30ec\u30ed\u30ef\u30f3\u309b\u309c".getBytes("Shift_JIS");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("CANT HAPPEN", unsupportedEncodingException);
        }
    }
}

