/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.process;

import java.util.LinkedHashMap;
import java.util.Map;
import org.opengion.fukurou.process.AbstractProcess;
import org.opengion.fukurou.process.ChainProcess;
import org.opengion.fukurou.process.FilterOperation;
import org.opengion.fukurou.process.LineModel;
import org.opengion.fukurou.process.LineModelFilter;
import org.opengion.fukurou.process.ParamProcess;
import org.opengion.fukurou.util.Argument;
import org.opengion.fukurou.util.HybsEntry;
import org.opengion.fukurou.util.LogWriter;
import org.opengion.fukurou.util.StringUtil;

public class Process_TableFilter
extends AbstractProcess
implements ChainProcess {
    public static final char REP_SEP = '\u21d2';
    private static final String PREFIX_KEY = "prefix_";
    private static final String SUFFIX_KEY = "suffix_";
    private static final String INSTR_KEY = "instr_";
    private static final String EQUALS_KEY = "equals_";
    private static final String MATCH_KEY = "match_";
    private static final String UNMATCH_KEY = "unmatch_";
    private static final String CONST_KEY = "const_";
    private static final String REPLACE_KEY = "replace_";
    private final LineModelFilter filter = new LineModelFilter();
    private boolean display;
    private boolean debug;
    private String[] cnstClm;
    private int[] cnstClmNos;
    private String[] constVal;
    private String[] repClm;
    private int[] repClmNos;
    private String[] repValFrom;
    private String[] repValTo;
    private String[] caseVals;
    private boolean firstRow = true;
    private int count;
    private static final Map<String, String> mustProparty = new LinkedHashMap<String, String>();
    private static final Map<String, String> usableProparty = new LinkedHashMap<String, String>();

    public Process_TableFilter() {
        super("org.opengion.fukurou.process.Process_TableFilter", mustProparty, usableProparty);
    }

    @Override
    public void init(ParamProcess paramProcess) {
        int n;
        Argument argument = this.getArgument();
        this.display = argument.getProparty("display", this.display);
        this.debug = argument.getProparty("debug", this.debug);
        HybsEntry[] hybsEntryArray = argument.getEntrys(PREFIX_KEY);
        for (n = 0; n < hybsEntryArray.length; ++n) {
            this.filter.add(FilterOperation.PREFIX, hybsEntryArray[n].getKey(), hybsEntryArray[n].getValue());
        }
        hybsEntryArray = argument.getEntrys(SUFFIX_KEY);
        for (n = 0; n < hybsEntryArray.length; ++n) {
            this.filter.add(FilterOperation.SUFFIX, hybsEntryArray[n].getKey(), hybsEntryArray[n].getValue());
        }
        hybsEntryArray = argument.getEntrys(INSTR_KEY);
        for (n = 0; n < hybsEntryArray.length; ++n) {
            this.filter.add(FilterOperation.INSTR, hybsEntryArray[n].getKey(), hybsEntryArray[n].getValue());
        }
        hybsEntryArray = argument.getEntrys(EQUALS_KEY);
        for (n = 0; n < hybsEntryArray.length; ++n) {
            this.filter.add(FilterOperation.EQUALS, hybsEntryArray[n].getKey(), hybsEntryArray[n].getValue());
        }
        hybsEntryArray = argument.getEntrys(MATCH_KEY);
        for (n = 0; n < hybsEntryArray.length; ++n) {
            this.filter.add(FilterOperation.MATCH, hybsEntryArray[n].getKey(), hybsEntryArray[n].getValue());
        }
        hybsEntryArray = argument.getEntrys(UNMATCH_KEY);
        for (n = 0; n < hybsEntryArray.length; ++n) {
            this.filter.add(FilterOperation.UNMATCH, hybsEntryArray[n].getKey(), hybsEntryArray[n].getValue());
        }
        HybsEntry[] hybsEntryArray2 = argument.getEntrys(CONST_KEY);
        int n2 = hybsEntryArray2.length;
        this.cnstClm = new String[n2];
        this.constVal = new String[n2];
        for (int i = 0; i < n2; ++i) {
            this.cnstClm[i] = hybsEntryArray2[i].getKey();
            this.constVal[i] = hybsEntryArray2[i].getValue();
        }
        HybsEntry[] hybsEntryArray3 = argument.getEntrys(REPLACE_KEY);
        int n3 = hybsEntryArray3.length;
        this.repClm = new String[n3];
        this.repValFrom = new String[n3];
        this.repValTo = new String[n3];
        this.caseVals = new String[n3];
        for (int i = 0; i < n3; ++i) {
            this.repClm[i] = hybsEntryArray3[i].getKey();
            String string = hybsEntryArray3[i].getValue();
            if (string == null) continue;
            int n4 = string.indexOf(8658);
            if (n4 >= 0) {
                this.repValFrom[i] = string.substring(0, n4);
                this.repValTo[i] = string.substring(n4 + 1);
                continue;
            }
            this.caseVals[i] = string;
        }
    }

    @Override
    public LineModel action(LineModel lineModel) {
        int n;
        ++this.count;
        if (!this.filter.filter(lineModel)) {
            return null;
        }
        if (this.firstRow) {
            int n2;
            n = this.cnstClm.length;
            this.cnstClmNos = new int[n];
            for (n2 = 0; n2 < n; ++n2) {
                this.cnstClmNos[n2] = lineModel.getColumnNo(this.cnstClm[n2]);
            }
            n2 = this.repClm.length;
            this.repClmNos = new int[n2];
            for (int i = 0; i < n2; ++i) {
                this.repClmNos[i] = lineModel.getColumnNo(this.repClm[i]);
            }
            this.firstRow = false;
            if (this.display) {
                this.println(lineModel.nameLine());
            }
        }
        if (this.debug) {
            this.println("Before:" + lineModel.dataLine());
        }
        for (n = 0; n < this.cnstClm.length; ++n) {
            lineModel.setValue(this.cnstClmNos[n], this.constVal[n]);
        }
        for (n = 0; n < this.repClm.length; ++n) {
            String string = "";
            Object object = lineModel.getValue(this.repClmNos[n]);
            if (object != null) {
                string = String.valueOf(object);
            }
            string = this.caseVals[n] == null ? string.replaceAll(this.repValFrom[n], this.repValTo[n]) : StringUtil.caseReplace(string, this.caseVals[n], false);
            lineModel.setValue(this.repClmNos[n], string);
        }
        if (this.debug) {
            this.println("After :" + lineModel.dataLine());
        } else if (this.display) {
            this.println(lineModel.dataLine());
        }
        return lineModel;
    }

    @Override
    public void end(boolean bl) {
        this.cnstClm = null;
        this.cnstClmNos = null;
        this.constVal = null;
        this.repClm = null;
        this.repClmNos = null;
        this.repValFrom = null;
        this.repValTo = null;
        this.caseVals = null;
    }

    @Override
    public String report() {
        String string = "[" + this.getClass().getName() + "]" + CR + '\t' + "Model Filter : " + this.filter + CR + '\t' + "Output Count : " + this.count;
        return string;
    }

    @Override
    public String usage() {
        StringBuilder stringBuilder = new StringBuilder(500).append("Process_TableFilter \u306f\u3001\u4e0a\u6d41\u304b\u3089\u53d7\u3051\u53d6\u3063\u305f\u30c7\u30fc\u30bf\u3092\u30d5\u30a3\u30eb\u30bf\u3059\u308b\u3001").append(CR).append("ChainProcess \u30a4\u30f3\u30bf\u30fc\u30d5\u30a7\u30fc\u30b9\u306e\u5b9f\u88c5\u30af\u30e9\u30b9\u3067\u3059\u3002").append(CR).append(CR).append("\u4e0a\u6d41(\u30d7\u30ed\u30bb\u30b9\u30c1\u30a7\u30a4\u30f3\u306e\u30c7\u30fc\u30bf\u306f\u4e0a\u6d41\u304b\u3089\u4e0b\u6d41\u3078\u3068\u6e21\u3055\u308c\u307e\u3059\u3002)\u304b\u3089").append(CR).append("\u53d7\u3051\u53d6\u3063\u305fLineModel \u3092\u5143\u306b\u3001\u9805\u76ee\u306e\u30d5\u30a3\u30eb\u30bf\u30ea\u30f3\u30b0\u3092\u884c\u3044\u307e\u3059\u3002").append(CR).append("\u6761\u4ef6\u304c\u6210\u7acb\u3057\u305f\u5834\u5408\u306f\u3001\u4e0b\u6d41\u306b\u6d41\u3057\u307e\u3059\u3002\u8907\u6570\u306e\u6761\u4ef6\u3092\u6307\u5b9a\u3067\u304d\u307e\u3059\u304c\u3001").append(CR).append("\u3059\u3079\u3066 AND \u3067\u5224\u5b9a\u3055\u308c\u307e\u3059\u3002").append(CR).append("(\u8a2d\u5b9a\u6761\u4ef6\u3059\u3079\u3066\u3092\u6e80\u305f\u3059\u5834\u5408\u306e\u307f\u3001\u4e0b\u6d41\u306b\u30c7\u30fc\u30bf\u3092\u6d41\u3057\u307e\u3059\u3002)").append(CR).append(CR).append("\u5f15\u6570\u6587\u5b57\u5217\u4e2d\u306b\u7a7a\u767d\u3092\u542b\u3080\u5834\u5408\u306f\u3001\u30c0\u30d6\u30eb\u30b3\u30fc\u30c6\u30fc\u30b7\u30e7\u30f3(\"\") \u3067\u62ec\u3063\u3066\u4e0b\u3055\u3044\u3002").append(CR).append("\u5f15\u6570\u6587\u5b57\u5217\u306e \u300e=\u300f\u306e\u524d\u5f8c\u306b\u306f\u3001\u7a7a\u767d\u306f\u631f\u3081\u307e\u305b\u3093\u3002\u5fc5\u305a\u3001-key=value \u306e\u69d8\u306b").append(CR).append("\u7e4b\u3052\u3066\u304f\u3060\u3055\u3044\u3002").append(CR).append(CR).append(CR).append(this.getArgument().usage()).append(CR);
        return stringBuilder.toString();
    }

    public static void main(String[] stringArray) {
        LogWriter.log(new Process_TableFilter().usage());
    }

    static {
        usableProparty.put(PREFIX_KEY, "\u9805\u76ee\u540d(XXXX)\u304c\u3001\u6307\u5b9a\u306e\u63a5\u982d\u8f9e\u3067\u59cb\u307e\u308b\u5834\u5408\u3001\u6761\u4ef6\u6210\u7acb\u3002");
        usableProparty.put(SUFFIX_KEY, "\u9805\u76ee\u540d(XXXX)\u304c\u3001\u6307\u5b9a\u306e\u63a5\u5c3e\u8f9e\u3067\u7d42\u308f\u308b\u5834\u5408\u3001\u6761\u4ef6\u6210\u7acb\u3002");
        usableProparty.put(INSTR_KEY, "\u9805\u76ee\u540d(XXXX)\u304c\u3001\u6307\u5b9a\u306e\u90e8\u5206\u6587\u5b57\u5217\u3068\u4e00\u81f4\u3059\u308b\u5834\u5408\u3001\u6761\u4ef6\u6210\u7acb\u3002");
        usableProparty.put(EQUALS_KEY, "\u9805\u76ee\u540d(XXXX)\u304c\u3001\u6587\u5b57\u5217\u3068\u4e00\u81f4\u3059\u308b\u5834\u5408\u3001\u6761\u4ef6\u6210\u7acb\u3002" + CR + "(\u5927\u6587\u5b57\u5c0f\u6587\u5b57\u306f\u533a\u5225\u3057\u306a\u3044)");
        usableProparty.put(MATCH_KEY, "\u9805\u76ee\u540d(XXXX)\u304c\u3001\u6b63\u898f\u8868\u73fe\u3068\u4e00\u81f4\u3059\u308b\u5834\u5408\u3001\u6761\u4ef6\u6210\u7acb\u3002");
        usableProparty.put(UNMATCH_KEY, "\u9805\u76ee\u540d(XXXX)\u304c\u3001\u6b63\u898f\u8868\u73fe\u3068\u4e00\u81f4\u3057\u306a\u3044\u5834\u5408\u3001\u6761\u4ef6\u6210\u7acb\u3002");
        usableProparty.put(CONST_KEY, "\u9805\u76ee\u540d(XXXX)\u306b\u3001\u56fa\u5b9a\u5024\u3092\u8a2d\u5b9a\u3057\u307e\u3059\u3002");
        usableProparty.put(REPLACE_KEY, "\u9805\u76ee\u540d(XXXX)\u306e\u6587\u5b57\u5217\u304b\u3089\u3001YYYY\u21d2ZZZZ \u3067\u90e8\u5206\u7f6e\u63db\u3057\u307e\u3059\u3002" + CR + "\u9805\u76ee\u540d(XXXX)\u306e\u6587\u5b57\u5217\u304b\u3089\u3001_:0 A:1 B:2\u3067CASE\u7f6e\u63db\u3057\u307e\u3059\u3002");
        usableProparty.put("display", "\u7d50\u679c\u3092\u6a19\u6e96\u51fa\u529b\u306b\u8868\u793a\u3059\u308b(true)\u304b\u3057\u306a\u3044(false)\u304b" + CR + "(\u521d\u671f\u5024:false:\u8868\u793a\u3057\u306a\u3044)");
        usableProparty.put("debug", "\u30c7\u30d0\u30c3\u30b0\u60c5\u5831\u3092\u6a19\u6e96\u51fa\u529b\u306b\u8868\u793a\u3059\u308b(true)\u304b\u3057\u306a\u3044(false)\u304b" + CR + "(\u521d\u671f\u5024:false:\u8868\u793a\u3057\u306a\u3044)");
    }
}

