/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.plugin.column;

import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.db.AbstractEditor;
import org.opengion.hayabusa.db.CellEditor;
import org.opengion.hayabusa.db.DBColumn;
import org.opengion.fukurou.util.TagBuffer;
import org.opengion.fukurou.util.XHTMLTag;

/**
 * COLOR エディターは、カラムのデータをカラーピッカーで選択する場合に使用するクラスです。
 * 値は#FFFFFFのように#付き7桁で入ります。
 *
 *  カラムの表示に必要な属性は, DBColumn オブジェクト より取り出します。
 * このクラスは、DBColumn オブジェクト毎に１つ作成されます。
 *
 * @og.group データ編集
 *
 * @og.rev 5.5.4.0 (2012/07/02) 新規作成
 *
 * @version  4.0
 * @author   Kazuhiko Hasegawa
 * @since    JDK5.0,
 */
public class Editor_COLOR extends AbstractEditor {
	//* このプログラムのVERSION文字列を設定します。	{@value} */
	private static final String VERSION = "5.5.4.0 (2012/07/02)" ;

	/**
	 * デフォルトコンストラクター。
	 * このコンストラクターで、基本オブジェクトを作成します。
	 *
	 * @og.rev 3.1.1.1 (2003/04/03) 各オブジェクトから自分のインスタンスを返すファクトリメソッドを追加。
	 *
	 */
//	public Editor_COLOR() {}
	public Editor_COLOR() { super(); }			// PMD:Document empty constructor 対策

	/**
	 * コンストラクター。
	 *
	 * @param	clm	DBColumnオブジェクト
	 */
	private Editor_COLOR( final DBColumn clm ) {
		super( clm );
		attributes.add( "class"		,"colorPicker" );
		attributes.add( "readonly"	,"readonly" );
		tagBuffer.add( XHTMLTag.inputAttri( attributes ) );
	}

	/**
	 * 各オブジェクトから自分のインスタンスを返します。
	 * 自分自身をキャッシュするのか、新たに作成するのかは、各サブクラスの実装に
	 * まかされます。
	 *
	 * @param	clm	DBColumnオブジェクト
	 *
	 * @return	CellEditorオブジェクト
	 */
	public CellEditor newInstance( final DBColumn clm ) {
		return new Editor_COLOR( clm );
	}

	/**
	 * データの編集用文字列を返します。(色付き)
	 *
	 * @param	value 入力値
	 *
	 * @return	データの編集用文字列
	 */
	@Override
	public String getValue( final String value ) {

		final TagBuffer tag = new TagBuffer( "input" );
		tag.add( "name"		, name );
//		if( attributes.get( "id" ) == null || attributes.get( "id" ).length() == 0 ) {
		if( attributes.get( "id" ) == null || attributes.get( "id" ).isEmpty() ) {
			tag.add( "id"	, name );
		}
		tag.add( "value"	, value );
		tag.add( "size"		, size1 );
		tag.add( "style"	, "background-color:"+value+"; color:"+value+";" );
		tag.add( tagBuffer.makeTag() );
//		tag.add( optAttr );

		return tag.makeTag();
	}

	/**
	 * name属性を変えた、データ表示/編集用のHTML文字列を作成します。(色付き)
	 * テーブル上の name に 行番号を付加して、名前_行番号 で登録するキーを作成し,
	 * リクエスト情報を１つ毎のフィールドで処理できます。
	 *
	 * @param	row   行番号
	 * @param	value 入力値
	 *
	 * @return	データ表示/編集用の文字列
	 */
	@Override
	public String getValue( final int row,final String value ) {
		final TagBuffer tag = new TagBuffer( "input" );
		final String newName = name + HybsSystem.JOINT_STRING + row;
		tag.add( "name"		, newName );
//		if( attributes.get( "id" ) == null || attributes.get( "id" ).length() == 0 ) {
		if( attributes.get( "id" ) == null || attributes.get( "id" ).isEmpty() ) {
			tag.add( "id"	, newName );
		}
		tag.add( "value"	, value );
		tag.add( "size"		, size2 );
		tag.add( "style"	, "background-color:"+value+"; color:"+value+";" );
		tag.add( tagBuffer.makeTag() );
//		tag.add( optAttr );

		return tag.makeTag( row,value );
	}
}
