<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head useTreeBOM="true" headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GFX012"
	title	= "親子展開"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>
<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<og:columnCheck
	command   = "{@command}"
	columns   = "MGR"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
		select LEVEL,A.MGR,A.JOB,A.EMPNO,A.ENAME,A.SAL,A.COMM,A.DEPTNO,B.DNAME,B.LOC,A.HIREDATE
		from EMP A inner join DEPT B
		on    A.DEPTNO = B.DEPTNO
		start with A.MGR = {@MGR}
		connect by prior A.EMPNO = A.MGR
</og:query>

<og:columnEditor column="DNAME" must="true" editor="DBMENU" addNoValue="false" >
	select DEPTNO,DNAME from DEPT
</og:columnEditor>

<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">

<!-- 複写、変更、削除ボタンを作成します。value属性+.jspの画面に制御が移ります。 -->
<!-- このとき、command=(value属性の値の大文字)が設定されます。 command属性で設定しなおすことも出来ます。-->
<og:writeCheck>
	<og:submit  value="test01" command="NEW" lbl="Test 01" keys="lblKey" vals="AAAA" />
	<og:submit  value="test02" command="NEW" lbl="Test 02" keys="lblKey" vals="BBBB" />
	<og:submit  value="test03" command="NEW" lbl="Test 03" target="CONTENTS" />
</og:writeCheck>

<og:view
	viewFormType = "HTMLTable"
	command    = "{@command}"
	startNo    = "{@startNo}"
	checked    = "{@checked}"
	pageSize   = "{@pageSize}" />
<!--

<og:view
	viewFormType = "HTMLTreeBOM"
	command    = "{@command}"
	startNo    = "{@startNo}"
	checked    = "{@checked}"
	writable   = "false"
	pageSize   = "{@pageSize}" />
-->

</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
