<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GFX004"
	title	= "対訳"
	date	= "2015/05/09"
	author	= "K.Hasegawa"
	text	= ""
	version	= "001"
/>

<!-- 変更はここから -->

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command = "{@command}" />

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command = "{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
		select SYSTEM_ID,KEYWORD,GENBUN,YAKU,LANG_YAKU,KBYAKU,KBHORYU,ID,COMMENTS,UNIQ,FGJ
		from    GF28
	<!-- 検索条件でWhereTagを使用すれば{@xxxx}がNULLの場合、その条件は無視されます。 -->
	<og:where>
		<og:and value = "SYSTEM_ID	=    '{@SYSTEM_ID}'"	/>
		<og:and value = "GENBUN		LIKE '{@GENBUN}'"		/>
		<og:and value = "KBYAKU		=    '{@KBYAKU}'"		/>
		<og:and value = "KBHORYU	=    '{@KBHORYU}'"		/>
		<og:and value = "KEYWORD	LIKE '{@KEYWORD}'"		/>
		<og:and value = "ID			LIKE '{@ID}'"			/>
		<og:and value = "YAKU		LIKE '{@YAKU}'"			/>
		<og:and value = "LANG_YAKU	=    '{@LANG_YAKU}'"	/>
		<og:and value = "FGJ in ( '0','1' )"				/>
	</og:where>
	<!-- ORDER BY句でAppearTagを使用すれば{@ORDER_BY}がNULLの場合、ORDER BY句は無視されます。 -->
	<!-- また、{@ORDER_BY}がNULLの場合に、defaultVal属性を指定すれば、その値でORDER BY表示されます。 -->
	<og:appear startKey="order by" value="{@SORT}" defaultVal="GENBUN,KBYAKU" />
</og:query>

<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">

	<!-- 複写、変更、削除ボタンを作成します。 -->
	<og:writeCheck>
		<og:fieldset lbl="resourceUpdate">
			<og:column  name="sqlType" codeKeyVal="INSERT MODIFY" td="no" />
			<og:column  name="DBID"    codeKeyVal="{@DBID_INFO}"  td="no" />
			<!-- command="NEW" にすると、キャッシュが消えるので、注意 -->
			<og:submit  value="resourceUpdate" lbl="resource"  command="INSERT" />
		</og:fieldset>
		<!-- command="NEW" にすると、キャッシュが消えるので、注意 -->
		<og:submit value="fileInExcel" lbl="EXCEL_CNG" command="INSERT" />
		<br />
	</og:writeCheck>

		<!-- DB検索結果を表示させます。 -->
		<og:view
			viewFormType = "HTMLFormatTable"
			writable	 = "false"
			command 	 = "{@command}"
			noDisplay    = "UNIQ,FGJ"
			checked      = "{@checked}"
			startNo      = "{@startNo}" 
			pageSize     = "{@pageSize}"
			rowspan      = "2"
		>
		<tr><td>[KBHORYU]  </td><td>[GENBUN]</td><td>[SYSTEM_ID]</td><td>[ID]     </td><td rowspan="2">[COMMENTS]</td></tr>
		<tr><td>[LANG_YAKU]</td><td>[YAKU]  </td><td>[KBYAKU]   </td><td>[KEYWORD]</td></tr>
		</og:view>
</form>

<!-- ここまで。 -->
	<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
