<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="init" />
<!-- history.back() で戻るボタンを表示します。	-->
<jsp:directive.include file="/jsp/common/history_back.jsp" />

<og:upload
	fileURL     = "{@USER.ID}"
	maxPostSize = "0"
/>

<og:columnCheck
	command   = "NEW"
	nullCheck = "file1,SYSTEM_ID"
/>

<og:file fileURL="{@USER.ID}" file1="{@file1}" action="existsLength" >
	<og:message lbl="MSG0064" comment="ファイルが存在していません。" />
	<og:text>fileURL="{@USER.ID}" file1="{@file1}"</og:text>
</og:file>

<!-- EXCELファイルから読み込みます。 -->
<og:readTable
	command		= "NEW"
	readerClass = "POI"
	useNumber   = "false"
	fileURL		= "{@USER.ID}"
	filename	= "{@file1}"
	maxRowCount	= "0"
	nullSkipClm	= "TEXT"
	debug		= "{@debug}"
/>

<!-- TEXT カラム(=POIは、これしかない) を、グルーピングします。 -->
<og:tableMerge
	action		= "GROUP"
	masterKeys	= "TEXT"
/>

<!-- すでにDB登録済みのデータがあれば、無視する為に、取得します。 -->
<og:query command="NEW" debug="{@debug}" maxRowCount="0" scope="request" >
	select GENBUN as TEXT
	from   GF28
	where  SYSTEM_ID = '{@MEM.SYSTEM_ID}'
	and    KBYAKU    = '4'
	and    KEYWORD   = '{@file1}'
</og:query>

<!-- すでにDB登録済みのデータを除外します。 -->
<og:tableMerge
	action		= "MINUS"
	masterKeys	= "TEXT"
/>

<!-- 登録処理をおこないます。 -->
	<og:tableUpdate command="ENTRY" queryType="JDBCTableUpdate" debug="{@debug}" selectedAll="true">
		<og:tableUpdateParam
			constObjKey = "GF"
			sqlType		= "INSERT"
			table		= "GF28"
			asNames		= "TEXT"
			orgNames	= "GENBUN"
			constKeys	= "SYSTEM_ID,KEYWORD,LANG_YAKU,KBYAKU,KBHORYU,FGJ"
			constVals	= "{@MEM.SYSTEM_ID},{@file1},**,4,0,1"
		/>
	</og:tableUpdate>

	<og:forward page="result.jsp" debug="{@debug}" 
			keys="command,SYSTEM_ID,KEYWORD" vals="RENEW,{@MEM.SYSTEM_ID},{@file1}" />

<!--
	<og:view
		viewFormType = "HTMLTable"
		command 	 = "NEW"
	/>
-->

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
