<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GFX003"
	title	= "対訳"
	date	= "2015/05/09"
	author	= "K.Hasegawa"
	text	= ""
	version	= "001"
/>

<!-- 変更はここから -->

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="NEW" clear="{@clear}" displayMsg="{@displayMsg}" />

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="NEW" />

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="NEW" debug="{@debug}" maxRowCount="{@MEM.maxRowCount}">
	select A.SYSTEM_ID,A.KEYWORD,A.GENBUN,A.YAKU,A.LANG_YAKU,A.KBYAKU,A.KBHORYU,A.ID,A.COMMENTS,A.UNIQ,A.FGJ
	from   GF28 A
	where exists (select 'X' from GF28 B
					where A.SYSTEM_ID = B.SYSTEM_ID
					and   A.GENBUN    = B.GENBUN
					and   A.LANG_YAKU = B.LANG_YAKU
					and ( A.YAKU = B.YAKU or A.LANG_YAKU = B.LANG_YAKU )
					and   A.UNIQ     != B.UNIQ
					and   B.KBHORYU  != '9'
		)
	and   A.SYSTEM_ID  = '{@MEM.SYSTEM_ID}'
	and   A.KBHORYU   != '9'
	<og:where startKey="and">
		<og:and value = "A.LANG_YAKU = '{@MEM.LANG_YAKU}'" />
	</og:where>
	order by A.SYSTEM_ID,A.GENBUN,A.LANG_YAKU,A.UNIQ
</og:query>

<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">

	<!-- 登録、取消、リセットボタンを作成します。 -->
	<og:writeCheck>
		<og:submit  action="MODIFY" lbl="KBHORYU" columnWritable="KBHORYU"
						keys="KBHORYU" vals="9" />
		<og:submit  action="MODIFY"  columnWritable="KBHORYU,YAKU"  />
		<og:submit  action="DELETE"  columnWritable="null" />
	</og:writeCheck>

		<!-- DB検索結果を表示させます。 -->
		<og:view
			viewFormType = "HTMLFormatTable"
			command 	 = "{@command}"
			noDisplay    = "UNIQ,FGJ"
			checked      = "{@checked}"
			startNo      = "{@startNo}" 
			pageSize     = "{@pageSize}"
			rowspan      = "2"
		>
		<tr><td>[KBHORYU]  </td><td>[GENBUN]</td><td>[SYSTEM_ID]</td><td>[ID]     </td><td rowspan="2">[COMMENTS]</td></tr>
		<tr><td>[LANG_YAKU]</td><td>[YAKU]  </td><td>[KBYAKU]   </td><td>[KEYWORD]</td></tr>
		</og:view>
</form>

<!-- ここまで。 -->
	<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
