<?xml version="1.0" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system   = "GE:エンジンサンプル"
	pgid     = "REP11"
	title    = "雛形明細定義"
	date     = "2007/12/12"
	author   = "K.HASEGAWA"
	text     = "ZZZZ"
	version  = "001"
/>

<!-- 変更はここからです。 -->

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<!-- 入力チェックを行います。 -->
<!-- 入力内容がNULLの場合にエラーを返したい場合は、nullCheck属性を追加して下さい。-->
<og:columnCheck
	command = "{@command}"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command = "{@command}" />

<!-- DBを検索するための SQL文を記述します。 debug="true" で画面からSQL文を確認できます。 -->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
		select
			LISTID,SHEETNO,SHEETREF,HEADDBID,BODYDBID,LOOPCLM,SYSTEM_ID,
			RDC_CODE,RELEASE_NOTES,FGJ,DYUPD
		from GE57

	<!-- 検索条件でWhereTagを使用すれば{@xxxx}がNULLの場合、その条件は無視されます。 -->
	<og:where>
		<og:and value = "SYSTEM_ID = '{@SYSTEM_ID}'"	/>
		<og:and value = "LISTID    LIKE '{@LISTID}'"		/>
		<og:and value = "FGJ in ('0','1')"					/>
		<og:and value = "HEADDBID LIKE '{@HEADDBID}'"		/>
		<og:and value = "BODYDBID LIKE '{@BODYDBID}'"		/>
		<og:and value = "LOOPCLM  LIKE '{@LOOPCLM}'"		/>
		<og:and value = "RDC_CODE   = '{@RDC_CODE}'"   />
		<og:and value = "DYUPD  &gt;= '{@DYUPDFROM}'"  />
		<og:and value = "DYUPD  &lt;= '{@DYUPDTO}99'"  />
		<og:and value = "RELEASE_NOTES like '{@RELEASE_NOTES}'" />
	</og:where>
		order by SYSTEM_ID,LISTID,SHEETNO
</og:query>

<!-- ColumnEditorTagを使用すると、登録画面の入力フィールドで、入力の必須状態を表したり(must="true"を使用)、 -->
<!-- DBからの検索結果を、コンボボックスでプルダウン表示させる(editor="DBMENU"を使用)ことが可能となります。 -->
<og:columnEditor column="SYSTEM_ID" must="true" />
<og:columnEditor column="LISTID"    must="true" />
<og:columnEditor column="SHEETNO"   must="true" />
<og:columnEditor column="SHEETREF"  must="true" />

<og:viewLink command="{@command}">
	<og:link column="LISTID" gamenId="REP05" href="index.jsp" target="CONTENTS"
			keys="command,SYSTEM_ID,LISTID" vals="NEW,[SYSTEM_ID],[LISTID]" />
	<og:link column="HEADDBID" gamenId="REP12" href="index.jsp" target="CONTENTS"
			keys="command,SYSTEM_ID,TABLE_NAME" vals="NEW,[SYSTEM_ID],[HEADDBID]" />
	<og:link column="BODYDBID" gamenId="REP12" href="index.jsp" target="CONTENTS"
			keys="command,SYSTEM_ID,TABLE_NAME" vals="NEW,[SYSTEM_ID],[BODYDBID]" />
</og:viewLink>

<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">

<!-- 追加、複写、変更、削除ボタンを作成します。 -->
<og:writeCheck>
	<og:submit  value="copy"     lbl="COPY"    accesskey="C" />
	<og:submit  value="modify"   lbl="MODIFY"  accesskey="M" />
	<og:submit  value="delete"   lbl="DELETE"  accesskey="Z" />

</og:writeCheck>

<!-- DB検索結果を表示させます。 -->
<og:view
	viewFormType = "HTMLTable"
	command 	 = "{@command}"
	checked      = "{@checked}"
	startNo      = "{@startNo}" 
	pageSize     = "{@pageSize}"
/>

</form>

<!-- 変更はここまでです。 -->

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
