<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GFX003"
	title	= "対訳"
	date	= "2015/05/09"
	author	= "K.Hasegawa"
	text	= ""
	version	= "001"
/>

<!-- 変更はここから -->

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="NEW" clear="{@clear}" displayMsg="{@displayMsg}" />

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="NEW" />

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="NEW" debug="{@debug}" maxRowCount="0">
	select '1' as WRITABLE,SYSTEM_ID,KEYWORD,GENBUN,YAKU,LANG_YAKU,KBYAKU,KBHORYU,ID,COMMENTS,UNIQ,FGJ
	from   GF28
	where  YAKU is null
	and    SYSTEM_ID = '{@MEM.SYSTEM_ID}'
	order by SYSTEM_ID,GENBUN,LANG_YAKU,UNIQ
</og:query>

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="NEW" debug="{@debug}" maxRowCount="0" scope="request">
	select '0' as WRITABLE,SYSTEM_ID,KEYWORD,GENBUN,YAKU,LANG_YAKU,KBYAKU,KBHORYU,ID,COMMENTS,UNIQ,FGJ
	from   GF28
	where  KBHORYU   = '1'
	order by SYSTEM_ID,GENBUN,LANG_YAKU,UNIQ
</og:query>

<og:tableMerge
	action		= "DIFFERENCE"
	masterKeys	= "GENBUN"
	diffKeys	= "LANG_YAKU,YAKU"
	modifyClms	= "LANG_YAKU,YAKU"
/>

<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">
	<!-- 登録、取消、リセットボタンを作成します。 -->
	<og:writeCheck>
		<og:submit  action="ENTRY" />
	</og:writeCheck>

	<!-- DB検索結果を表示させます。 -->
	<og:view
		viewFormType	= "HTMLFormatTable"
		command			= "NEW"
		columnWritable	= "YAKU,COMMENTS"
		noDisplay		= "FGJ"
		checked			= "{@checked}"
		startNo			= "{@startNo}" 
		pageSize		= "{@pageSize}"
		rowspan			= "2"
	>
		<tr><td>[KBHORYU]  </td><td>[GENBUN]</td><td>[SYSTEM_ID]</td><td>[ID]     </td><td rowspan="2">[COMMENTS]</td></tr>
		<tr><td>[LANG_YAKU]</td><td>[YAKU]  </td><td>[KBYAKU]   </td><td>[KEYWORD]</td></tr>
	</og:view>

	<og:hidden name="sqlType" defaultVal="MODIFY" value="MODIFY" />
</form>

<!-- ここまで。 -->
	<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
