<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system   = "GE:エンジンサンプル"
	pgid     = "10_REPORT"
	title    = "帳票結果表示"
	date     = "2014/12/16"
	author   = "K.Hasegawa"
	text     = ""
	version  = "001"
/>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
	columns   = "SYSTEM_ID,YKNO,GROUPID,LISTID,FGKAN"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command = "{@command}" />

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="NEW" debug="{@debug}" maxRowCount="0">
		select  a.FGKAN,a.YKNO,a.LISTID,b.LISTNAME,a.JOKEN,
				a.SUDATA,a.SUPAGE,
				replace( a.OUT_DIR , '{@SYS.REAL_PATH}','{@SYS.CONTEXT_URL}' ) as OUT_DIR ,
				a.OUT_FILE,
				a.DYSET,a.USRSET,a.PGSET,a.PGPSET
		from    GE50 a left outer join GE54 b
		on		a.SYSTEM_ID = b.SYSTEM_ID
		and		a.LISTID    = b.LISTID
	<og:where>
		<og:and value = "a.SYSTEM_ID =    '{@SYSTEM_ID}'"	/>
		<og:and value = "a.YKNO      =    '{@YKNO}'"	/>
		<og:and value = "a.JOKEN     LIKE '{@JOKEN}'"	/>
		<og:and value = "a.LISTID    LIKE '{@LISTID}'"	/>
		<og:and value = "a.FGKAN     =    '{@FGKAN}'"	/>
		<og:and value = "a.FGJ       in   ( '0','1' )"	/>
		<og:and value = "a.DYSET     LIKE '{@DYSET}'"	/>
		<og:and value = "a.USRSET    =    '{@USRSET}'"	/>
		<og:and value = "a.PGSET     =    '{@PGSET}'"	/>
		<og:and value = "a.PGPSET    =    '{@PGPSET}'"	/>
	</og:where>
	<og:appear startKey="order by" value="{@ORDER_BY}" defaultVal="a.SYSTEM_ID,a.YKNO DESC" />
</og:query>

<og:viewLink command="NEW">
	<og:link column="OUT_FILE" href="[OUT_DIR]/[OUT_FILE]" target="_blank" useGamenId="false" />
</og:viewLink>

<!-- DB検索結果を表示させます。 -->
<og:view
	viewFormType = "HTMLTable"
	command 	 = "NEW"
	startNo      = "{@startNo}"
	pageSize     = "{@pageSize}"
	noDisplay	 = "OUT_DIR,DYSET,USRSET,PGSET,PGPSET"
/>

<!-- ここまで。 -->
	<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
