/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.xml;

import org.opengion.fukurou.xml.OGAttributes;
import org.opengion.fukurou.xml.OGNode;
import org.opengion.fukurou.xml.OGNodeType;
import org.xml.sax.Attributes;

public class OGElement
extends OGNode {
    private final String qName;
    private OGAttributes attri;
    private static final int PARA_LEN = 8;
    private static final String PARA_CHAR = "\t";
    private static final String[] PARA = new String[8];

    public OGElement(String string) {
        this(string, null);
    }

    public OGElement(String string, Attributes attributes) {
        this.setNodeType(OGNodeType.Element);
        if (string == null) {
            throw new RuntimeException("\u30a8\u30ec\u30e1\u30f3\u30c8\u306b\u306f\u3001\u30ce\u30fc\u30c9\u540d\u306f\u5fc5\u9808\u3067\u3059\u3002");
        }
        this.qName = string;
        this.attri = new OGAttributes(attributes);
    }

    public String getTagName() {
        return this.qName;
    }

    public OGAttributes getOGAttributes() {
        return this.attri;
    }

    public void setOGAttributes(OGAttributes oGAttributes) {
        this.attri = oGAttributes;
    }

    public String getId() {
        return this.attri != null ? this.attri.getId() : null;
    }

    public String getVal(String string) {
        return this.attri != null ? this.attri.getVal(string) : null;
    }

    public void addAttr(String string, String string2) {
        if (this.attri == null) {
            this.attri = new OGAttributes();
        }
        this.attri.add(string, string2);
    }

    public boolean match(String string, String string2, String string3) {
        if (string != null && !string.equals(this.qName)) {
            return false;
        }
        if (this.attri == null && (string2 != null || string3 != null)) {
            return false;
        }
        if (string2 != null) {
            if (string3 != null) {
                return string3.equals(this.attri.getVal(string2));
            }
            return this.attri.getAdrs(string2) >= 0;
        }
        if (string3 != null) {
            boolean bl = false;
            int n = this.attri.size();
            for (int i = 0; i < n; ++i) {
                if (!string3.equals(this.attri.getVal(i))) continue;
                bl = true;
                break;
            }
            return bl;
        }
        return true;
    }

    private String getPara(int n) {
        if (n < 0) {
            return "";
        }
        if (n < 8) {
            return PARA[n];
        }
        return PARA[7];
    }

    @Override
    public String getText(int n) {
        StringBuilder stringBuilder = new StringBuilder(200).append(this.getPara(n)).append('<').append(this.qName).append(this.attri.getText(this.getPara(n + 1)));
        String string = super.getText(n + 1);
        if (string.trim().isEmpty()) {
            stringBuilder.append("/>");
        } else {
            stringBuilder.append('>').append(string).append(this.getPara(n)).append("</").append(this.qName).append('>');
        }
        String string2 = stringBuilder.toString();
        switch (this.getNodeType()) {
            case Comment: {
                string2 = "<!-- " + string2 + " -->";
                break;
            }
            case Cdata: {
                string2 = "<![CDATA[ " + string2 + " ]]>";
                break;
            }
        }
        return string2.replaceAll(CR + CR + CR, CR + CR);
    }

    static {
        OGElement.PARA[0] = CR;
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append(CR);
        for (int i = 1; i < 8; ++i) {
            stringBuilder.append(PARA_CHAR);
            OGElement.PARA[i] = stringBuilder.toString();
        }
    }
}

