/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.util;

import java.util.ArrayList;
import java.util.List;
import org.opengion.fukurou.util.ErrMsg;
import org.opengion.fukurou.util.HybsConst;

public final class ErrorMessage {
    public static final int BUFFER_MIDDLE = 200;
    public static final int OK = 0;
    public static final int WARNING = 1;
    public static final int NG = 2;
    public static final int EXCEPTION = 8;
    public static final int ORCL_ERR = 9;
    private int maxKekka = 0;
    private String title = "";
    private final List<ErrMsg> list = new ArrayList<ErrMsg>();
    private boolean setPgStep;

    public ErrorMessage() {
        this.setTitle("NO TITLE");
    }

    public ErrorMessage(String string) {
        this.setTitle(string);
    }

    public void addMessage(String ... stringArray) {
        this.addMessage(0, 2, "", stringArray);
    }

    public void addMessage(int n, int n2, String string, String ... stringArray) {
        if (string != null) {
            ErrMsg errMsg = new ErrMsg(n, n2, null, null, string, stringArray);
            this.list.add(errMsg);
            if (this.maxKekka < n2) {
                this.maxKekka = n2;
            }
        }
    }

    public void addMessage(ErrMsg errMsg) {
        this.list.add(errMsg);
        if (this.maxKekka < errMsg.getKekka()) {
            this.maxKekka = errMsg.getKekka();
        }
        if (errMsg.getPg() != null || errMsg.getStep() != null) {
            this.setPgStep = true;
        }
    }

    public void append(ErrorMessage errorMessage) {
        if (errorMessage != null) {
            if (this.maxKekka < errorMessage.getKekka()) {
                this.maxKekka = errorMessage.getKekka();
            }
            ErrMsg[] errMsgArray = errorMessage.toArray();
            for (int i = 0; i < errMsgArray.length; ++i) {
                this.list.add(errMsgArray[i]);
            }
        }
    }

    public void append(int n, ErrorMessage errorMessage) {
        if (errorMessage != null) {
            if (this.maxKekka < errorMessage.getKekka()) {
                this.maxKekka = errorMessage.getKekka();
            }
            ErrMsg[] errMsgArray = errorMessage.toArray();
            for (int i = 0; i < errMsgArray.length; ++i) {
                this.list.add(errMsgArray[i].copy(n));
            }
        }
    }

    public ErrMsg[] toArray() {
        return this.list.toArray(new ErrMsg[this.list.size()]);
    }

    public int size() {
        return this.list.size();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public int getKekka() {
        return this.maxKekka;
    }

    public boolean isOK() {
        return this.maxKekka == 0;
    }

    public boolean isSetPgStep() {
        return this.setPgStep;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(200).append(this.getTitle()).append(HybsConst.CR);
        for (ErrMsg errMsg : this.list) {
            stringBuilder.append(errMsg).append(HybsConst.CR);
        }
        return stringBuilder.toString();
    }
}

