﻿/*
 * Copyright (c) 2009 The openGion Project.
 */

/**
 * [概要説明]
 *  親子プルダウンメニューのJavascriptです。
 *  親のプルダウンで選択された値を元に子のプルダウンの内容を自動的に書き換えます。
 *  子プルダウンの再構築に隠しプルダウンを利用しているため最低３つのメニューが必要です。
 *  親オプションのvalue値が隠しプルダウンオプションのvalue値の先頭にある場合に
 *  隠しプルダウンオプションを子プルダウンに追加します。
 *  注）親子メニューは便利ですが、常用する業務システムで使用すると効率の低下を招きます。
 *  対象ユーザや使用頻度を十分に考慮の上で搭載して下さい。
 *
 * [使用例]
 *  両者とも親のプルダウンにJavascriptを適用します。
 *  ①クエリ画面の２つのプルダウンを連動させます。
 *    <og:column name="x1" onChange="setChild(this.form,this,'childName,'hiddenName' )" />
 *
 *  ②一覧画面のそれぞれの行に対して２つのプルダウンを連動させます。
 *    <og:columnEditor name="x2" editor="MENU" onChange="setChild(this.form,this,'childName__$i','hiddenName' )" />
 *
 * @og.rev 3.8.9.1 (2007/07/24)
 * @author 高橋 正和
 * @since IE6
 */

/**
 * [ファンクションの概要]
 * クエリ画面の子のプルダウンメニューを作成します。
 * 親と隠しプルダウンのvalue値を比較しています。
 *
 * @param form 子と隠しプルダウンのあるフォーム
 * @param element 親プルダウンメニュー
 * @param childName 子プルダウンメニューの名前
 * @param hiddenName 隠しプルダウンメニューの名前
 */
function setChild(form,parentElm,childName,hiddenName){
	var index , parentCode , childElement , len , i , j , hiddenElement , hLen , hiddenOptions , neoChildCode , neoChildStr , neoChildIndex ;

	index = parentElm.selectedIndex;
	parentCode = parentElm.options[index].value;	// 大項目コード取得

	// 以下小項目を再構築する
	// まずは小項目を削除
	childElement = document.getElementsByName(childName)[0];	// 先頭を使う。getElem...化
	len = childElement.length ;
	for( i=len-1;i >= 0;i-- ){
		childElement.options[i]=null;
	}

	//隠し小項目から該当要素を追加していく
	hiddenElement = document.getElementsByName(hiddenName)[0];	// 先頭を使う。getElement化。
	hLen = hiddenElement.length;
	hiddenOptions = hiddenElement.options;
	for( j=0;j < hLen; j++){
		neoChildCode = hiddenOptions[j].value;	// 小項目コード取得
		neoChildStr  = hiddenOptions[j].text;	// 子テキスト
		if(neoChildCode.indexOf(parentCode)==0){	// 小項目コードの先頭がparentCodeと同じなら
			neoChildIndex = childElement.length;
			childElement.options[neoChildIndex]=new Option(neoChildStr,neoChildCode);	// 要素追加
		}
	}
}
